/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.messaging.request.MessageWithMetadata;
import org.neo4j.driver.internal.messaging.request.TransactionMetadataBuilder;

public class RunWithMetadataMessage
extends MessageWithMetadata {
    public static final byte SIGNATURE = 16;
    private final String query;
    private final Map<String, Value> parameters;

    public static RunWithMetadataMessage autoCommitTxRunMessage(Query query, TransactionConfig config, DatabaseName databaseName, AccessMode mode, Bookmark bookmark) {
        return RunWithMetadataMessage.autoCommitTxRunMessage(query, config.timeout(), config.metadata(), databaseName, mode, bookmark);
    }

    public static RunWithMetadataMessage autoCommitTxRunMessage(Query query, Duration txTimeout, Map<String, Value> txMetadata, DatabaseName databaseName, AccessMode mode, Bookmark bookmark) {
        Map<String, Value> metadata = TransactionMetadataBuilder.buildMetadata(txTimeout, txMetadata, databaseName, mode, bookmark);
        return new RunWithMetadataMessage(query.text(), query.parameters().asMap(Values.ofValue()), metadata);
    }

    public static RunWithMetadataMessage unmanagedTxRunMessage(Query query) {
        return new RunWithMetadataMessage(query.text(), query.parameters().asMap(Values.ofValue()), Collections.emptyMap());
    }

    private RunWithMetadataMessage(String query, Map<String, Value> parameters, Map<String, Value> metadata) {
        super(metadata);
        this.query = query;
        this.parameters = parameters;
    }

    public String query() {
        return this.query;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    @Override
    public byte signature() {
        return 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunWithMetadataMessage that = (RunWithMetadataMessage)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.metadata(), that.metadata());
    }

    public int hashCode() {
        return Objects.hash(this.query, this.parameters, this.metadata());
    }

    public String toString() {
        return "RUN \"" + this.query + "\" " + this.parameters + " " + this.metadata();
    }
}

