/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.AbstractInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.jupyter.proto.CancelRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.CompletionRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.CompletionResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.ExecuteResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.KernelStatus;
import org.apache.zeppelin.interpreter.jupyter.proto.StatusRequest;
import org.apache.zeppelin.interpreter.jupyter.proto.StatusResponse;
import org.apache.zeppelin.interpreter.jupyter.proto.StopRequest;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.util.InterpreterOutputStream;
import org.apache.zeppelin.interpreter.util.ProcessLauncher;
import org.apache.zeppelin.jupyter.JupyterKernelClient;
import org.apache.zeppelin.jupyter.JupyterZeppelinContext;
import org.apache.zeppelin.jupyter.PythonPackagePredicate;
import org.apache.zeppelin.jupyter.io.grpc.ManagedChannelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JupyterKernelInterpreter
extends AbstractInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JupyterKernelInterpreter.class);
    private JupyterKernelProcessLauncher jupyterKernelProcessLauncher;
    protected JupyterKernelClient jupyterKernelClient;
    protected ZeppelinContext z;
    private String kernel;
    protected File kernelWorkDir;
    protected String pythonExecutable;
    protected String condaEnv;
    private int kernelLaunchTimeout;
    private InterpreterOutputStream interpreterOutput = new InterpreterOutputStream(LOGGER);

    public JupyterKernelInterpreter(String kernel, Properties properties) {
        this(properties);
        this.kernel = kernel;
    }

    public JupyterKernelInterpreter(Properties properties) {
        super(properties);
    }

    public String getKernelName() {
        return this.kernel;
    }

    public List<PythonPackagePredicate<String>> getRequiredPackagesPredicates() {
        ArrayList<PythonPackagePredicate<String>> requiredPackages = new ArrayList<PythonPackagePredicate<String>>();
        requiredPackages.add(new PythonPackagePredicate<String>("jupyter-client or jupyter_client", packages -> packages.contains("jupyter-client ") || packages.contains("jupyter-client=") || packages.contains("jupyter_client ") || packages.contains("jupyter_client=")));
        requiredPackages.add(new PythonPackagePredicate<String>("grpcio", packages -> packages.contains("grpcio ") || packages.contains("grpcio=")));
        requiredPackages.add(new PythonPackagePredicate<String>("protobuf", packages -> packages.contains("protobuf ") || packages.contains("protobuf=")));
        return requiredPackages;
    }

    protected ZeppelinContext buildZeppelinContext() {
        return new JupyterZeppelinContext(null, 1000);
    }

    public void open() throws InterpreterException {
        try {
            if (this.jupyterKernelClient != null) {
                return;
            }
            String envName = this.getProperty("zeppelin.interpreter.conda.env.name");
            this.pythonExecutable = StringUtils.isNotBlank(envName) ? this.activateCondaEnv(envName) : this.getProperty("zeppelin.python", "python");
            LOGGER.info("Python Exec: {}", (Object)this.pythonExecutable);
            String checkPrerequisiteResult = this.checkKernelPrerequisite(this.pythonExecutable);
            if (!StringUtils.isEmpty(checkPrerequisiteResult)) {
                throw new InterpreterException("Kernel prerequisite is not meet: " + checkPrerequisiteResult);
            }
            this.kernelLaunchTimeout = Integer.parseInt(this.getProperty("zeppelin.jupyter.kernel.launch.timeout", "30000"));
            this.z = this.buildZeppelinContext();
            int kernelPort = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
            int messageSize = Integer.parseInt(this.getProperty("zeppelin.jupyter.kernel.grpc.message_size", "33554432"));
            this.jupyterKernelClient = new JupyterKernelClient((ManagedChannelBuilder<?>)((ManagedChannelBuilder)ManagedChannelBuilder.forAddress("127.0.0.1", kernelPort).usePlaintext()).maxInboundMessageSize(messageSize), this.getProperties(), this.kernel);
            this.launchJupyterKernel(kernelPort);
        }
        catch (Exception e) {
            throw new InterpreterException("Fail to open JupyterKernelInterpreter:\n" + ExceptionUtils.getStackTrace(e), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public String checkKernelPrerequisite(String pythonExec) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String activateCondaEnv(String envName) throws IOException {
        LOGGER.info("Activating conda env: {}", (Object)envName);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        PumpStreamHandler psh = new PumpStreamHandler(stdout);
        if (!new File(envName).exists()) {
            throw new IOException("Fail to activating conda env because no environment folder: " + envName);
        }
        File scriptFile = Files.createTempFile("zeppelin_jupyter_kernel_", ".sh", new FileAttribute[0]).toFile();
        try (FileWriter writer = new FileWriter(scriptFile);){
            IOUtils.write(String.format("chmod 777 -R %s \nsource %s/bin/activate \nconda-unpack", envName, envName), (Writer)writer);
        }
        scriptFile.setExecutable(true, false);
        scriptFile.setReadable(true, false);
        CommandLine cmd = new CommandLine(scriptFile.getAbsolutePath());
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler(psh);
        int exitCode = executor.execute(cmd);
        if (exitCode != 0) {
            throw new IOException("Fail to activate conda env, " + stdout.toString());
        }
        LOGGER.info("Activate conda env successfully");
        this.condaEnv = envName;
        return envName + "/bin/python";
    }

    private void launchJupyterKernel(int kernelPort) throws IOException {
        String[] kernelScripts;
        LOGGER.info("Launching Jupyter Kernel at port: {}", (Object)kernelPort);
        this.kernelWorkDir = Files.createTempDirectory("zeppelin_jupyter_kernel_" + this.getKernelName(), new FileAttribute[0]).toFile();
        for (String kernelScript : kernelScripts = new String[]{"kernel_server.py", "kernel_pb2.py", "kernel_pb2_grpc.py"}) {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("grpc/jupyter/" + kernelScript);
            FileUtils.copyURLToFile(url, new File(this.kernelWorkDir, kernelScript));
        }
        CommandLine cmd = CommandLine.parse(this.pythonExecutable);
        cmd.addArgument(this.kernelWorkDir.getAbsolutePath() + "/kernel_server.py");
        cmd.addArgument(this.getKernelName());
        cmd.addArgument(String.valueOf(kernelPort));
        Map<String, String> envs = this.setupKernelEnv();
        this.jupyterKernelProcessLauncher = new JupyterKernelProcessLauncher(cmd, envs);
        this.jupyterKernelProcessLauncher.launch();
        this.jupyterKernelProcessLauncher.waitForReady(this.kernelLaunchTimeout);
        if (this.jupyterKernelProcessLauncher.isLaunchTimeout()) {
            throw new IOException("Fail to launch Jupyter Kernel in " + this.kernelLaunchTimeout / 1000 + " seconds.\n" + this.jupyterKernelProcessLauncher.getErrorMessage());
        }
        if (!this.jupyterKernelProcessLauncher.isRunning()) {
            throw new IOException("Fail to launch Jupyter Kernel as the python process is failed.\n" + this.jupyterKernelProcessLauncher.getErrorMessage());
        }
    }

    protected Map<String, String> setupKernelEnv() throws IOException {
        return EnvironmentUtils.getProcEnvironment();
    }

    public JupyterKernelProcessLauncher getKernelProcessLauncher() {
        return this.jupyterKernelProcessLauncher;
    }

    public void close() throws InterpreterException {
        if (this.jupyterKernelProcessLauncher != null) {
            LOGGER.info("Shutdown Jupyter Kernel Process");
            if (this.jupyterKernelProcessLauncher.isRunning()) {
                this.jupyterKernelClient.stop(StopRequest.newBuilder().build());
                try {
                    this.jupyterKernelClient.shutdown();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Exception happens when shutting down jupyter kernel client", e);
                }
            }
            this.jupyterKernelProcessLauncher.stop();
            this.jupyterKernelProcessLauncher = null;
            LOGGER.info("Jupyter Kernel is killed");
        }
    }

    public InterpreterResult internalInterpret(String st, InterpreterContext context) throws InterpreterException {
        this.z.setGui(context.getGui());
        this.z.setNoteGui(context.getNoteGui());
        this.z.setInterpreterContext(context);
        this.interpreterOutput.setInterpreterOutput(context.out);
        this.jupyterKernelClient.setInterpreterContext(context);
        try {
            ExecuteResponse response = this.jupyterKernelClient.stream_execute(ExecuteRequest.newBuilder().setCode(st).build(), this.interpreterOutput);
            this.interpreterOutput.getInterpreterOutput().flush();
            if (this.jupyterKernelProcessLauncher.isRunning() && !this.jupyterKernelClient.isMaybeKernelFailed()) {
                return new InterpreterResult(InterpreterResult.Code.valueOf((String)response.getStatus().name()));
            }
            if (this.jupyterKernelClient.isMaybeKernelFailed()) {
                Thread.sleep(1000L);
            }
            if (this.jupyterKernelProcessLauncher.isRunning()) {
                return new InterpreterResult(InterpreterResult.Code.valueOf((String)response.getStatus().name()));
            }
            return new InterpreterResult(InterpreterResult.Code.ERROR, "IPython kernel is abnormally exited, please check your code and log.");
        }
        catch (Exception e) {
            throw new InterpreterException("Fail to interpret python code", (Throwable)e);
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        this.jupyterKernelClient.cancel(CancelRequest.newBuilder().build());
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        LOGGER.debug("Call completion for: {}, cursor: {}", (Object)buf, (Object)cursor);
        ArrayList<InterpreterCompletion> completions = new ArrayList<InterpreterCompletion>();
        CompletionRequest.getDefaultInstance();
        CompletionResponse response = this.jupyterKernelClient.complete(CompletionRequest.newBuilder().setCode(buf).setCursor(cursor).build());
        for (int i = 0; i < response.getMatchesCount(); ++i) {
            String match = response.getMatches(i);
            int lastIndexOfDot = match.lastIndexOf(".");
            if (lastIndexOfDot != -1) {
                match = match.substring(lastIndexOfDot + 1);
            }
            LOGGER.debug("Candidate completion: {}", (Object)match);
            completions.add(new InterpreterCompletion(match, match, ""));
        }
        return completions;
    }

    public ZeppelinContext getZeppelinContext() {
        return this.z;
    }

    public class JupyterKernelProcessLauncher
    extends ProcessLauncher {
        JupyterKernelProcessLauncher(CommandLine commandLine, Map<String, String> envs) {
            super(commandLine, envs);
        }

        public void waitForReady(int timeout) {
            long startTime = System.currentTimeMillis();
            while (this.state == ProcessLauncher.State.LAUNCHED) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupted by something", e);
                }
                try {
                    StatusResponse response = JupyterKernelInterpreter.this.jupyterKernelClient.status(StatusRequest.newBuilder().build());
                    if (response.getStatus() == KernelStatus.RUNNING) {
                        LOGGER.info("Jupyter Kernel is Running");
                        this.onProcessRunning();
                        break;
                    }
                    LOGGER.info("Wait for Jupyter Kernel to be started");
                }
                catch (Exception e) {
                    LOGGER.info("Wait for Jupyter Kernel to be started");
                }
                if (System.currentTimeMillis() - startTime <= (long)timeout) continue;
                this.onTimeout();
                break;
            }
        }
    }
}

