/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;

public abstract class AbstractInterpreter
extends Interpreter {
    private static final Pattern VARIABLES = Pattern.compile("([^{}]*)([{]+[^{}]*[}]+)(.*)", 32);
    private static final Pattern VARIABLE_IN_BRACES = Pattern.compile("[{][^{}]+[}]");
    private static final Pattern VARIABLE_IN_DOUBLE_BRACES = Pattern.compile("[{]{2}[^{}]+[}]{2}");

    public AbstractInterpreter(Properties properties) {
        super(properties);
    }

    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        boolean interpolate;
        InterpreterContext.set(context);
        ZeppelinContext z = this.getZeppelinContext();
        if (z != null) {
            z.setGui(context.getGui());
            z.setNoteGui(context.getNoteGui());
            z.setInterpreterContext(context);
        }
        boolean bl = interpolate = this.isInterpolate() || Boolean.parseBoolean(context.getLocalProperties().getOrDefault("interpolate", "false"));
        if (interpolate) {
            st = AbstractInterpreter.interpolate(st, context.getResourcePool());
        }
        return this.internalInterpret(st, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String interpolate(String cmd, ResourcePool resourcePool) {
        Matcher m;
        StringBuilder sb = new StringBuilder();
        String st = cmd;
        while ((m = VARIABLES.matcher(st)).matches()) {
            sb.append(m.group(1));
            String varPat = m.group(2);
            if (VARIABLE_IN_BRACES.matcher(varPat).matches()) {
                Object variableValue;
                Resource resource = resourcePool.get(varPat.substring(1, varPat.length() - 1));
                Object object = variableValue = resource == null ? null : resource.get();
                if (variableValue == null) return cmd;
                sb.append(variableValue);
            } else {
                if (!VARIABLE_IN_DOUBLE_BRACES.matcher(varPat).matches()) return cmd;
                sb.append("{").append(varPat, 2, varPat.length() - 2).append("}");
            }
            st = m.group(3);
        }
        sb.append(st);
        return sb.toString();
    }

    public abstract ZeppelinContext getZeppelinContext();

    protected boolean isInterpolate() {
        return false;
    }

    protected abstract InterpreterResult internalInterpret(String var1, InterpreterContext var2) throws InterpreterException;

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        return new ArrayList<InterpreterCompletion>();
    }
}

