/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.BindingProcessor;
import org.elasticsearch.common.inject.InheritingState;
import org.elasticsearch.common.inject.Initializer;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.MembersInjectorStore;
import org.elasticsearch.common.inject.MessageProcessor;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.PrivateElementProcessor;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.ScopeBindingProcessor;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.inject.Stage;
import org.elasticsearch.common.inject.State;
import org.elasticsearch.common.inject.TypeConverterBindingProcessor;
import org.elasticsearch.common.inject.TypeListenerBindingProcessor;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.internal.InternalFactory;
import org.elasticsearch.common.inject.internal.PrivateElementsImpl;
import org.elasticsearch.common.inject.internal.ProviderInstanceBindingImpl;
import org.elasticsearch.common.inject.internal.Scoping;
import org.elasticsearch.common.inject.internal.SourceProvider;
import org.elasticsearch.common.inject.internal.Stopwatch;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.Elements;
import org.elasticsearch.common.inject.spi.InjectionPoint;
import org.elasticsearch.common.inject.spi.PrivateElements;
import org.elasticsearch.common.inject.spi.TypeListenerBinding;

class InjectorShell {
    private final List<Element> elements;
    private final InjectorImpl injector;
    private final PrivateElements privateElements;

    private InjectorShell(Builder builder, List<Element> elements, InjectorImpl injector) {
        this.privateElements = builder.privateElements;
        this.elements = elements;
        this.injector = injector;
    }

    PrivateElements getPrivateElements() {
        return this.privateElements;
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    List<Element> getElements() {
        return this.elements;
    }

    private static void bindInjector(InjectorImpl injector) {
        Key<Injector> key = Key.get(Injector.class);
        InjectorFactory injectorFactory = new InjectorFactory(injector);
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Injector>(injector, key, SourceProvider.UNKNOWN_SOURCE, injectorFactory, Scoping.UNSCOPED, injectorFactory, ImmutableSet.of()));
    }

    private static void bindLogger(InjectorImpl injector) {
        Key<Logger> key = Key.get(Logger.class);
        LoggerFactory loggerFactory = new LoggerFactory();
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Logger>(injector, key, SourceProvider.UNKNOWN_SOURCE, loggerFactory, Scoping.UNSCOPED, loggerFactory, ImmutableSet.of()));
    }

    private static class RootModule
    implements Module {
        final Stage stage;

        private RootModule(Stage stage) {
            this.stage = Preconditions.checkNotNull(stage, "stage");
        }

        @Override
        public void configure(Binder binder) {
            binder = binder.withSource(SourceProvider.UNKNOWN_SOURCE);
            binder.bind(Stage.class).toInstance(this.stage);
            binder.bindScope(Singleton.class, Scopes.SINGLETON);
        }
    }

    private static class LoggerFactory
    implements InternalFactory<Logger>,
    Provider<Logger> {
        private LoggerFactory() {
        }

        @Override
        public Logger get(Errors errors, InternalContext context, Dependency<?> dependency) {
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            return injectionPoint == null ? Logger.getAnonymousLogger() : Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
        }

        @Override
        public Logger get() {
            return Logger.getAnonymousLogger();
        }

        public String toString() {
            return "Provider<Logger>";
        }
    }

    private static class InjectorFactory
    implements InternalFactory<Injector>,
    Provider<Injector> {
        private final Injector injector;

        private InjectorFactory(Injector injector) {
            this.injector = injector;
        }

        @Override
        public Injector get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
            return this.injector;
        }

        @Override
        public Injector get() {
            return this.injector;
        }

        public String toString() {
            return "Provider<Injector>";
        }
    }

    static class Builder {
        private final List<Element> elements = new ArrayList<Element>();
        private final List<Module> modules = new ArrayList<Module>();
        private State state;
        private InjectorImpl parent;
        private Stage stage;
        private PrivateElementsImpl privateElements;

        Builder() {
        }

        Builder parent(InjectorImpl parent) {
            this.parent = parent;
            this.state = new InheritingState(parent.state);
            return this;
        }

        Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        Builder privateElements(PrivateElements privateElements) {
            this.privateElements = (PrivateElementsImpl)privateElements;
            this.elements.addAll(privateElements.getElements());
            return this;
        }

        void addModules(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                this.modules.add(module);
            }
        }

        Object lock() {
            return this.getState().lock();
        }

        List<InjectorShell> build(Initializer initializer, BindingProcessor bindingProcessor, Stopwatch stopwatch, Errors errors) {
            Preconditions.checkState(this.stage != null, "Stage not initialized");
            Preconditions.checkState(this.privateElements == null || this.parent != null, "PrivateElements with no parent");
            Preconditions.checkState(this.state != null, "no state. Did you remember to lock() ?");
            InjectorImpl injector = new InjectorImpl(this.parent, this.state, initializer);
            if (this.privateElements != null) {
                this.privateElements.initInjector(injector);
            }
            if (this.parent == null) {
                this.modules.add(0, new RootModule(this.stage));
                new TypeConverterBindingProcessor(errors).prepareBuiltInConverters(injector);
            }
            this.elements.addAll(Elements.getElements(this.stage, this.modules));
            stopwatch.resetAndLog("Module execution");
            new MessageProcessor(errors).process(injector, this.elements);
            new TypeListenerBindingProcessor(errors).process(injector, this.elements);
            List<TypeListenerBinding> listenerBindings = injector.state.getTypeListenerBindings();
            injector.membersInjectorStore = new MembersInjectorStore(injector, listenerBindings);
            stopwatch.resetAndLog("TypeListeners creation");
            new ScopeBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Scopes creation");
            new TypeConverterBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Converters creation");
            InjectorShell.bindInjector(injector);
            InjectorShell.bindLogger(injector);
            bindingProcessor.process(injector, this.elements);
            stopwatch.resetAndLog("Binding creation");
            ArrayList<InjectorShell> injectorShells = new ArrayList<InjectorShell>();
            injectorShells.add(new InjectorShell(this, this.elements, injector));
            PrivateElementProcessor processor = new PrivateElementProcessor(errors, this.stage);
            processor.process(injector, this.elements);
            for (Builder builder : processor.getInjectorShellBuilders()) {
                injectorShells.addAll(builder.build(initializer, bindingProcessor, stopwatch, errors));
            }
            stopwatch.resetAndLog("Private environment creation");
            return injectorShells;
        }

        private State getState() {
            if (this.state == null) {
                this.state = new InheritingState(State.NONE);
            }
            return this.state;
        }
    }
}

