/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.XFilteredDocIdSetIterator;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.IndexCacheableQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

@Deprecated
@SuppressForbidden(reason="Old p/c queries still use filters")
public final class ChildrenQuery
extends IndexCacheableQuery {
    protected final ParentChildIndexFieldData ifd;
    protected final String parentType;
    protected final String childType;
    protected final Filter parentFilter;
    protected final ScoreType scoreType;
    protected Query childQuery;
    protected final int minChildren;
    protected final int maxChildren;
    protected final int shortCircuitParentDocSet;
    protected final BitSetProducer nonNestedDocsFilter;

    public ChildrenQuery(ParentChildIndexFieldData ifd, String parentType, String childType, Filter parentFilter, Query childQuery, ScoreType scoreType, int minChildren, int maxChildren, int shortCircuitParentDocSet, BitSetProducer nonNestedDocsFilter) {
        this.ifd = ifd;
        this.parentType = parentType;
        this.childType = childType;
        this.parentFilter = parentFilter;
        this.childQuery = childQuery;
        this.scoreType = scoreType;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
        assert (maxChildren == 0 || minChildren <= maxChildren);
        this.minChildren = minChildren > 1 ? minChildren : 0;
        this.maxChildren = maxChildren;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query childRewritten = this.childQuery.rewrite(reader);
        if (childRewritten != this.childQuery) {
            ChildrenQuery rewritten = new ChildrenQuery(this.ifd, this.parentType, this.childType, this.parentFilter, childRewritten, this.scoreType, this.minChildren, this.maxChildren, this.shortCircuitParentDocSet, this.nonNestedDocsFilter);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ChildrenQuery that = (ChildrenQuery)obj;
        if (!this.childQuery.equals(that.childQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        if (this.minChildren != that.minChildren) {
            return false;
        }
        return this.maxChildren == that.maxChildren;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.childQuery.hashCode();
        result = 31 * result + this.childType.hashCode();
        result = 31 * result + this.minChildren;
        result = 31 * result + this.maxChildren;
        return result;
    }

    @Override
    public String toString(String field) {
        int max = this.maxChildren == 0 ? Integer.MAX_VALUE : this.maxChildren;
        return "ChildrenQuery[min(" + Integer.toString(this.minChildren) + ") max(" + Integer.toString(max) + ")of " + this.childType + "/" + this.parentType + "](" + this.childQuery.toString(field) + ')' + ToStringUtils.boost(this.getBoost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Weight doCreateWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        block20: {
            block21: {
                if (searcher.getIndexReader().numDocs() == 0) {
                    return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
                }
                sc = SearchContext.current();
                globalIfd = this.ifd.loadGlobal((DirectoryReader)searcher.getIndexReader());
                if (globalIfd == null) {
                    return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
                }
                abort = true;
                collector = null;
                try {
                    if (this.minChildren == 0 && this.maxChildren == 0 && this.scoreType != ScoreType.NONE) {
                        switch (1.$SwitchMap$org$elasticsearch$index$search$child$ScoreType[this.scoreType.ordinal()]) {
                            case 1: {
                                collector = new MinCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 2: {
                                collector = new MaxCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 3: {
                                collector = new SumCollector(globalIfd, sc, this.parentType);
                            }
                        }
                    }
                    if (collector == null) {
                        switch (1.$SwitchMap$org$elasticsearch$index$search$child$ScoreType[this.scoreType.ordinal()]) {
                            case 1: {
                                collector = new MinCountCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 2: {
                                collector = new MaxCountCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 3: 
                            case 4: {
                                collector = new SumCountAndAvgCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 5: {
                                collector = new CountCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Are we missing a score type here? -- " + (Object)this.scoreType);
                            }
                        }
                    }
                    searcher.search(this.childQuery, collector);
                    numFoundParents = collector.foundParents();
                    if (numFoundParents != 0L) break block20;
                    var9_8 = new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
                    if (!abort) break block21;
                }
                catch (Throwable var10_10) {
                    if (abort) {
                        Releasables.close(new Releasable[]{collector});
                    }
                    throw var10_10;
                }
                Releasables.close(new Releasable[]{collector});
            }
            return var9_8;
        }
        abort = false;
        ** if (!abort) goto lbl54
lbl-1000:
        // 1 sources

        {
            Releasables.close(new Releasable[]{collector});
        }
        {
        }
lbl54:
        // 2 sources

        sc.addReleasable(collector, SearchContext.Lifetime.COLLECTION);
        parentFilter = numFoundParents <= (long)this.shortCircuitParentDocSet ? ParentIdsFilter.createShortCircuitFilter(this.nonNestedDocsFilter, sc, this.parentType, collector.values, collector.parentIdxs, numFoundParents) : this.parentFilter;
        return new ParentWeight(this, this.childQuery.createWeight(searcher, needsScores), parentFilter, numFoundParents, collector, this.minChildren, this.maxChildren);
    }

    private static final class CountParentOrdIterator
    extends XFilteredDocIdSetIterator {
        private final LongHash parentIds;
        protected final IntArray occurrences;
        private final int minChildren;
        private final int maxChildren;
        private final SortedDocValues ordinals;
        private final ParentWeight parentWeight;

        private CountParentOrdIterator(ParentWeight parentWeight, DocIdSetIterator innerIterator, ParentCollector collector, SortedDocValues ordinals, int minChildren, int maxChildren) {
            super(innerIterator);
            this.parentIds = ((CountCollector)collector).parentIdxs;
            this.occurrences = ((CountCollector)collector).occurrences;
            this.ordinals = ordinals;
            this.parentWeight = parentWeight;
            this.minChildren = minChildren;
            this.maxChildren = maxChildren == 0 ? Integer.MAX_VALUE : maxChildren;
        }

        @Override
        protected boolean match(int doc) {
            long parentIdx;
            if (this.parentWeight.remaining == 0L) {
                throw new CollectionTerminatedException();
            }
            long parentOrd = this.ordinals.getOrd(doc);
            if (parentOrd >= 0L && (parentIdx = this.parentIds.find(parentOrd)) != -1L) {
                --this.parentWeight.remaining;
                int count = this.occurrences.get(parentIdx);
                if (count >= this.minChildren && count <= this.maxChildren) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class AvgParentCountScorer
    extends ParentCountScorer {
        AvgParentCountScorer(ParentWeight weight, DocIdSetIterator parentsIterator, ParentCollector collector, SortedDocValues globalOrdinals, int minChildren, int maxChildren) {
            super(weight, parentsIterator, collector, globalOrdinals, minChildren, maxChildren);
        }

        @Override
        protected boolean acceptAndScore(long parentIdx) {
            int count = this.occurrences.get(parentIdx);
            if (count < this.minChildren || count > this.maxChildren) {
                return false;
            }
            this.currentScore = this.scores.get(parentIdx);
            this.currentScore /= (float)this.occurrences.get(parentIdx);
            return true;
        }
    }

    private static final class AvgParentScorer
    extends ParentCountScorer {
        AvgParentScorer(ParentWeight weight, DocIdSetIterator parentsIterator, ParentCollector collector, SortedDocValues globalOrdinals) {
            super(weight, parentsIterator, collector, globalOrdinals, 0, 0);
        }

        @Override
        protected boolean acceptAndScore(long parentIdx) {
            this.currentScore = this.scores.get(parentIdx);
            this.currentScore /= (float)this.occurrences.get(parentIdx);
            return true;
        }
    }

    private static class ParentCountScorer
    extends ParentScorer {
        protected final IntArray occurrences;
        protected final int minChildren;
        protected final int maxChildren;

        ParentCountScorer(ParentWeight parentWeight, DocIdSetIterator parentsIterator, ParentCollector collector, SortedDocValues globalOrdinals, int minChildren, int maxChildren) {
            super(parentWeight, parentsIterator, (ParentScoreCollector)collector, globalOrdinals);
            this.minChildren = minChildren;
            this.maxChildren = maxChildren == 0 ? Integer.MAX_VALUE : maxChildren;
            this.occurrences = ((ParentScoreCountCollector)collector).occurrences;
        }

        @Override
        protected boolean acceptAndScore(long parentIdx) {
            int count = this.occurrences.get(parentIdx);
            if (count < this.minChildren || count > this.maxChildren) {
                return false;
            }
            return super.acceptAndScore(parentIdx);
        }
    }

    private static class ParentScorer
    extends Scorer {
        final ParentWeight parentWeight;
        final LongHash parentIds;
        final FloatArray scores;
        final SortedDocValues globalOrdinals;
        final DocIdSetIterator parentsIterator;
        int currentDocId = -1;
        float currentScore;

        ParentScorer(ParentWeight parentWeight, DocIdSetIterator parentsIterator, ParentCollector collector, SortedDocValues globalOrdinals) {
            super(parentWeight);
            this.parentWeight = parentWeight;
            this.globalOrdinals = globalOrdinals;
            this.parentsIterator = parentsIterator;
            this.parentIds = collector.parentIdxs;
            this.scores = ((ParentScoreCollector)collector).scores;
        }

        @Override
        public float score() throws IOException {
            return this.currentScore;
        }

        protected boolean acceptAndScore(long parentIdx) {
            this.currentScore = this.scores.get(parentIdx);
            return true;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public int docID() {
            return this.currentDocId;
        }

        @Override
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){

                @Override
                public int docID() {
                    return ParentScorer.this.currentDocId;
                }

                @Override
                public int nextDoc() throws IOException {
                    if (ParentScorer.this.parentWeight.remaining == 0L) {
                        ParentScorer.this.currentDocId = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    while (true) {
                        long parentIdx;
                        ParentScorer.this.currentDocId = ParentScorer.this.parentsIterator.nextDoc();
                        if (ParentScorer.this.currentDocId == Integer.MAX_VALUE) {
                            return ParentScorer.this.currentDocId;
                        }
                        int globalOrdinal = ParentScorer.this.globalOrdinals.getOrd(ParentScorer.this.currentDocId);
                        if (globalOrdinal < 0 || (parentIdx = ParentScorer.this.parentIds.find(globalOrdinal)) == -1L) continue;
                        --ParentScorer.this.parentWeight.remaining;
                        if (ParentScorer.this.acceptAndScore(parentIdx)) break;
                    }
                    return ParentScorer.this.currentDocId;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (ParentScorer.this.parentWeight.remaining == 0L) {
                        ParentScorer.this.currentDocId = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    ParentScorer.this.currentDocId = ParentScorer.this.parentsIterator.advance(target);
                    if (ParentScorer.this.currentDocId == Integer.MAX_VALUE) {
                        return ParentScorer.this.currentDocId;
                    }
                    long globalOrdinal = ParentScorer.this.globalOrdinals.getOrd(ParentScorer.this.currentDocId);
                    if (globalOrdinal < 0L) {
                        return this.nextDoc();
                    }
                    long parentIdx = ParentScorer.this.parentIds.find(globalOrdinal);
                    if (parentIdx != -1L) {
                        --ParentScorer.this.parentWeight.remaining;
                        if (ParentScorer.this.acceptAndScore(parentIdx)) {
                            return ParentScorer.this.currentDocId;
                        }
                    }
                    return this.nextDoc();
                }

                @Override
                public long cost() {
                    return ParentScorer.this.parentsIterator.cost();
                }
            };
        }
    }

    private static final class SumCountAndAvgCollector
    extends ParentScoreCountCollector {
        SumCountAndAvgCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            this.scores.increment(parentIdx, this.scorer.score());
            this.occurrences.increment(parentIdx, 1);
        }
    }

    private static final class MinCountCollector
    extends ParentScoreCountCollector {
        private MinCountCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore < this.scores.get(parentIdx)) {
                this.scores.set(parentIdx, currentScore);
            }
            this.occurrences.increment(parentIdx, 1);
        }
    }

    private static final class MaxCountCollector
    extends ParentScoreCountCollector {
        private MaxCountCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore > this.scores.get(parentIdx)) {
                this.scores.set(parentIdx, currentScore);
            }
            this.occurrences.increment(parentIdx, 1);
        }
    }

    private static final class MinCollector
    extends ParentScoreCollector {
        private MinCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore < this.scores.get(parentIdx)) {
                this.scores.set(parentIdx, currentScore);
            }
        }
    }

    private static final class MaxCollector
    extends ParentScoreCollector {
        private MaxCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore > this.scores.get(parentIdx)) {
                this.scores.set(parentIdx, currentScore);
            }
        }
    }

    private static final class SumCollector
    extends ParentScoreCollector {
        private SumCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            this.scores.increment(parentIdx, this.scorer.score());
        }
    }

    private static final class CountCollector
    extends ParentCollector
    implements Releasable {
        protected IntArray occurrences;

        protected CountCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
            this.occurrences = this.bigArrays.newIntArray(512L, false);
        }

        @Override
        protected void newParent(long parentIdx) throws IOException {
            this.occurrences = this.bigArrays.grow(this.occurrences, parentIdx + 1L);
            this.occurrences.set(parentIdx, 1);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            this.occurrences.increment(parentIdx, 1);
        }

        @Override
        public void close() {
            Releasables.close(this.parentIdxs, this.occurrences);
        }
    }

    protected static abstract class ParentScoreCountCollector
    extends ParentScoreCollector
    implements Releasable {
        protected IntArray occurrences;

        protected ParentScoreCountCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
            this.occurrences = this.bigArrays.newIntArray(512L, false);
        }

        @Override
        protected void newParent(long parentIdx) throws IOException {
            this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
            this.scores.set(parentIdx, this.scorer.score());
            this.occurrences = this.bigArrays.grow(this.occurrences, parentIdx + 1L);
            this.occurrences.set(parentIdx, 1);
        }

        @Override
        public void close() {
            Releasables.close(this.parentIdxs, this.scores, this.occurrences);
        }
    }

    protected static abstract class ParentScoreCollector
    extends ParentCollector
    implements Releasable {
        protected FloatArray scores;

        protected ParentScoreCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
            this.scores = this.bigArrays.newFloatArray(512L, false);
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        protected void newParent(long parentIdx) throws IOException {
            this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
            this.scores.set(parentIdx, this.scorer.score());
        }

        @Override
        public void close() {
            Releasables.close(this.parentIdxs, this.scores);
        }
    }

    protected static abstract class ParentCollector
    extends SimpleCollector
    implements Releasable {
        protected final IndexParentChildFieldData globalIfd;
        protected final LongHash parentIdxs;
        protected final BigArrays bigArrays;
        protected final SearchContext searchContext;
        protected final String parentType;
        protected SortedDocValues values;
        protected Scorer scorer;

        protected ParentCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            this.globalIfd = globalIfd;
            this.searchContext = searchContext;
            this.bigArrays = searchContext.bigArrays();
            this.parentIdxs = new LongHash(512L, this.bigArrays);
            this.parentType = parentType;
        }

        @Override
        public final void collect(int doc) throws IOException {
            long globalOrdinal;
            if (this.values != null && (globalOrdinal = (long)this.values.getOrd(doc)) >= 0L) {
                long parentIdx = this.parentIdxs.add(globalOrdinal);
                if (parentIdx >= 0L) {
                    this.newParent(parentIdx);
                } else {
                    parentIdx = -1L - parentIdx;
                    this.existingParent(parentIdx);
                }
            }
        }

        protected void newParent(long parentIdx) throws IOException {
        }

        protected void existingParent(long parentIdx) throws IOException {
        }

        public long foundParents() {
            return this.parentIdxs.size();
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.values = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(this.parentType);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public void close() {
            Releasables.close(this.parentIdxs);
        }
    }

    @SuppressForbidden(reason="Old p/c queries still use filters")
    protected class ParentWeight
    extends Weight {
        protected final Weight childWeight;
        protected final Filter parentFilter;
        protected final ParentCollector collector;
        protected final int minChildren;
        protected final int maxChildren;
        protected long remaining;
        protected float queryNorm;
        protected float queryWeight;

        protected ParentWeight(Query query, Weight childWeight, Filter parentFilter, long remaining, ParentCollector collector, int minChildren, int maxChildren) {
            super(query);
            this.childWeight = childWeight;
            this.parentFilter = parentFilter;
            this.remaining = remaining;
            this.collector = collector;
            this.minChildren = minChildren;
            this.maxChildren = maxChildren;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return Explanation.match(ChildrenQuery.this.getBoost(), "not implemented yet...", new Explanation[0]);
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            this.queryWeight = ChildrenQuery.this.getBoost();
            if (ChildrenQuery.this.scoreType == ScoreType.NONE) {
                return this.queryWeight * this.queryWeight;
            }
            float sum = this.childWeight.getValueForNormalization();
            return sum *= this.queryWeight * this.queryWeight;
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSet parentsSet = this.parentFilter.getDocIdSet(context, null);
            if (Lucene.isEmpty(parentsSet) || this.remaining == 0L) {
                return null;
            }
            DocIdSetIterator parents = BitsFilteredDocIdSet.wrap(parentsSet, context.reader().getLiveDocs()).iterator();
            if (parents != null) {
                SortedDocValues bytesValues = ((AtomicParentChildFieldData)this.collector.globalIfd.load(context)).getOrdinalsValues(ChildrenQuery.this.parentType);
                if (bytesValues == null) {
                    return null;
                }
                if (this.minChildren > 0 || this.maxChildren != 0 || ChildrenQuery.this.scoreType == ScoreType.NONE) {
                    switch (ChildrenQuery.this.scoreType) {
                        case NONE: {
                            CountParentOrdIterator parentIdIterator = new CountParentOrdIterator(this, parents, this.collector, bytesValues, this.minChildren, this.maxChildren);
                            return ConstantScorer.create(parentIdIterator, this, this.queryWeight);
                        }
                        case AVG: {
                            return new AvgParentCountScorer(this, parents, this.collector, bytesValues, this.minChildren, this.maxChildren);
                        }
                    }
                    return new ParentCountScorer(this, parents, this.collector, bytesValues, this.minChildren, this.maxChildren);
                }
                switch (ChildrenQuery.this.scoreType) {
                    case AVG: {
                        return new AvgParentScorer(this, parents, this.collector, bytesValues);
                    }
                }
                return new ParentScorer(this, parents, this.collector, bytesValues);
            }
            return null;
        }
    }
}

