/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.local.LocalTransport;
import org.elasticsearch.transport.netty.NettyTransport;

public class TransportModule
extends AbstractModule {
    public static final String TRANSPORT_TYPE_KEY = "transport.type";
    public static final String TRANSPORT_SERVICE_TYPE_KEY = "transport.service.type";
    public static final String LOCAL_TRANSPORT = "local";
    public static final String NETTY_TRANSPORT = "netty";
    private final ESLogger logger;
    private final Settings settings;
    private final Map<String, Class<? extends TransportService>> transportServices = Maps.newHashMap();
    private final Map<String, Class<? extends Transport>> transports = Maps.newHashMap();
    private final NamedWriteableRegistry namedWriteableRegistry;
    private Class<? extends TransportService> configuredTransportService;
    private Class<? extends Transport> configuredTransport;
    private String configuredTransportServiceSource;
    private String configuredTransportSource;

    public TransportModule(Settings settings, NamedWriteableRegistry namedWriteableRegistry) {
        this.settings = settings;
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
        this.addTransport(LOCAL_TRANSPORT, LocalTransport.class);
        this.addTransport(NETTY_TRANSPORT, NettyTransport.class);
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    public void addTransportService(String name, Class<? extends TransportService> clazz) {
        Class<? extends TransportService> oldClazz = this.transportServices.put(name, clazz);
        if (oldClazz != null) {
            throw new IllegalArgumentException("Cannot register TransportService [" + name + "] to " + clazz.getName() + ", already registered to " + oldClazz.getName());
        }
    }

    public void addTransport(String name, Class<? extends Transport> clazz) {
        Class<? extends Transport> oldClazz = this.transports.put(name, clazz);
        if (oldClazz != null) {
            throw new IllegalArgumentException("Cannot register Transport [" + name + "] to " + clazz.getName() + ", already registered to " + oldClazz.getName());
        }
    }

    @Override
    protected void configure() {
        if (this.configuredTransportService != null) {
            this.logger.info("Using [{}] as transport service, overridden by [{}]", this.configuredTransportService.getName(), this.configuredTransportServiceSource);
            this.bind(TransportService.class).to(this.configuredTransportService).asEagerSingleton();
        } else {
            String typeName = this.settings.get(TRANSPORT_SERVICE_TYPE_KEY);
            if (typeName == null) {
                this.bind(TransportService.class).asEagerSingleton();
            } else {
                if (!this.transportServices.containsKey(typeName)) {
                    throw new IllegalArgumentException("Unknown TransportService type [" + typeName + "], known types are: " + this.transportServices.keySet());
                }
                this.bind(TransportService.class).to(this.transportServices.get(typeName)).asEagerSingleton();
            }
        }
        this.bind(NamedWriteableRegistry.class).toInstance(this.namedWriteableRegistry);
        if (this.configuredTransport != null) {
            this.logger.info("Using [{}] as transport, overridden by [{}]", this.configuredTransport.getName(), this.configuredTransportSource);
            this.bind(Transport.class).to(this.configuredTransport).asEagerSingleton();
        } else {
            String defaultType = DiscoveryNode.localNode(this.settings) ? LOCAL_TRANSPORT : NETTY_TRANSPORT;
            String typeName = this.settings.get(TRANSPORT_TYPE_KEY, defaultType);
            Class<? extends Transport> clazz = this.transports.get(typeName);
            if (clazz == null) {
                throw new IllegalArgumentException("Unknown Transport [" + typeName + "]");
            }
            this.bind(Transport.class).to(clazz).asEagerSingleton();
        }
    }

    public void setTransportService(Class<? extends TransportService> transportService, String source) {
        Preconditions.checkNotNull(transportService, "Configured transport service may not be null");
        Preconditions.checkNotNull(source, "Plugin, that changes transport service may not be null");
        this.configuredTransportService = transportService;
        this.configuredTransportServiceSource = source;
    }

    public void setTransport(Class<? extends Transport> transport, String source) {
        Preconditions.checkNotNull(transport, "Configured transport may not be null");
        Preconditions.checkNotNull(source, "Plugin, that changes transport may not be null");
        this.configuredTransport = transport;
        this.configuredTransportSource = source;
    }
}

