/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.util.Collections;
import java.util.List;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;

public class NotebookRepoWithSettings {
    public static final NotebookRepoWithSettings EMPTY = NotebookRepoWithSettings.builder("").build();
    public String name;
    public String className;
    public List<NotebookRepoSettingsInfo> settings;

    private NotebookRepoWithSettings() {
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private NotebookRepoWithSettings(Builder builder) {
        this.name = builder.name;
        this.className = builder.className;
        this.settings = builder.settings;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public static class Builder {
        private final String name;
        private String className = "";
        private List<NotebookRepoSettingsInfo> settings = Collections.emptyList();

        public Builder(String name) {
            this.name = name;
        }

        public NotebookRepoWithSettings build() {
            return new NotebookRepoWithSettings(this);
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder settings(List<NotebookRepoSettingsInfo> settings) {
            this.settings = settings;
            return this;
        }
    }
}

