/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering;

import com.spotify.docker.client.shaded.javax.ws.rs.RuntimeType;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Configuration;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Feature;
import com.spotify.docker.client.shaded.javax.ws.rs.core.FeatureContext;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.CommonScopeProvider;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.DefaultEntityProcessor;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.EntityFilteringBinder;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.EntityFilteringProcessor;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.EntityFilteringScopeResolver;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.SecurityEntityFilteringFeature;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.SelectableEntityFilteringFeature;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.ServerScopeProvider;

public final class EntityFilteringFeature
implements Feature {
    public static final String ENTITY_FILTERING_SCOPE = "jersey.config.entityFiltering.scope";

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        if (!config.isRegistered(EntityFilteringProcessor.class)) {
            if (!config.isRegistered(EntityFilteringBinder.class)) {
                context.register(new EntityFilteringBinder());
            }
            context.register(EntityFilteringProcessor.class);
            if (!config.isRegistered(DefaultEntityProcessor.class)) {
                context.register(DefaultEntityProcessor.class);
            }
            context.register(EntityFilteringScopeResolver.class);
            if (RuntimeType.SERVER == config.getRuntimeType()) {
                context.register(ServerScopeProvider.class);
            } else {
                context.register(CommonScopeProvider.class);
            }
            return true;
        }
        return false;
    }

    public static boolean enabled(Configuration config) {
        return config.isRegistered(EntityFilteringFeature.class) || config.isRegistered(SecurityEntityFilteringFeature.class) || config.isRegistered(SelectableEntityFilteringFeature.class);
    }
}

