/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.helper;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.LocalDcHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OptionalLocalDcHelper
implements LocalDcHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OptionalLocalDcHelper.class);
    @NonNull
    protected final InternalDriverContext context;
    @NonNull
    protected final DriverExecutionProfile profile;
    @NonNull
    protected final String logPrefix;

    public OptionalLocalDcHelper(@NonNull InternalDriverContext context, @NonNull DriverExecutionProfile profile, @NonNull String logPrefix) {
        this.context = context;
        this.profile = profile;
        this.logPrefix = logPrefix;
    }

    @Override
    @NonNull
    public Optional<String> discoverLocalDc(@NonNull Map<UUID, Node> nodes) {
        String localDc = this.context.getLocalDatacenter(this.profile.getName());
        if (localDc != null) {
            LOG.debug("[{}] Local DC set programmatically: {}", (Object)this.logPrefix, (Object)localDc);
            this.checkLocalDatacenterCompatibility(localDc, this.context.getMetadataManager().getContactPoints());
            return Optional.of(localDc);
        }
        if (this.profile.isDefined(DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)) {
            localDc = this.profile.getString(DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER);
            LOG.debug("[{}] Local DC set from configuration: {}", (Object)this.logPrefix, (Object)localDc);
            this.checkLocalDatacenterCompatibility(localDc, this.context.getMetadataManager().getContactPoints());
            return Optional.of(localDc);
        }
        LOG.debug("[{}] Local DC not set, DC awareness will be disabled", (Object)this.logPrefix);
        return Optional.empty();
    }

    protected void checkLocalDatacenterCompatibility(@NonNull String localDc, Set<? extends Node> contactPoints) {
        if (this.profile.getName().equals("default")) {
            LinkedHashSet<Node> badContactPoints = new LinkedHashSet<Node>();
            for (Node node : contactPoints) {
                if (Objects.equals(localDc, node.getDatacenter())) continue;
                badContactPoints.add(node);
            }
            if (!badContactPoints.isEmpty()) {
                LOG.warn("[{}] You specified {} as the local DC, but some contact points are from a different DC: {}; please provide the correct local DC, or check your contact points", this.logPrefix, localDc, this.formatNodesAndDcs(badContactPoints));
            }
        }
    }

    @NonNull
    protected String formatNodesAndDcs(Iterable<? extends Node> nodes) {
        ArrayList<String> l = new ArrayList<String>();
        for (Node node : nodes) {
            l.add(node + "=" + node.getDatacenter());
        }
        return String.join((CharSequence)", ", l);
    }

    @NonNull
    protected String formatDcs(Iterable<? extends Node> nodes) {
        ArrayList<String> l = new ArrayList<String>();
        for (Node node : nodes) {
            if (node.getDatacenter() == null) continue;
            l.add(node.getDatacenter());
        }
        return String.join((CharSequence)", ", new TreeSet(l));
    }
}

