/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexKind;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultColumnMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultIndexMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultTableMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameCompositeParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RawColumn;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TableParser
extends RelationParser {
    private static final Logger LOG = LoggerFactory.getLogger(TableParser.class);

    public TableParser(SchemaRows rows, InternalDriverContext context) {
        super(rows, context);
    }

    public TableMetadata parseTable(AdminRow tableRow, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userTypes) {
        Map<CqlIdentifier, Object> options;
        IndexMetadata index;
        boolean isCompactStorage;
        CqlIdentifier tableId = CqlIdentifier.fromInternal(tableRow.getString(tableRow.contains("table_name") ? "table_name" : "columnfamily_name"));
        UUID uuid = tableRow.contains("id") ? tableRow.getUuid("id") : tableRow.getUuid("cf_id");
        List<RawColumn> rawColumns = RawColumn.toRawColumns(((Multimap)this.rows.columns().getOrDefault(keyspaceId, ImmutableMultimap.of())).get(tableId));
        if (rawColumns.isEmpty()) {
            LOG.warn("[{}] Processing TABLE refresh for {}.{} but found no matching rows, skipping", this.logPrefix, keyspaceId, tableId);
            return null;
        }
        if (tableRow.contains("flags")) {
            boolean isStaticCompact;
            Set<String> flags = tableRow.getSetOfString("flags");
            boolean isDense = flags.contains("dense");
            boolean isSuper = flags.contains("super");
            boolean isCompound = flags.contains("compound");
            isCompactStorage = isSuper || isDense || !isCompound;
            boolean bl = isStaticCompact = !isSuper && !isDense && !isCompound;
            if (isStaticCompact) {
                RawColumn.pruneStaticCompactTableColumns(rawColumns);
            } else if (isDense) {
                RawColumn.pruneDenseTableColumnsV3(rawColumns);
            }
        } else {
            boolean isDense = tableRow.getBoolean("is_dense");
            if (isDense) {
                RawColumn.pruneDenseTableColumnsV2(rawColumns);
            }
            DataTypeClassNameCompositeParser.ParseResult comparator = new DataTypeClassNameCompositeParser().parseWithComposite(tableRow.getString("comparator"), keyspaceId, userTypes, this.context);
            isCompactStorage = isDense || !comparator.isComposite;
        }
        Collections.sort(rawColumns);
        ImmutableMap.Builder<CqlIdentifier, DefaultColumnMetadata> allColumnsBuilder = ImmutableMap.builder();
        ImmutableList.Builder partitionKeyBuilder = ImmutableList.builder();
        ImmutableMap.Builder<DefaultColumnMetadata, ClusteringOrder> clusteringColumnsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<CqlIdentifier, IndexMetadata> indexesBuilder = ImmutableMap.builder();
        for (RawColumn raw : rawColumns) {
            DataType dataType = this.rows.dataTypeParser().parse(keyspaceId, raw.dataType, userTypes, this.context);
            DefaultColumnMetadata column = new DefaultColumnMetadata(keyspaceId, tableId, raw.name, dataType, raw.kind.equals("static"));
            switch (raw.kind) {
                case "partition_key": {
                    partitionKeyBuilder.add(column);
                    break;
                }
                case "clustering": {
                    clusteringColumnsBuilder.put(column, raw.reversed ? ClusteringOrder.DESC : ClusteringOrder.ASC);
                    break;
                }
            }
            allColumnsBuilder.put(column.getName(), column);
            index = this.buildLegacyIndex(raw, column);
            if (index == null) continue;
            indexesBuilder.put(index.getName(), index);
        }
        try {
            options = this.parseOptions(tableRow);
        }
        catch (Exception e) {
            Loggers.warnWithException(LOG, "[{}] Error while parsing options for {}.{}, getOptions() will be empty", this.logPrefix, keyspaceId, tableId, e);
            options = Collections.emptyMap();
        }
        Collection indexRows = ((Multimap)this.rows.indexes().getOrDefault(keyspaceId, ImmutableMultimap.of())).get(tableId);
        for (AdminRow indexRow : indexRows) {
            index = this.buildModernIndex(keyspaceId, tableId, indexRow);
            indexesBuilder.put(index.getName(), index);
        }
        return new DefaultTableMetadata(keyspaceId, tableId, uuid, isCompactStorage, false, (List<ColumnMetadata>)((Object)partitionKeyBuilder.build()), clusteringColumnsBuilder.build(), allColumnsBuilder.build(), options, indexesBuilder.build());
    }

    TableMetadata parseVirtualTable(AdminRow tableRow, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userTypes) {
        CqlIdentifier tableId = CqlIdentifier.fromInternal(tableRow.getString("table_name"));
        List<RawColumn> rawColumns = RawColumn.toRawColumns(((Multimap)this.rows.virtualColumns().getOrDefault(keyspaceId, ImmutableMultimap.of())).get(tableId));
        if (rawColumns.isEmpty()) {
            LOG.warn("[{}] Processing TABLE refresh for {}.{} but found no matching rows, skipping", this.logPrefix, keyspaceId, tableId);
            return null;
        }
        Collections.sort(rawColumns);
        ImmutableMap.Builder<CqlIdentifier, DefaultColumnMetadata> allColumnsBuilder = ImmutableMap.builder();
        ImmutableList.Builder partitionKeyBuilder = ImmutableList.builder();
        ImmutableMap.Builder<DefaultColumnMetadata, ClusteringOrder> clusteringColumnsBuilder = ImmutableMap.builder();
        for (RawColumn raw : rawColumns) {
            DataType dataType = this.rows.dataTypeParser().parse(keyspaceId, raw.dataType, userTypes, this.context);
            DefaultColumnMetadata column = new DefaultColumnMetadata(keyspaceId, tableId, raw.name, dataType, raw.kind.equals("static"));
            switch (raw.kind) {
                case "partition_key": {
                    partitionKeyBuilder.add(column);
                    break;
                }
                case "clustering": {
                    clusteringColumnsBuilder.put(column, raw.reversed ? ClusteringOrder.DESC : ClusteringOrder.ASC);
                    break;
                }
            }
            allColumnsBuilder.put(column.getName(), column);
        }
        return new DefaultTableMetadata(keyspaceId, tableId, null, false, true, (List<ColumnMetadata>)((Object)partitionKeyBuilder.build()), clusteringColumnsBuilder.build(), allColumnsBuilder.build(), Collections.emptyMap(), Collections.emptyMap());
    }

    private IndexMetadata buildLegacyIndex(RawColumn raw, ColumnMetadata column) {
        if (raw.indexName == null) {
            return null;
        }
        return new DefaultIndexMetadata(column.getKeyspace(), column.getParent(), CqlIdentifier.fromInternal(raw.indexName), IndexKind.valueOf(raw.indexType), TableParser.buildLegacyIndexTarget(column, raw.indexOptions), raw.indexOptions);
    }

    private static String buildLegacyIndexTarget(ColumnMetadata column, Map<String, String> options) {
        String columnName = column.getName().asCql(true);
        DataType columnType = column.getType();
        if (options.containsKey("index_keys")) {
            return String.format("keys(%s)", columnName);
        }
        if (options.containsKey("index_keys_and_values")) {
            return String.format("entries(%s)", columnName);
        }
        if (columnType instanceof ListType && ((ListType)columnType).isFrozen() || columnType instanceof SetType && ((SetType)columnType).isFrozen() || columnType instanceof MapType && ((MapType)columnType).isFrozen()) {
            return String.format("full(%s)", columnName);
        }
        return columnName;
    }

    private IndexMetadata buildModernIndex(CqlIdentifier keyspaceId, CqlIdentifier tableId, AdminRow row) {
        CqlIdentifier name = CqlIdentifier.fromInternal(row.getString("index_name"));
        IndexKind kind = IndexKind.valueOf(row.getString("kind"));
        Map<String, String> options = row.getMapOfStringToString("options");
        String target = options.get("target");
        return new DefaultIndexMetadata(keyspaceId, tableId, name, kind, target, options);
    }
}

