/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.CassandraSchemaRows;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.KeyspaceFilter;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.util.NanoTime;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class CassandraSchemaQueries
implements SchemaQueries {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSchemaQueries.class);
    private final DriverChannel channel;
    private final EventExecutor adminExecutor;
    private final Node node;
    private final String logPrefix;
    private final Duration timeout;
    private final int pageSize;
    private final KeyspaceFilter keyspaceFilter;
    private final CompletableFuture<SchemaRows> schemaRowsFuture = new CompletableFuture();
    private final long startTimeNs = System.nanoTime();
    private CassandraSchemaRows.Builder schemaRowsBuilder;
    private int pendingQueries;

    protected CassandraSchemaQueries(DriverChannel channel, Node node, DriverExecutionProfile config, String logPrefix) {
        this.channel = channel;
        this.adminExecutor = channel.eventLoop();
        this.node = node;
        this.logPrefix = logPrefix;
        this.timeout = config.getDuration(DefaultDriverOption.METADATA_SCHEMA_REQUEST_TIMEOUT);
        this.pageSize = config.getInt(DefaultDriverOption.METADATA_SCHEMA_REQUEST_PAGE_SIZE);
        List<String> refreshedKeyspaces = config.getStringList(DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, Collections.emptyList());
        assert (refreshedKeyspaces != null);
        this.keyspaceFilter = KeyspaceFilter.newInstance(logPrefix, refreshedKeyspaces);
    }

    protected abstract String selectKeyspacesQuery();

    protected abstract Optional<String> selectVirtualKeyspacesQuery();

    protected abstract String selectTablesQuery();

    protected abstract Optional<String> selectVirtualTablesQuery();

    protected abstract Optional<String> selectViewsQuery();

    protected abstract Optional<String> selectIndexesQuery();

    protected abstract String selectColumnsQuery();

    protected abstract Optional<String> selectVirtualColumnsQuery();

    protected abstract String selectTypesQuery();

    protected abstract Optional<String> selectFunctionsQuery();

    protected abstract Optional<String> selectAggregatesQuery();

    protected abstract Optional<String> selectEdgesQuery();

    protected abstract Optional<String> selectVerticiesQuery();

    @Override
    public CompletionStage<SchemaRows> execute() {
        RunOrSchedule.on(this.adminExecutor, this::executeOnAdminExecutor);
        return this.schemaRowsFuture;
    }

    private void executeOnAdminExecutor() {
        assert (this.adminExecutor.inEventLoop());
        this.schemaRowsBuilder = new CassandraSchemaRows.Builder(this.node, this.keyspaceFilter, this.logPrefix);
        String whereClause = this.keyspaceFilter.getWhereClause();
        this.query(this.selectKeyspacesQuery() + whereClause, this.schemaRowsBuilder::withKeyspaces);
        this.query(this.selectTypesQuery() + whereClause, this.schemaRowsBuilder::withTypes);
        this.query(this.selectTablesQuery() + whereClause, this.schemaRowsBuilder::withTables);
        this.query(this.selectColumnsQuery() + whereClause, this.schemaRowsBuilder::withColumns);
        this.selectIndexesQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withIndexes));
        this.selectViewsQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withViews));
        this.selectFunctionsQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withFunctions));
        this.selectAggregatesQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withAggregates));
        this.selectVirtualKeyspacesQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withVirtualKeyspaces));
        this.selectVirtualTablesQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withVirtualTables));
        this.selectVirtualColumnsQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withVirtualColumns));
        this.selectEdgesQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withEdges));
        this.selectVerticiesQuery().ifPresent(select -> this.query(select + whereClause, this.schemaRowsBuilder::withVertices));
    }

    private void query(String queryString, Function<Iterable<AdminRow>, CassandraSchemaRows.Builder> builderUpdater) {
        assert (this.adminExecutor.inEventLoop());
        ++this.pendingQueries;
        this.query(queryString).whenCompleteAsync((result2, error) -> this.handleResult((AdminResult)result2, (Throwable)error, builderUpdater), this.adminExecutor);
    }

    @VisibleForTesting
    protected CompletionStage<AdminResult> query(String query) {
        return AdminRequestHandler.query(this.channel, query, this.timeout, this.pageSize, this.logPrefix).start();
    }

    private void handleResult(AdminResult result2, Throwable error, Function<Iterable<AdminRow>, CassandraSchemaRows.Builder> builderUpdater) {
        if (this.schemaRowsFuture.isCompletedExceptionally()) {
            return;
        }
        if (error != null) {
            this.schemaRowsFuture.completeExceptionally(error);
        } else {
            this.schemaRowsBuilder = builderUpdater.apply(result2);
            if (result2.hasNextPage()) {
                result2.nextPage().whenCompleteAsync((nextResult, nextError) -> this.handleResult((AdminResult)nextResult, (Throwable)nextError, builderUpdater), this.adminExecutor);
            } else {
                --this.pendingQueries;
                if (this.pendingQueries == 0) {
                    LOG.debug("[{}] Schema queries took {}", (Object)this.logPrefix, (Object)NanoTime.formatTimeSince(this.startTimeNs));
                    this.schemaRowsFuture.complete(this.schemaRowsBuilder.build());
                }
            }
        }
    }
}

