/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.regex.Pattern;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class EnhancedSession$ {
    public static EnhancedSession$ MODULE$;
    private final Pattern DDL_REGEX;

    static {
        new EnhancedSession$();
    }

    private Pattern DDL_REGEX() {
        return this.DDL_REGEX;
    }

    public boolean isDDLStatement(String query) {
        return this.DDL_REGEX().matcher(query.trim()).matches();
    }

    public <StatementT extends Statement<StatementT>> boolean isDDLStatement(StatementT st) {
        StatementT StatementT = st;
        if (StatementT instanceof BoundStatement) {
            StatementT StatementT2 = StatementT;
            return this.isDDLStatement(((BoundStatement)StatementT2).getPreparedStatement().getQuery());
        }
        if (StatementT instanceof BatchStatement) {
            StatementT StatementT3 = StatementT;
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)((Object)StatementT3)).iterator()).asScala()).toSeq().exists((Function1<BatchableStatement, Object> & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(EnhancedSession$.$anonfun$isDDLStatement$1(x0$1)));
        }
        if (StatementT instanceof SimpleStatement) {
            StatementT StatementT4 = StatementT;
            return this.isDDLStatement(((SimpleStatement)StatementT4).getQuery());
        }
        return true;
    }

    public <StatementT extends Statement<StatementT>> String getCqlStatement(StatementT st) {
        StatementT StatementT = st;
        if (StatementT instanceof BoundStatement) {
            StatementT StatementT2 = StatementT;
            return ((BoundStatement)StatementT2).getPreparedStatement().getQuery();
        }
        if (StatementT instanceof BatchStatement) {
            String string;
            StatementT StatementT3 = StatementT;
            BatchType batchType = ((BatchStatement)StatementT3).getBatchType();
            long timestamp = StatementT3.getQueryTimestamp();
            String timestampStr = timestamp == Long.MIN_VALUE ? "" : new StringBuilder(17).append(" USING TIMESTAMP ").append(timestamp).toString();
            BatchType batchType2 = batchType;
            BatchType batchType3 = BatchType.COUNTER;
            if (!(batchType2 != null ? !batchType2.equals(batchType3) : batchType3 != null)) {
                string = "COUNTER ";
            } else {
                BatchType batchType4 = batchType;
                BatchType batchType5 = BatchType.UNLOGGED;
                string = !(batchType4 != null ? !batchType4.equals(batchType5) : batchType5 != null) ? "UNLOGGED " : "";
            }
            String batchTypeStr = string;
            return new StringBuilder(25).append("BEGIN ").append(batchTypeStr).append("BATCH").append(timestampStr).append("\n").append(((TraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)((Object)StatementT3)).iterator()).asScala()).toSeq().map((Function1<BatchableStatement, String> & java.io.Serializable & Serializable)x0$1 -> {
                BatchableStatement batchableStatement = x0$1;
                if (batchableStatement instanceof BoundStatement) {
                    BoundStatement boundStatement = (BoundStatement)batchableStatement;
                    return boundStatement.getPreparedStatement().getQuery();
                }
                if (batchableStatement instanceof SimpleStatement) {
                    SimpleStatement simpleStatement = (SimpleStatement)batchableStatement;
                    return simpleStatement.getQuery();
                }
                throw new MatchError(batchableStatement);
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\nAPPLY BATCH;").toString();
        }
        if (StatementT instanceof SimpleStatement) {
            StatementT StatementT4 = StatementT;
            return ((SimpleStatement)StatementT4).getQuery();
        }
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$isDDLStatement$1(BatchableStatement x0$1) {
        BatchableStatement batchableStatement = x0$1;
        if (batchableStatement instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)batchableStatement;
            return MODULE$.isDDLStatement(boundStatement.getPreparedStatement().getQuery());
        }
        if (batchableStatement instanceof SimpleStatement) {
            SimpleStatement simpleStatement = (SimpleStatement)batchableStatement;
            return MODULE$.isDDLStatement(simpleStatement.getQuery());
        }
        throw new MatchError(batchableStatement);
    }

    private EnhancedSession$() {
        MODULE$ = this;
        this.DDL_REGEX = Pattern.compile("^(CREATE|DROP|ALTER) .*", 2);
    }
}

