/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingException;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.impl.InternalMessage;
import io.atomix.cluster.messaging.impl.InternalReply;
import io.atomix.cluster.messaging.impl.InternalRequest;
import io.atomix.cluster.messaging.impl.MessageDecoder;
import io.atomix.cluster.messaging.impl.MessageEncoder;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.net.Address;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyMessagingService
implements ManagedMessagingService {
    private static final String DEFAULT_NAME = "atomix";
    private static final long HISTORY_EXPIRE_MILLIS = Duration.ofMinutes(1L).toMillis();
    private static final long MIN_TIMEOUT_MILLIS = 100L;
    private static final long MAX_TIMEOUT_MILLIS = 5000L;
    private static final long TIMEOUT_INTERVAL = 50L;
    private static final int WINDOW_SIZE = 10;
    private static final int WINDOW_UPDATE_SAMPLE_SIZE = 100;
    private static final long WINDOW_UPDATE_MILLIS = 60000L;
    private static final int MIN_SAMPLES = 25;
    private static final double PHI_FACTOR = 1.0 / Math.log(10.0);
    private static final int PHI_FAILURE_THRESHOLD = 12;
    private static final int CHANNEL_POOL_SIZE = 8;
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LocalClientConnection localClientConnection = new LocalClientConnection();
    private final LocalServerConnection localServerConnection = new LocalServerConnection(null);
    private static final String CONFIG_DIR = "../config";
    private static final String KS_FILE_NAME = "atomix.jks";
    private static final File DEFAULT_KS_FILE = new File("../config", "atomix.jks");
    private static final String DEFAULT_KS_PASSWORD = "changeit";
    private final Address localAddress;
    private final int preamble;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Map<String, BiConsumer<InternalRequest, ServerConnection>> handlers = new ConcurrentHashMap<String, BiConsumer<InternalRequest, ServerConnection>>();
    private final Map<Channel, RemoteClientConnection> clientConnections = Maps.newConcurrentMap();
    private final Map<Channel, RemoteServerConnection> serverConnections = Maps.newConcurrentMap();
    private final AtomicLong messageIdGenerator = new AtomicLong(0L);
    private ScheduledFuture<?> timeoutFuture;
    private final Map<Address, List<CompletableFuture<Channel>>> channels = Maps.newConcurrentMap();
    private EventLoopGroup serverGroup;
    private EventLoopGroup clientGroup;
    private Class<? extends ServerChannel> serverChannelClass;
    private Class<? extends Channel> clientChannelClass;
    private ScheduledExecutorService timeoutExecutor;
    private Channel serverChannel;
    protected static final boolean TLS_ENABLED = true;
    protected static final boolean TLS_DISABLED = false;
    protected boolean enableNettyTls = true;
    protected TrustManagerFactory trustManager;
    protected KeyManagerFactory keyManager;

    public static Builder builder() {
        return new Builder();
    }

    protected NettyMessagingService(int preamble, Address address) {
        this.preamble = preamble;
        this.localAddress = address;
    }

    @Override
    public Address address() {
        return this.localAddress;
    }

    public CompletableFuture<MessagingService> start() {
        this.getTlsParameters();
        if (this.started.get()) {
            this.log.warn("Already running at local address: {}", (Object)this.localAddress);
            return CompletableFuture.completedFuture(this);
        }
        this.initEventLoopGroup();
        return ((CompletableFuture)this.startAcceptingConnections().thenRun(() -> {
            this.timeoutExecutor = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"netty-messaging-timeout-%d", (Logger)this.log));
            this.timeoutFuture = this.timeoutExecutor.scheduleAtFixedRate(this::timeoutAllCallbacks, 50L, 50L, TimeUnit.MILLISECONDS);
            this.started.set(true);
            this.log.info("Started");
        })).thenApply(v -> this);
    }

    private void getTlsParameters() {
        this.enableNettyTls = Boolean.parseBoolean(System.getProperty("io.atomix.enableNettyTLS", Boolean.toString(true)));
        if (this.enableNettyTls) {
            this.enableNettyTls = this.loadKeyStores();
        }
    }

    public boolean isRunning() {
        return this.started.get();
    }

    private boolean loadKeyStores() {
        KeyManagerFactory kmf;
        TrustManagerFactory tmf;
        try {
            String ksLocation = System.getProperty("javax.net.ssl.keyStore", DEFAULT_KS_FILE.toString());
            String tsLocation = System.getProperty("javax.net.ssl.trustStore", DEFAULT_KS_FILE.toString());
            char[] ksPwd = System.getProperty("javax.net.ssl.keyStorePassword", DEFAULT_KS_PASSWORD).toCharArray();
            char[] tsPwd = System.getProperty("javax.net.ssl.trustStorePassword", DEFAULT_KS_PASSWORD).toCharArray();
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fileInputStream = new FileInputStream(tsLocation);){
                ts.load(fileInputStream, tsPwd);
            }
            tmf.init(ts);
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fileInputStream = new FileInputStream(ksLocation);){
                ks.load(fileInputStream, ksPwd);
            }
            kmf.init(ks, ksPwd);
            if (this.log.isInfoEnabled()) {
                this.logKeyStore(ks, ksLocation, ksPwd);
            }
        }
        catch (FileNotFoundException e) {
            this.log.warn("Disabling TLS for intra-cluster messaging; Could not load cluster key store: {}", (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.log.error("Error loading key store; disabling TLS for intra-cluster messaging", (Throwable)e);
            return false;
        }
        this.trustManager = tmf;
        this.keyManager = kmf;
        return true;
    }

    private void logKeyStore(KeyStore ks, String ksLocation, char[] ksPwd) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Loaded cluster key store from: {}", (Object)ksLocation);
            try {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    byte[] encodedKey;
                    String alias = e.nextElement();
                    Key key = ks.getKey(alias, ksPwd);
                    Certificate[] certs = ks.getCertificateChain(alias);
                    this.log.debug("{} -> {}", (Object)alias, (Object)certs);
                    if (certs != null && certs.length > 0) {
                        encodedKey = certs[0].getEncoded();
                    } else {
                        this.log.info("Could not find cert chain for {}, using fingerprint of key instead...", (Object)alias);
                        encodedKey = key.getEncoded();
                    }
                    MessageDigest digest = MessageDigest.getInstance("SHA1");
                    digest.update(encodedKey);
                    StringJoiner fingerprint = new StringJoiner(":");
                    for (byte b : digest.digest()) {
                        fingerprint.add(String.format("%02X", b));
                    }
                    this.log.info("{} -> {}", (Object)alias, (Object)fingerprint);
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to print contents of key store: {}", (Object)ksLocation, (Object)e);
            }
        }
    }

    private void initEventLoopGroup() {
        try {
            this.clientGroup = new EpollEventLoopGroup(0, Threads.namedThreads((String)"netty-messaging-event-epoll-client-%d", (Logger)this.log));
            this.serverGroup = new EpollEventLoopGroup(0, Threads.namedThreads((String)"netty-messaging-event-epoll-server-%d", (Logger)this.log));
            this.serverChannelClass = EpollServerSocketChannel.class;
            this.clientChannelClass = EpollSocketChannel.class;
            return;
        }
        catch (Throwable e) {
            this.log.debug("Failed to initialize native (epoll) transport. Reason: {}. Proceeding with nio.", (Object)e.getMessage());
            this.clientGroup = new NioEventLoopGroup(0, Threads.namedThreads((String)"netty-messaging-event-nio-client-%d", (Logger)this.log));
            this.serverGroup = new NioEventLoopGroup(0, Threads.namedThreads((String)"netty-messaging-event-nio-server-%d", (Logger)this.log));
            this.serverChannelClass = NioServerSocketChannel.class;
            this.clientChannelClass = NioSocketChannel.class;
            return;
        }
    }

    private void timeoutAllCallbacks() {
        this.localClientConnection.timeoutCallbacks();
        for (RemoteClientConnection connection : this.clientConnections.values()) {
            connection.timeoutCallbacks();
        }
    }

    @Override
    public CompletableFuture<Void> sendAsync(Address address, String type, byte[] payload) {
        InternalRequest message = new InternalRequest(this.preamble, this.messageIdGenerator.incrementAndGet(), this.localAddress, type, payload);
        return this.executeOnPooledConnection(address, type, c -> c.sendAsync(message), MoreExecutors.directExecutor());
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload) {
        return this.sendAndReceive(address, type, payload, null, MoreExecutors.directExecutor());
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, Executor executor) {
        return this.sendAndReceive(address, type, payload, null, executor);
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, Duration timeout) {
        return this.sendAndReceive(address, type, payload, timeout, MoreExecutors.directExecutor());
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, Duration timeout, Executor executor) {
        long messageId = this.messageIdGenerator.incrementAndGet();
        InternalRequest message = new InternalRequest(this.preamble, messageId, this.localAddress, type, payload);
        return this.executeOnPooledConnection(address, type, c -> c.sendAndReceive(message, timeout), executor);
    }

    private List<CompletableFuture<Channel>> getChannelPool(Address address) {
        List<CompletableFuture<Channel>> channelPool = this.channels.get(address);
        if (channelPool != null) {
            return channelPool;
        }
        return this.channels.computeIfAbsent(address, e -> {
            ArrayList<Object> defaultList = new ArrayList<Object>(8);
            for (int i = 0; i < 8; ++i) {
                defaultList.add(null);
            }
            return Lists.newCopyOnWriteArrayList(defaultList);
        });
    }

    private int getChannelOffset(String messageType) {
        return Math.abs(messageType.hashCode() % 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Channel> getChannel(Address address, String messageType) {
        int offset;
        List<CompletableFuture<Channel>> channelPool = this.getChannelPool(address);
        CompletableFuture<Channel> channelFuture = channelPool.get(offset = this.getChannelOffset(messageType));
        if (channelFuture == null || channelFuture.isCompletedExceptionally()) {
            List<CompletableFuture<Channel>> list = channelPool;
            synchronized (list) {
                channelFuture = channelPool.get(offset);
                if (channelFuture == null || channelFuture.isCompletedExceptionally()) {
                    channelFuture = this.openChannel(address);
                    channelPool.set(offset, channelFuture);
                }
            }
        }
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        CompletableFuture<Channel> finalFuture = channelFuture;
        finalFuture.whenComplete((channel, error) -> {
            if (error == null) {
                if (!channel.isActive()) {
                    CompletableFuture<Channel> currentFuture;
                    List list = channelPool;
                    synchronized (list) {
                        currentFuture = (CompletableFuture<Channel>)channelPool.get(offset);
                        if (currentFuture == finalFuture) {
                            channelPool.set(offset, null);
                        } else if (currentFuture == null) {
                            currentFuture = this.openChannel(address);
                            channelPool.set(offset, currentFuture);
                        }
                    }
                    ClientConnection connection = this.clientConnections.remove(channel);
                    if (connection != null) {
                        connection.close();
                    }
                    if (currentFuture == finalFuture) {
                        this.getChannel(address, messageType).whenComplete((recursiveResult, recursiveError) -> {
                            if (recursiveError == null) {
                                future.complete((Channel)recursiveResult);
                            } else {
                                future.completeExceptionally((Throwable)recursiveError);
                            }
                        });
                    } else {
                        currentFuture.whenComplete((recursiveResult, recursiveError) -> {
                            if (recursiveError == null) {
                                future.complete((Channel)recursiveResult);
                            } else {
                                future.completeExceptionally((Throwable)recursiveError);
                            }
                        });
                    }
                } else {
                    future.complete((Channel)channel);
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    private <T> CompletableFuture<T> executeOnPooledConnection(Address address, String type, Function<ClientConnection, CompletableFuture<T>> callback, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        this.executeOnPooledConnection(address, type, callback, executor, future);
        return future;
    }

    private <T> void executeOnPooledConnection(Address address, String type, Function<ClientConnection, CompletableFuture<T>> callback, Executor executor, CompletableFuture<T> future) {
        if (address.equals((Object)this.localAddress)) {
            callback.apply(this.localClientConnection).whenComplete((result, error) -> {
                if (error == null) {
                    executor.execute(() -> future.complete(result));
                } else {
                    executor.execute(() -> future.completeExceptionally((Throwable)error));
                }
            });
            return;
        }
        this.getChannel(address, type).whenComplete((channel, channelError) -> {
            if (channelError == null) {
                RemoteClientConnection connection = this.getOrCreateRemoteClientConnection((Channel)channel);
                ((CompletableFuture)callback.apply(connection)).whenComplete((result, sendError) -> {
                    if (sendError == null) {
                        executor.execute(() -> future.complete(result));
                    } else {
                        Throwable cause = Throwables.getRootCause((Throwable)sendError);
                        if (!(cause instanceof TimeoutException) && !(cause instanceof MessagingException)) {
                            channel.close().addListener(f -> {
                                connection.close();
                                this.clientConnections.remove(channel);
                            });
                        }
                        executor.execute(() -> future.completeExceptionally((Throwable)sendError));
                    }
                });
            } else {
                executor.execute(() -> future.completeExceptionally((Throwable)channelError));
            }
        });
    }

    private RemoteClientConnection getOrCreateRemoteClientConnection(Channel channel) {
        RemoteClientConnection connection = this.clientConnections.get(channel);
        if (connection == null) {
            connection = this.clientConnections.computeIfAbsent(channel, x$0 -> new RemoteClientConnection((Channel)x$0));
        }
        return connection;
    }

    @Override
    public void registerHandler(String type, BiConsumer<Address, byte[]> handler, Executor executor) {
        this.handlers.put(type, (message, connection) -> executor.execute(() -> handler.accept(message.sender(), message.payload())));
    }

    @Override
    public void registerHandler(String type, BiFunction<Address, byte[], byte[]> handler, Executor executor) {
        this.handlers.put(type, (message, connection) -> executor.execute(() -> {
            byte[] responsePayload = null;
            InternalReply.Status status = InternalReply.Status.OK;
            try {
                responsePayload = (byte[])handler.apply(message.sender(), message.payload());
            }
            catch (Exception e) {
                this.log.warn("An error occurred in a message handler: {}", (Throwable)e);
                status = InternalReply.Status.ERROR_HANDLER_EXCEPTION;
            }
            connection.reply((InternalRequest)message, status, Optional.ofNullable(responsePayload));
        }));
    }

    @Override
    public void registerHandler(String type, BiFunction<Address, byte[], CompletableFuture<byte[]>> handler) {
        this.handlers.put(type, (message, connection) -> ((CompletableFuture)handler.apply(message.sender(), message.payload())).whenComplete((result, error) -> {
            InternalReply.Status status;
            if (error == null) {
                status = InternalReply.Status.OK;
            } else {
                this.log.warn("An error occurred in a message handler: {}", error);
                status = InternalReply.Status.ERROR_HANDLER_EXCEPTION;
            }
            connection.reply((InternalRequest)message, status, Optional.ofNullable(result));
        }));
    }

    @Override
    public void unregisterHandler(String type) {
        this.handlers.remove(type);
    }

    private Bootstrap bootstrapClient(Address address) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(327680, 655360));
        bootstrap.option(ChannelOption.SO_RCVBUF, (Object)0x100000);
        bootstrap.option(ChannelOption.SO_SNDBUF, (Object)0x100000);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000);
        bootstrap.group(this.clientGroup);
        bootstrap.channel(this.clientChannelClass);
        bootstrap.remoteAddress(address.address(), address.port());
        if (this.enableNettyTls) {
            bootstrap.handler((ChannelHandler)new SslClientCommunicationChannelInitializer());
        } else {
            bootstrap.handler((ChannelHandler)new BasicChannelInitializer());
        }
        return bootstrap;
    }

    private CompletableFuture<Void> startAcceptingConnections() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ServerBootstrap b = new ServerBootstrap();
        b.option(ChannelOption.SO_REUSEADDR, (Object)true);
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768));
        b.childOption(ChannelOption.SO_RCVBUF, (Object)0x100000);
        b.childOption(ChannelOption.SO_SNDBUF, (Object)0x100000);
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        b.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        b.group(this.serverGroup, this.clientGroup);
        b.channel(this.serverChannelClass);
        if (this.enableNettyTls) {
            b.childHandler((ChannelHandler)new SslServerCommunicationChannelInitializer());
        } else {
            b.childHandler((ChannelHandler)new BasicChannelInitializer());
        }
        b.bind(this.localAddress.port()).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (f.isSuccess()) {
                this.log.info("{} accepting incoming connections on port {}", (Object)this.localAddress.address(), (Object)this.localAddress.port());
                this.serverChannel = f.channel();
                future.complete(null);
            } else {
                this.log.warn("{} failed to bind to port {} due to {}", new Object[]{this.localAddress.address(), this.localAddress.port(), f.cause()});
                future.completeExceptionally(f.cause());
            }
        }));
        return future;
    }

    private CompletableFuture<Channel> openChannel(Address address) {
        Bootstrap bootstrap = this.bootstrapClient(address);
        CompletableFuture<Channel> retFuture = new CompletableFuture<Channel>();
        ChannelFuture f = bootstrap.connect();
        f.addListener(future -> {
            if (future.isSuccess()) {
                retFuture.complete(f.channel());
            } else {
                retFuture.completeExceptionally(future.cause());
            }
        });
        this.log.debug("Established a new connection to {}", (Object)address);
        return retFuture;
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            return CompletableFuture.supplyAsync(() -> {
                boolean interrupted = false;
                try {
                    try {
                        this.serverChannel.close().sync();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    Future serverShutdownFuture = this.serverGroup.shutdownGracefully();
                    Future clientShutdownFuture = this.clientGroup.shutdownGracefully();
                    try {
                        serverShutdownFuture.sync();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    try {
                        clientShutdownFuture.sync();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    this.timeoutFuture.cancel(false);
                    this.timeoutExecutor.shutdown();
                }
                finally {
                    this.log.info("Stopped");
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    static /* synthetic */ long access$1300() {
        return HISTORY_EXPIRE_MILLIS;
    }

    private static final class RequestMonitor {
        private final DescriptiveStatistics samples = new SynchronizedDescriptiveStatistics(10);
        private final AtomicLong max = new AtomicLong();
        private volatile int replyCount;
        private volatile long lastUpdate = System.currentTimeMillis();

        private RequestMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addReplyTime(long replyTime) {
            this.max.accumulateAndGet(replyTime, Math::max);
            ++this.replyCount;
            if (this.replyCount >= 100 && System.currentTimeMillis() - this.lastUpdate > 60000L) {
                RequestMonitor requestMonitor = this;
                synchronized (requestMonitor) {
                    long lastMax;
                    if (this.replyCount >= 100 && System.currentTimeMillis() - this.lastUpdate > 60000L && (lastMax = this.max.get()) > 0L) {
                        this.samples.addValue((double)lastMax);
                        this.lastUpdate = System.currentTimeMillis();
                        this.replyCount = 0;
                        this.max.set(0L);
                    }
                }
            }
        }

        boolean isTimedOut(long elapsedTime) {
            return this.samples.getN() == 10L && this.phi(elapsedTime) >= 12.0;
        }

        private double phi(long elapsedTime) {
            if (this.samples.getN() < 25L) {
                return 0.0;
            }
            return this.computePhi(this.samples, elapsedTime);
        }

        private double computePhi(DescriptiveStatistics samples, long elapsedTime) {
            return samples.getN() > 0L ? PHI_FACTOR * (double)elapsedTime / samples.getMean() : 100.0;
        }
    }

    private final class RemoteServerConnection
    implements ServerConnection {
        private final Channel channel;

        RemoteServerConnection(Channel channel) {
            this.channel = channel;
        }

        private void dispatch(InternalRequest message) {
            if (message.preamble() != NettyMessagingService.this.preamble) {
                NettyMessagingService.this.log.debug("Received {} with invalid preamble from {}", (Object)message.type(), (Object)message.sender());
                this.reply(message, InternalReply.Status.PROTOCOL_EXCEPTION, Optional.empty());
                return;
            }
            BiConsumer handler = (BiConsumer)NettyMessagingService.this.handlers.get(message.subject());
            if (handler != null) {
                NettyMessagingService.this.log.trace("{} - Received message type {} from {}", new Object[]{NettyMessagingService.this.localAddress, message.subject(), message.sender()});
                handler.accept(message, this);
            } else {
                NettyMessagingService.this.log.debug("{} - No handler for message type {} from {}", new Object[]{NettyMessagingService.this.localAddress, message.subject(), message.sender()});
                this.reply(message, InternalReply.Status.ERROR_NO_HANDLER, Optional.empty());
            }
        }

        @Override
        public void reply(InternalRequest message, InternalReply.Status status, Optional<byte[]> payload) {
            InternalReply response = new InternalReply(NettyMessagingService.this.preamble, message.id(), payload.orElse(EMPTY_PAYLOAD), status);
            this.channel.writeAndFlush((Object)response, this.channel.voidPromise());
        }
    }

    private final class RemoteClientConnection
    extends AbstractClientConnection {
        private final Channel channel;

        RemoteClientConnection(Channel channel) {
            this.channel = channel;
        }

        @Override
        public CompletableFuture<Void> sendAsync(InternalRequest message) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.channel.writeAndFlush((Object)message).addListener(channelFuture -> {
                if (!channelFuture.isSuccess()) {
                    future.completeExceptionally(channelFuture.cause());
                } else {
                    future.complete(null);
                }
            });
            return future;
        }

        @Override
        public CompletableFuture<byte[]> sendAndReceive(InternalRequest message, Duration timeout) {
            CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
            this.registerCallback(message.id(), message.subject(), timeout, future);
            this.channel.writeAndFlush((Object)message).addListener(channelFuture -> {
                Callback callback;
                if (!channelFuture.isSuccess() && (callback = this.failCallback(message.id())) != null) {
                    callback.completeExceptionally(channelFuture.cause());
                }
            });
            return future;
        }

        private void dispatch(InternalReply message) {
            if (message.preamble() != NettyMessagingService.this.preamble) {
                NettyMessagingService.this.log.debug("Received {} with invalid preamble", (Object)message.type());
                return;
            }
            Callback callback = this.completeCallback(message.id());
            if (callback != null) {
                if (message.status() == InternalReply.Status.OK) {
                    callback.complete(message.payload());
                } else if (message.status() == InternalReply.Status.ERROR_NO_HANDLER) {
                    callback.completeExceptionally(new MessagingException.NoRemoteHandler());
                } else if (message.status() == InternalReply.Status.ERROR_HANDLER_EXCEPTION) {
                    callback.completeExceptionally(new MessagingException.RemoteHandlerFailure());
                } else if (message.status() == InternalReply.Status.PROTOCOL_EXCEPTION) {
                    callback.completeExceptionally(new MessagingException.ProtocolException());
                }
            } else {
                NettyMessagingService.this.log.debug("Received a reply for message id:[{}] but was unable to locate the request handle", (Object)message.id());
            }
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                for (Callback callback : this.futures.values()) {
                    callback.completeExceptionally(new ConnectException());
                }
            }
        }
    }

    private static final class LocalServerConnection
    implements ServerConnection {
        private final CompletableFuture<byte[]> future;

        LocalServerConnection(CompletableFuture<byte[]> future) {
            this.future = future;
        }

        @Override
        public void reply(InternalRequest message, InternalReply.Status status, Optional<byte[]> payload) {
            if (this.future != null) {
                if (status == InternalReply.Status.OK) {
                    this.future.complete(payload.orElse(EMPTY_PAYLOAD));
                } else if (status == InternalReply.Status.ERROR_NO_HANDLER) {
                    this.future.completeExceptionally(new MessagingException.NoRemoteHandler());
                } else if (status == InternalReply.Status.ERROR_HANDLER_EXCEPTION) {
                    this.future.completeExceptionally(new MessagingException.RemoteHandlerFailure());
                } else if (status == InternalReply.Status.PROTOCOL_EXCEPTION) {
                    this.future.completeExceptionally(new MessagingException.ProtocolException());
                }
            }
        }
    }

    private final class LocalClientConnection
    extends AbstractClientConnection {
        private LocalClientConnection() {
        }

        @Override
        public CompletableFuture<Void> sendAsync(InternalRequest message) {
            BiConsumer handler = (BiConsumer)NettyMessagingService.this.handlers.get(message.subject());
            if (handler != null) {
                NettyMessagingService.this.log.trace("{} - Received message type {} from {}", new Object[]{NettyMessagingService.this.localAddress, message.subject(), message.sender()});
                handler.accept(message, NettyMessagingService.this.localServerConnection);
            } else {
                NettyMessagingService.this.log.debug("{} - No handler for message type {} from {}", new Object[]{NettyMessagingService.this.localAddress, message.subject(), message.sender()});
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<byte[]> sendAndReceive(InternalRequest message, Duration timeout) {
            CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
            future.whenComplete((r, e) -> this.completeCallback(message.id()));
            this.registerCallback(message.id(), message.subject(), timeout, future);
            BiConsumer handler = (BiConsumer)NettyMessagingService.this.handlers.get(message.subject());
            if (handler != null) {
                NettyMessagingService.this.log.trace("{} - Received message type {} from {}", new Object[]{NettyMessagingService.this.localAddress, message.subject(), message.sender()});
                handler.accept(message, new LocalServerConnection(future));
            } else {
                NettyMessagingService.this.log.debug("{} - No handler for message type {} from {}", new Object[]{NettyMessagingService.this.localAddress, message.subject(), message.sender()});
                new LocalServerConnection(future).reply(message, InternalReply.Status.ERROR_NO_HANDLER, Optional.empty());
            }
            return future;
        }
    }

    private abstract class AbstractClientConnection
    implements ClientConnection {
        private final Cache<String, RequestMonitor> requestMonitors = CacheBuilder.newBuilder().expireAfterAccess(NettyMessagingService.access$1300(), TimeUnit.MILLISECONDS).build();
        final Map<Long, Callback> futures = Maps.newConcurrentMap();
        final AtomicBoolean closed = new AtomicBoolean(false);

        private AbstractClientConnection() {
        }

        void timeoutCallbacks() {
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<Long, Callback>> iterator = this.futures.entrySet().iterator();
            while (iterator.hasNext()) {
                Callback callback = iterator.next().getValue();
                try {
                    long elapsedTime = currentTime - callback.time;
                    if (callback.timeout > 0L && elapsedTime > callback.timeout) {
                        iterator.remove();
                        callback.completeExceptionally(new TimeoutException("Request timed out in " + elapsedTime + " milliseconds"));
                        continue;
                    }
                    RequestMonitor requestMonitor = (RequestMonitor)this.requestMonitors.get((Object)callback.type, () -> new RequestMonitor());
                    if (callback.timeout != 0L || elapsedTime <= 5000L && (elapsedTime <= 100L || !requestMonitor.isTimedOut(elapsedTime))) continue;
                    iterator.remove();
                    requestMonitor.addReplyTime(elapsedTime);
                    callback.completeExceptionally(new TimeoutException("Request timed out in " + elapsedTime + " milliseconds"));
                }
                catch (ExecutionException e) {
                    throw new AssertionError();
                }
            }
        }

        protected void registerCallback(long id, String subject, Duration timeout, CompletableFuture<byte[]> future) {
            this.futures.put(id, new Callback(subject, timeout, future));
        }

        protected Callback completeCallback(long id) {
            Callback callback = this.futures.remove(id);
            if (callback != null) {
                try {
                    RequestMonitor requestMonitor = (RequestMonitor)this.requestMonitors.get((Object)callback.type, () -> new RequestMonitor());
                    requestMonitor.addReplyTime(System.currentTimeMillis() - callback.time);
                }
                catch (ExecutionException e) {
                    throw new AssertionError();
                }
            }
            return callback;
        }

        protected Callback failCallback(long id) {
            return this.futures.remove(id);
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                for (Callback callback : this.futures.values()) {
                    callback.completeExceptionally(new ConnectException());
                }
            }
        }
    }

    private static interface ServerConnection {
        public void reply(InternalRequest var1, InternalReply.Status var2, Optional<byte[]> var3);

        default public void close() {
        }
    }

    private static interface ClientConnection {
        public CompletableFuture<Void> sendAsync(InternalRequest var1);

        public CompletableFuture<byte[]> sendAndReceive(InternalRequest var1, Duration var2);

        default public void close() {
        }
    }

    private static final class Callback {
        private final String type;
        private final long timeout;
        private final CompletableFuture<byte[]> future;
        private final long time = System.currentTimeMillis();

        Callback(String type, Duration timeout, CompletableFuture<byte[]> future) {
            this.type = type;
            this.timeout = timeout != null ? timeout.toMillis() : 0L;
            this.future = future;
        }

        public void complete(byte[] value) {
            this.future.complete(value);
        }

        public void completeExceptionally(Throwable error) {
            this.future.completeExceptionally(error);
        }
    }

    @ChannelHandler.Sharable
    private class InboundMessageDispatcher
    extends SimpleChannelInboundHandler<Object> {
        private InboundMessageDispatcher() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, Object rawMessage) throws Exception {
            InternalMessage message = (InternalMessage)rawMessage;
            try {
                if (message.isRequest()) {
                    RemoteServerConnection connection = (RemoteServerConnection)NettyMessagingService.this.serverConnections.get(ctx.channel());
                    if (connection == null) {
                        connection = NettyMessagingService.this.serverConnections.computeIfAbsent(ctx.channel(), x$0 -> new RemoteServerConnection((Channel)x$0));
                    }
                    connection.dispatch((InternalRequest)message);
                } else {
                    RemoteClientConnection connection = NettyMessagingService.this.getOrCreateRemoteClientConnection(ctx.channel());
                    connection.dispatch((InternalReply)message);
                }
            }
            catch (RejectedExecutionException e) {
                NettyMessagingService.this.log.warn("Unable to dispatch message due to {}", (Object)e.getMessage());
            }
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            RemoteServerConnection serverConnection;
            NettyMessagingService.this.log.error("Exception inside channel handling pipeline.", cause);
            RemoteClientConnection clientConnection = (RemoteClientConnection)NettyMessagingService.this.clientConnections.remove(context.channel());
            if (clientConnection != null) {
                clientConnection.close();
            }
            if ((serverConnection = (RemoteServerConnection)NettyMessagingService.this.serverConnections.remove(context.channel())) != null) {
                serverConnection.close();
            }
            context.close();
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            RemoteServerConnection serverConnection;
            RemoteClientConnection clientConnection = (RemoteClientConnection)NettyMessagingService.this.clientConnections.remove(context.channel());
            if (clientConnection != null) {
                clientConnection.close();
            }
            if ((serverConnection = (RemoteServerConnection)NettyMessagingService.this.serverConnections.remove(context.channel())) != null) {
                serverConnection.close();
            }
            context.close();
        }

        public final boolean acceptInboundMessage(Object msg) {
            return msg instanceof InternalMessage;
        }
    }

    private class BasicChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final ChannelHandler dispatcher;

        private BasicChannelInitializer() {
            this.dispatcher = new InboundMessageDispatcher();
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            channel.pipeline().addLast("encoder", (ChannelHandler)new MessageEncoder(NettyMessagingService.this.localAddress, NettyMessagingService.this.preamble)).addLast("decoder", (ChannelHandler)new MessageDecoder()).addLast("handler", this.dispatcher);
        }
    }

    private class SslClientCommunicationChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final ChannelHandler dispatcher;

        private SslClientCommunicationChannelInitializer() {
            this.dispatcher = new InboundMessageDispatcher();
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            SSLContext clientContext = SSLContext.getInstance("TLS");
            clientContext.init(NettyMessagingService.this.keyManager.getKeyManagers(), NettyMessagingService.this.trustManager.getTrustManagers(), null);
            SSLEngine clientSslEngine = clientContext.createSSLEngine();
            clientSslEngine.setUseClientMode(true);
            clientSslEngine.setEnabledProtocols(clientSslEngine.getSupportedProtocols());
            clientSslEngine.setEnabledCipherSuites(clientSslEngine.getSupportedCipherSuites());
            clientSslEngine.setEnableSessionCreation(true);
            channel.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(clientSslEngine)).addLast("encoder", (ChannelHandler)new MessageEncoder(NettyMessagingService.this.localAddress, NettyMessagingService.this.preamble)).addLast("decoder", (ChannelHandler)new MessageDecoder()).addLast("handler", this.dispatcher);
        }
    }

    private class SslServerCommunicationChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final ChannelHandler dispatcher;

        private SslServerCommunicationChannelInitializer() {
            this.dispatcher = new InboundMessageDispatcher();
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            SSLContext serverContext = SSLContext.getInstance("TLS");
            serverContext.init(NettyMessagingService.this.keyManager.getKeyManagers(), NettyMessagingService.this.trustManager.getTrustManagers(), null);
            SSLEngine serverSslEngine = serverContext.createSSLEngine();
            serverSslEngine.setNeedClientAuth(true);
            serverSslEngine.setUseClientMode(false);
            serverSslEngine.setEnabledProtocols(serverSslEngine.getSupportedProtocols());
            serverSslEngine.setEnabledCipherSuites(serverSslEngine.getSupportedCipherSuites());
            serverSslEngine.setEnableSessionCreation(true);
            channel.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(serverSslEngine)).addLast("encoder", (ChannelHandler)new MessageEncoder(NettyMessagingService.this.localAddress, NettyMessagingService.this.preamble)).addLast("decoder", (ChannelHandler)new MessageDecoder()).addLast("handler", this.dispatcher);
        }
    }

    public static class Builder
    extends MessagingService.Builder {
        private String name = "atomix";
        private Address address;

        public Builder withName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public Builder withAddress(Address address) {
            this.address = (Address)Preconditions.checkNotNull((Object)address);
            return this;
        }

        public ManagedMessagingService build() {
            if (this.address == null) {
                this.address = Address.local();
            }
            return new NettyMessagingService(this.name.hashCode(), this.address);
        }
    }
}

