/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.ProxyIterator;
import io.atomix.core.map.AsyncAtomicNavigableMap;
import io.atomix.core.map.AtomicMapEvent;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.map.AtomicNavigableMap;
import io.atomix.core.map.impl.AbstractAtomicMapProxy;
import io.atomix.core.map.impl.AtomicMapService;
import io.atomix.core.map.impl.AtomicTreeMapService;
import io.atomix.core.map.impl.BlockingAtomicNavigableMap;
import io.atomix.core.map.impl.DescendingAsyncAtomicNavigableMap;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.set.AsyncDistributedNavigableSet;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.AsyncDistributedSortedSet;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.impl.BlockingDistributedNavigableSet;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.core.set.impl.DescendingAsyncDistributedNavigableSet;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AtomicNavigableMapProxy<K extends Comparable<K>>
extends AbstractAtomicMapProxy<AsyncAtomicNavigableMap<K, byte[]>, AtomicTreeMapService<K>, K>
implements AsyncAtomicNavigableMap<K, byte[]> {
    public AtomicNavigableMapProxy(ProxyClient<AtomicTreeMapService<K>> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
    }

    protected K greaterKey(K a, K b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    protected K lesserKey(K a, K b) {
        return a.compareTo(b) < 0 ? a : b;
    }

    protected Map.Entry<K, Versioned<byte[]>> greaterEntry(Map.Entry<K, Versioned<byte[]>> a, Map.Entry<K, Versioned<byte[]>> b) {
        return ((Comparable)a.getKey()).compareTo(b.getKey()) > 0 ? a : b;
    }

    protected Map.Entry<K, Versioned<byte[]>> lesserEntry(Map.Entry<K, Versioned<byte[]>> a, Map.Entry<K, Versioned<byte[]>> b) {
        return ((Comparable)a.getKey()).compareTo(b.getKey()) < 0 ? a : b;
    }

    @Override
    public CompletableFuture<K> firstKey() {
        return this.getProxyClient().applyAll(service -> service.firstKey()).thenApply(results -> results.filter(Objects::nonNull).reduce(this::lesserKey).orElse(null));
    }

    @Override
    public CompletableFuture<K> lastKey() {
        return this.getProxyClient().applyAll(service -> service.lastKey()).thenApply(results -> results.filter(Objects::nonNull).reduce(this::greaterKey).orElse(null));
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> ceilingEntry(K key) {
        return this.getProxyClient().applyAll(service -> service.ceilingEntry(key)).thenApply(results -> results.filter(Objects::nonNull).reduce(this::lesserEntry).orElse(null));
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> floorEntry(K key) {
        return this.getProxyClient().applyAll(service -> service.floorEntry(key)).thenApply(results -> results.filter(Objects::nonNull).reduce(this::greaterEntry).orElse(null));
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> higherEntry(K key) {
        return this.getProxyClient().applyAll(service -> service.higherEntry(key)).thenApply(results -> results.filter(Objects::nonNull).reduce(this::lesserEntry).orElse(null));
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> lowerEntry(K key) {
        return this.getProxyClient().applyAll(service -> service.lowerEntry(key)).thenApply(results -> results.filter(Objects::nonNull).reduce(this::greaterEntry).orElse(null));
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> firstEntry() {
        return this.getProxyClient().applyAll(service -> service.firstEntry()).thenApply(results -> results.filter(Objects::nonNull).reduce(this::lesserEntry).orElse(null));
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> lastEntry() {
        return this.getProxyClient().applyAll(service -> service.lastEntry()).thenApply(results -> results.filter(Objects::nonNull).reduce(this::greaterEntry).orElse(null));
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> pollFirstEntry() {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> pollLastEntry() {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public CompletableFuture<K> lowerKey(K key) {
        return this.getProxyClient().applyAll(service -> service.lowerKey(key)).thenApply(results -> results.filter(Objects::nonNull).reduce(this::greaterKey).orElse(null));
    }

    @Override
    public CompletableFuture<K> floorKey(K key) {
        return this.getProxyClient().applyAll(service -> service.floorKey(key)).thenApply(results -> results.filter(Objects::nonNull).reduce(this::greaterKey).orElse(null));
    }

    @Override
    public CompletableFuture<K> ceilingKey(K key) {
        return this.getProxyClient().applyAll(service -> service.ceilingKey(key)).thenApply(results -> results.filter(Objects::nonNull).reduce(this::lesserKey).orElse(null));
    }

    @Override
    public CompletableFuture<K> higherKey(K key) {
        return this.getProxyClient().applyAll(service -> service.higherKey(key)).thenApply(results -> results.filter(Objects::nonNull).reduce(this::lesserKey).orElse(null));
    }

    @Override
    public AsyncAtomicNavigableMap<K, byte[]> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new SubMap(this, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public AsyncAtomicNavigableMap<K, byte[]> headMap(K toKey, boolean inclusive) {
        return new SubMap(this, null, false, toKey, inclusive);
    }

    @Override
    public AsyncAtomicNavigableMap<K, byte[]> tailMap(K fromKey, boolean inclusive) {
        return new SubMap(this, fromKey, inclusive, null, false);
    }

    @Override
    public AsyncDistributedNavigableSet<K> navigableKeySet() {
        return new KeySet(this, null, false, null, false);
    }

    @Override
    public AsyncAtomicNavigableMap<K, byte[]> descendingMap() {
        return new DescendingAsyncAtomicNavigableMap(this);
    }

    @Override
    public AsyncDistributedNavigableSet<K> descendingKeySet() {
        return this.navigableKeySet().descendingSet();
    }

    @Override
    public AtomicNavigableMap<K, byte[]> sync(Duration operationTimeout) {
        return new BlockingAtomicNavigableMap(this, operationTimeout.toMillis());
    }

    private class Values
    extends SubSet
    implements AsyncDistributedCollection<Versioned<byte[]>> {
        private final Map<CollectionEventListener<Versioned<byte[]>>, AtomicMapEventListener<K, byte[]>> listenerMap;
        final /* synthetic */ AtomicNavigableMapProxy this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        Values(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            this.this$0 = (AtomicNavigableMapProxy)n;
            super((AtomicNavigableMapProxy)n, fromKey, fromInclusive, toKey, toInclusive);
            this.listenerMap = Maps.newConcurrentMap();
        }

        @Override
        public CompletableFuture<Boolean> add(Versioned<byte[]> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(Versioned<byte[]> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> size() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapSize(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return this.size().thenApply(size -> size == 0);
        }

        @Override
        public CompletableFuture<Void> clear() {
            return this.this$0.getProxyClient().acceptBy(this.name(), service -> service.subMapClear(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> contains(Versioned<byte[]> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends Versioned<byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends Versioned<byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends Versioned<byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends Versioned<byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> addListener(CollectionEventListener<Versioned<byte[]>> listener, Executor executor) {
            AtomicMapEventListener boundedListener = event -> {
                if (this.isInBounds((Comparable)event.key())) {
                    switch ((AtomicMapEvent.Type)event.type()) {
                        case INSERT: {
                            listener.event((Event)new CollectionEvent(CollectionEvent.Type.ADD, event.newValue()));
                            break;
                        }
                        case REMOVE: {
                            listener.event((Event)new CollectionEvent(CollectionEvent.Type.REMOVE, event.oldValue()));
                            break;
                        }
                    }
                }
            };
            if (this.listenerMap.putIfAbsent(listener, boundedListener) == null) {
                return this.this$0.addListener(boundedListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeListener(CollectionEventListener<Versioned<byte[]>> listener) {
            AtomicMapEventListener boundedListener = this.listenerMap.remove(listener);
            if (boundedListener != null) {
                return this.this$0.removeListener(boundedListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public AsyncIterator<Versioned<byte[]>> iterator() {
            return new ProxyIterator(this.this$0.getProxyClient(), this.this$0.getProxyClient().getPartitionId(this.name()), service -> service.subMapIterate(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive), AtomicMapService::nextValues, AtomicMapService::closeValues);
        }

        @Override
        public DistributedCollection<Versioned<byte[]>> sync(Duration operationTimeout) {
            return new BlockingDistributedCollection<Versioned<byte[]>>(this, operationTimeout.toMillis());
        }
    }

    private class EntrySet
    extends SubSet
    implements AsyncDistributedSet<Map.Entry<K, Versioned<byte[]>>> {
        private final Map<CollectionEventListener<Map.Entry<K, Versioned<byte[]>>>, AtomicMapEventListener<K, byte[]>> listenerMap;
        final /* synthetic */ AtomicNavigableMapProxy this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        EntrySet(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            this.this$0 = (AtomicNavigableMapProxy)n;
            super((AtomicNavigableMapProxy)n, fromKey, fromInclusive, toKey, toInclusive);
            this.listenerMap = Maps.newConcurrentMap();
        }

        @Override
        public CompletableFuture<Boolean> add(Map.Entry<K, Versioned<byte[]>> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(Map.Entry<K, Versioned<byte[]>> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> size() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapSize(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return this.size().thenApply(size -> size == 0);
        }

        @Override
        public CompletableFuture<Void> clear() {
            return this.this$0.getProxyClient().acceptBy(this.name(), service -> service.subMapClear(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> contains(Map.Entry<K, Versioned<byte[]>> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends Map.Entry<K, Versioned<byte[]>>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends Map.Entry<K, Versioned<byte[]>>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends Map.Entry<K, Versioned<byte[]>>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends Map.Entry<K, Versioned<byte[]>>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> addListener(CollectionEventListener<Map.Entry<K, Versioned<byte[]>>> listener, Executor executor) {
            AtomicMapEventListener boundedListener = event -> {
                if (this.isInBounds((Comparable)event.key())) {
                    switch ((AtomicMapEvent.Type)event.type()) {
                        case INSERT: {
                            listener.event((Event)new CollectionEvent<Map.Entry>(CollectionEvent.Type.ADD, Maps.immutableEntry(event.key(), event.newValue())));
                            break;
                        }
                        case REMOVE: {
                            listener.event((Event)new CollectionEvent<Map.Entry>(CollectionEvent.Type.REMOVE, Maps.immutableEntry(event.key(), event.oldValue())));
                            break;
                        }
                    }
                }
            };
            if (this.listenerMap.putIfAbsent(listener, boundedListener) == null) {
                return this.this$0.addListener(boundedListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeListener(CollectionEventListener<Map.Entry<K, Versioned<byte[]>>> listener) {
            AtomicMapEventListener boundedListener = this.listenerMap.remove(listener);
            if (boundedListener != null) {
                return this.this$0.removeListener(boundedListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public AsyncIterator<Map.Entry<K, Versioned<byte[]>>> iterator() {
            return new ProxyIterator(this.this$0.getProxyClient(), this.this$0.getProxyClient().getPartitionId(this.name()), service -> service.subMapIterate(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive), AtomicMapService::nextEntries, AtomicMapService::closeEntries);
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<Map.Entry<K, Versioned<byte[]>>>> transactionLog) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.this$0.close();
        }

        @Override
        public DistributedSet<Map.Entry<K, Versioned<byte[]>>> sync(Duration operationTimeout) {
            return new BlockingDistributedSet(this, operationTimeout.toMillis());
        }
    }

    private class SubMap
    extends SubSet
    implements AsyncAtomicNavigableMap<K, byte[]> {
        private final Map<AtomicMapEventListener<K, byte[]>, AtomicMapEventListener<K, byte[]>> listenerMap;
        final /* synthetic */ AtomicNavigableMapProxy this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        SubMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            this.this$0 = (AtomicNavigableMapProxy)n;
            super((AtomicNavigableMapProxy)n, fromKey, fromInclusive, toKey, toInclusive);
            this.listenerMap = Maps.newConcurrentMap();
        }

        @Override
        public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> lowerEntry(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapLowerEntry(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> lowerKey(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapLowerKey(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> floorEntry(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapFloorEntry(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> floorKey(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapFloorKey(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> ceilingEntry(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapCeilingEntry(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> ceilingKey(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapCeilingKey(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> higherEntry(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapHigherEntry(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> higherKey(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapHigherKey(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> firstEntry() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapFirstEntry(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> lastEntry() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapLastEntry(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> pollFirstEntry() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapPollFirstEntry(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Map.Entry<K, Versioned<byte[]>>> pollLastEntry() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapPollLastEntry(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public AsyncAtomicNavigableMap<K, byte[]> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            int order;
            Preconditions.checkNotNull(fromKey);
            Preconditions.checkNotNull(toKey);
            if (this.fromKey != null) {
                order = this.fromKey.compareTo(fromKey);
                if (order == 0) {
                    fromInclusive = this.fromInclusive && fromInclusive;
                } else if (order > 0) {
                    fromKey = this.fromKey;
                    fromInclusive = this.fromInclusive;
                }
            }
            if (this.toKey != null) {
                order = this.toKey.compareTo(toKey);
                if (order == 0) {
                    toInclusive = this.toInclusive && toInclusive;
                } else if (order < 0) {
                    toKey = this.toKey;
                    toInclusive = this.toInclusive;
                }
            }
            return new SubMap(this.this$0, fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public AsyncAtomicNavigableMap<K, byte[]> headMap(K toKey, boolean inclusive) {
            Preconditions.checkNotNull(toKey);
            if (this.toKey != null) {
                int order = this.toKey.compareTo(toKey);
                if (order == 0) {
                    inclusive = this.toInclusive && inclusive;
                } else if (order < 0) {
                    toKey = this.toKey;
                    inclusive = this.toInclusive;
                }
            }
            return new SubMap(this.this$0, this.fromKey, this.fromInclusive, toKey, inclusive);
        }

        @Override
        public AsyncAtomicNavigableMap<K, byte[]> tailMap(K fromKey, boolean inclusive) {
            Preconditions.checkNotNull(fromKey);
            if (this.fromKey != null) {
                int order = this.fromKey.compareTo(fromKey);
                if (order == 0) {
                    inclusive = this.fromInclusive && inclusive;
                } else if (order > 0) {
                    fromKey = this.fromKey;
                    inclusive = this.fromInclusive;
                }
            }
            return new SubMap(this.this$0, fromKey, inclusive, this.toKey, this.toInclusive);
        }

        @Override
        public AsyncAtomicNavigableMap<K, byte[]> descendingMap() {
            return new DescendingAsyncAtomicNavigableMap(this);
        }

        @Override
        public AsyncDistributedNavigableSet<K> navigableKeySet() {
            return new KeySet(this.this$0, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        public AsyncDistributedNavigableSet<K> descendingKeySet() {
            return this.navigableKeySet().descendingSet();
        }

        @Override
        public CompletableFuture<K> firstKey() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapFirstKey(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive)).thenCompose(result -> result != null ? Futures.completedFuture((Object)result) : Futures.exceptionalFuture((Throwable)new NoSuchElementException()));
        }

        @Override
        public CompletableFuture<K> lastKey() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapLastKey(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive)).thenCompose(result -> result != null ? Futures.completedFuture((Object)result) : Futures.exceptionalFuture((Throwable)new NoSuchElementException()));
        }

        @Override
        public CompletableFuture<Integer> size() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapSize(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> containsKey(K key) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(false) : this.this$0.containsKey(key);
        }

        @Override
        public CompletableFuture<Boolean> containsValue(byte[] value) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Versioned<byte[]>> get(K key) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(null) : this.this$0.get(key);
        }

        @Override
        public CompletableFuture<Map<K, Versioned<byte[]>>> getAllPresent(Iterable<K> keys) {
            return this.this$0.getAllPresent(Lists.newArrayList(keys).stream().filter(this::isInBounds).collect(Collectors.toList()));
        }

        @Override
        public CompletableFuture<Versioned<byte[]>> getOrDefault(K key, byte[] defaultValue) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(null) : this.this$0.getOrDefault(key, defaultValue);
        }

        @Override
        public CompletableFuture<Versioned<byte[]>> computeIf(K key, Predicate<? super byte[]> condition, BiFunction<? super K, ? super byte[], ? extends byte[]> remappingFunction) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(null) : this.this$0.computeIf(key, condition, remappingFunction);
        }

        @Override
        public CompletableFuture<Versioned<byte[]>> put(K key, byte[] value, Duration ttl) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(null) : this.this$0.put(key, value, ttl);
        }

        @Override
        public CompletableFuture<Versioned<byte[]>> putAndGet(K key, byte[] value, Duration ttl) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(null) : this.this$0.putAndGet(key, value, ttl);
        }

        @Override
        public CompletableFuture<Versioned<byte[]>> remove(K key) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(null) : this.this$0.remove(key);
        }

        @Override
        public CompletableFuture<Void> clear() {
            return this.this$0.getProxyClient().acceptBy(this.name(), service -> service.subMapClear(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public AsyncDistributedSet<K> keySet() {
            return new KeySet(this.this$0, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        public AsyncDistributedCollection<Versioned<byte[]>> values() {
            return new Values(this.this$0, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        public AsyncDistributedSet<Map.Entry<K, Versioned<byte[]>>> entrySet() {
            return new EntrySet(this.this$0, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        public CompletableFuture<Versioned<byte[]>> putIfAbsent(K key, byte[] value, Duration ttl) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(null) : this.this$0.putIfAbsent(key, value, ttl);
        }

        @Override
        public CompletableFuture<Boolean> remove(K key, byte[] value) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(false) : this.this$0.remove(key, value);
        }

        @Override
        public CompletableFuture<Boolean> remove(K key, long version) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(false) : this.this$0.remove(key, version);
        }

        @Override
        public CompletableFuture<Versioned<byte[]>> replace(K key, byte[] value) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(null) : this.this$0.replace(key, value);
        }

        @Override
        public CompletableFuture<Boolean> replace(K key, byte[] oldValue, byte[] newValue) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(false) : this.this$0.replace(key, oldValue, newValue);
        }

        @Override
        public CompletableFuture<Boolean> replace(K key, long oldVersion, byte[] newValue) {
            return !this.isInBounds(key) ? CompletableFuture.completedFuture(false) : this.this$0.replace(key, oldVersion, newValue);
        }

        @Override
        public synchronized CompletableFuture<Void> addListener(AtomicMapEventListener<K, byte[]> listener, Executor executor) {
            AtomicMapEventListener boundedListener = event -> {
                if (this.isInBounds((Comparable)event.key())) {
                    listener.event(event);
                }
            };
            if (this.listenerMap.putIfAbsent(listener, boundedListener) == null) {
                return this.this$0.addListener(boundedListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> removeListener(AtomicMapEventListener<K, byte[]> listener) {
            AtomicMapEventListener boundedListener = this.listenerMap.remove(listener);
            if (boundedListener != null) {
                return this.this$0.removeListener(boundedListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<K, byte[]>> transactionLog) {
            return this.this$0.prepare(transactionLog);
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            return this.this$0.commit(transactionId);
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            return this.this$0.rollback(transactionId);
        }

        @Override
        public AtomicNavigableMap<K, byte[]> sync(Duration operationTimeout) {
            return new BlockingAtomicNavigableMap(this, operationTimeout.toMillis());
        }
    }

    private class KeySet
    extends SubSet
    implements AsyncDistributedNavigableSet<K> {
        private final Map<CollectionEventListener<K>, AtomicMapEventListener<K, byte[]>> listenerMap;
        final /* synthetic */ AtomicNavigableMapProxy this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        KeySet(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            this.this$0 = (AtomicNavigableMapProxy)n;
            super((AtomicNavigableMapProxy)n, fromKey, fromInclusive, toKey, toInclusive);
            this.listenerMap = Maps.newConcurrentMap();
        }

        @Override
        public CompletableFuture<K> lower(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapLowerKey(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> floor(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapFloorKey(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> ceiling(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapCeilingKey(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> higher(K key) {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapHigherKey(key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> pollFirst() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapPollFirstKey(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<K> pollLast() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapPollLastKey(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public AsyncDistributedNavigableSet<K> descendingSet() {
            return new DescendingAsyncDistributedNavigableSet(this);
        }

        @Override
        public AsyncIterator<K> iterator() {
            return new ProxyIterator(this.this$0.getProxyClient(), this.this$0.getProxyClient().getPartitionId(this.name()), service -> service.subMapIterate(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive), AtomicMapService::nextKeys, AtomicMapService::closeKeys);
        }

        @Override
        public AsyncIterator<K> descendingIterator() {
            return new ProxyIterator(this.this$0.getProxyClient(), this.this$0.getProxyClient().getPartitionId(this.name()), service -> service.subMapIterateDescending(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive), AtomicMapService::nextKeys, AtomicMapService::closeKeys);
        }

        @Override
        public AsyncDistributedNavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            int order;
            Preconditions.checkNotNull(fromElement);
            Preconditions.checkNotNull(toElement);
            if (this.fromKey != null) {
                order = this.fromKey.compareTo(fromElement);
                if (order == 0) {
                    fromInclusive = this.fromInclusive && fromInclusive;
                } else if (order > 0) {
                    fromElement = this.fromKey;
                    fromInclusive = this.fromInclusive;
                }
            }
            if (this.toKey != null) {
                order = this.toKey.compareTo(toElement);
                if (order == 0) {
                    toInclusive = this.toInclusive && toInclusive;
                } else if (order < 0) {
                    toElement = this.toKey;
                    toInclusive = this.toInclusive;
                }
            }
            return new KeySet(this.this$0, fromElement, fromInclusive, toElement, toInclusive);
        }

        @Override
        public AsyncDistributedNavigableSet<K> headSet(K toElement, boolean inclusive) {
            Preconditions.checkNotNull(toElement);
            if (this.toKey != null) {
                int order = this.toKey.compareTo(toElement);
                if (order == 0) {
                    inclusive = this.toInclusive && inclusive;
                } else if (order < 0) {
                    toElement = this.toKey;
                    inclusive = this.toInclusive;
                }
            }
            return new KeySet(this.this$0, this.fromKey, this.fromInclusive, toElement, inclusive);
        }

        @Override
        public AsyncDistributedNavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            Preconditions.checkNotNull(fromElement);
            if (this.fromKey != null) {
                int order = this.fromKey.compareTo(fromElement);
                if (order == 0) {
                    inclusive = this.fromInclusive && inclusive;
                } else if (order > 0) {
                    fromElement = this.fromKey;
                    inclusive = this.fromInclusive;
                }
            }
            return new KeySet(this.this$0, fromElement, inclusive, this.toKey, this.toInclusive);
        }

        @Override
        public AsyncDistributedSortedSet<K> subSet(K fromElement, K toElement) {
            return this.subSet((K)fromElement, true, (K)toElement, false);
        }

        @Override
        public AsyncDistributedSortedSet<K> headSet(K toElement) {
            return this.headSet((K)toElement, false);
        }

        @Override
        public AsyncDistributedSortedSet<K> tailSet(K fromElement) {
            return this.tailSet((K)fromElement, true);
        }

        @Override
        public CompletableFuture<K> first() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapFirstKey(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive)).thenCompose(result -> result != null ? Futures.completedFuture((Object)result) : Futures.exceptionalFuture((Throwable)new NoSuchElementException()));
        }

        @Override
        public CompletableFuture<K> last() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapLastKey(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive)).thenCompose(result -> result != null ? Futures.completedFuture((Object)result) : Futures.exceptionalFuture((Throwable)new NoSuchElementException()));
        }

        @Override
        public CompletableFuture<Boolean> add(K element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(K element) {
            if (!this.isInBounds(element)) {
                return CompletableFuture.completedFuture(false);
            }
            return this.this$0.remove(element).thenApply(Objects::nonNull);
        }

        @Override
        public CompletableFuture<Integer> size() {
            return this.this$0.getProxyClient().applyBy(this.name(), service -> service.subMapSize(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return this.size().thenApply(size -> size == 0);
        }

        @Override
        public CompletableFuture<Void> clear() {
            return this.this$0.getProxyClient().acceptBy(this.name(), service -> service.subMapClear(this.fromKey, this.fromInclusive, this.toKey, this.toInclusive));
        }

        @Override
        public CompletableFuture<Boolean> contains(K element) {
            return !this.isInBounds(element) ? CompletableFuture.completedFuture(false) : this.this$0.containsKey(element);
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends K> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends K> c) {
            if (c.stream().map(this::isInBounds).reduce(Boolean::logicalAnd).orElse(true).booleanValue()) {
                return this.this$0.getProxyClient().applyBy(this.name(), service -> service.containsKeys(c));
            }
            return CompletableFuture.completedFuture(false);
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends K> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends K> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> addListener(CollectionEventListener<K> listener, Executor executor) {
            AtomicMapEventListener mapListener = event -> {
                switch ((AtomicMapEvent.Type)event.type()) {
                    case INSERT: {
                        listener.event((Event)new CollectionEvent(CollectionEvent.Type.ADD, event.key()));
                        break;
                    }
                    case REMOVE: {
                        listener.event((Event)new CollectionEvent(CollectionEvent.Type.REMOVE, event.key()));
                        break;
                    }
                }
            };
            if (this.listenerMap.putIfAbsent(listener, mapListener) == null) {
                return this.this$0.addListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeListener(CollectionEventListener<K> listener) {
            AtomicMapEventListener mapListener = this.listenerMap.remove(listener);
            if (mapListener != null) {
                return this.this$0.removeListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<K>> transactionLog) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.this$0.close();
        }

        @Override
        public DistributedNavigableSet<K> sync(Duration operationTimeout) {
            return new BlockingDistributedNavigableSet(this, operationTimeout.toMillis());
        }
    }

    protected abstract class SubSet
    implements AsyncPrimitive {
        protected final K fromKey;
        protected final boolean fromInclusive;
        protected final K toKey;
        protected final boolean toInclusive;
        final /* synthetic */ AtomicNavigableMapProxy this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public SubSet(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            this.this$0 = (AtomicNavigableMapProxy)this$0;
            this.fromKey = fromKey;
            this.fromInclusive = fromInclusive;
            this.toKey = toKey;
            this.toInclusive = toInclusive;
        }

        public String name() {
            return this.this$0.name();
        }

        public PrimitiveType type() {
            return this.this$0.type();
        }

        public PrimitiveProtocol protocol() {
            return this.this$0.protocol();
        }

        protected boolean isInBounds(K key) {
            return key != null && this.isInLowerBounds(key) && this.isInUpperBounds(key);
        }

        protected boolean isInLowerBounds(K key) {
            if (this.fromKey != null) {
                int lower = key.compareTo(this.fromKey);
                if (!this.fromInclusive && lower <= 0 || this.fromInclusive && lower < 0) {
                    return false;
                }
            }
            return true;
        }

        protected boolean isInUpperBounds(K key) {
            if (this.toKey != null) {
                int upper = key.compareTo(this.toKey);
                if (!this.toInclusive && upper >= 0 || this.toInclusive && upper > 0) {
                    return false;
                }
            }
            return true;
        }

        public CompletableFuture<Void> close() {
            return this.this$0.close();
        }
    }
}

