/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AsyncAtomicNavigableMap;
import io.atomix.core.map.AtomicNavigableMap;
import io.atomix.core.map.impl.BlockingAtomicNavigableMap;
import io.atomix.core.map.impl.TranscodingAsyncAtomicSortedMap;
import io.atomix.core.set.AsyncDistributedNavigableSet;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TranscodingAsyncAtomicNavigableMap<K extends Comparable<K>, V1, V2>
extends TranscodingAsyncAtomicSortedMap<K, V1, V2>
implements AsyncAtomicNavigableMap<K, V1> {
    private final AsyncAtomicNavigableMap<K, V2> backingMap;

    public TranscodingAsyncAtomicNavigableMap(AsyncAtomicNavigableMap<K, V2> backingMap, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        super(backingMap, valueEncoder, valueDecoder);
        this.backingMap = backingMap;
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<V1>>> lowerEntry(K key) {
        return this.backingMap.lowerEntry((Comparable)this.keyEncoder.apply(key)).thenApply(this.entryDecoder);
    }

    @Override
    public CompletableFuture<K> lowerKey(K key) {
        return this.backingMap.lowerKey((Comparable)this.keyEncoder.apply(key)).thenApply(this.keyDecoder);
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<V1>>> floorEntry(K key) {
        return this.backingMap.floorEntry((Comparable)this.keyEncoder.apply(key)).thenApply(this.entryDecoder);
    }

    @Override
    public CompletableFuture<K> floorKey(K key) {
        return this.backingMap.floorKey((Comparable)this.keyEncoder.apply(key)).thenApply(this.keyDecoder);
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<V1>>> ceilingEntry(K key) {
        return this.backingMap.ceilingEntry((Comparable)this.keyEncoder.apply(key)).thenApply(this.entryDecoder);
    }

    @Override
    public CompletableFuture<K> ceilingKey(K key) {
        return this.backingMap.ceilingKey((Comparable)this.keyEncoder.apply(key)).thenApply(this.keyDecoder);
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<V1>>> higherEntry(K key) {
        return this.backingMap.higherEntry((Comparable)this.keyEncoder.apply(key)).thenApply(this.entryDecoder);
    }

    @Override
    public CompletableFuture<K> higherKey(K key) {
        return this.backingMap.higherKey((Comparable)this.keyEncoder.apply(key)).thenApply(this.keyDecoder);
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<V1>>> firstEntry() {
        return this.backingMap.firstEntry().thenApply(this.entryDecoder);
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<V1>>> lastEntry() {
        return this.backingMap.lastEntry().thenApply(this.entryDecoder);
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<V1>>> pollFirstEntry() {
        return this.backingMap.pollFirstEntry().thenApply(this.entryDecoder);
    }

    @Override
    public CompletableFuture<Map.Entry<K, Versioned<V1>>> pollLastEntry() {
        return this.backingMap.pollLastEntry().thenApply(this.entryDecoder);
    }

    @Override
    public AsyncAtomicNavigableMap<K, V1> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new TranscodingAsyncAtomicNavigableMap<Comparable, V1, V2>(this.backingMap.subMap((Comparable)this.keyEncoder.apply(fromKey), fromInclusive, (Comparable)this.keyEncoder.apply(toKey), toInclusive), this.valueEncoder, this.valueDecoder);
    }

    @Override
    public AsyncAtomicNavigableMap<K, V1> headMap(K toKey, boolean inclusive) {
        return new TranscodingAsyncAtomicNavigableMap<Comparable, V1, V2>(this.backingMap.headMap((Comparable)this.keyEncoder.apply(toKey), inclusive), this.valueEncoder, this.valueDecoder);
    }

    @Override
    public AsyncAtomicNavigableMap<K, V1> tailMap(K fromKey, boolean inclusive) {
        return new TranscodingAsyncAtomicNavigableMap<Comparable, V1, V2>(this.backingMap.tailMap((Comparable)this.keyEncoder.apply(fromKey), inclusive), this.valueEncoder, this.valueDecoder);
    }

    @Override
    public AsyncAtomicNavigableMap<K, V1> descendingMap() {
        return new TranscodingAsyncAtomicNavigableMap<K, V1, V2>(this.backingMap.descendingMap(), this.valueEncoder, this.valueDecoder);
    }

    @Override
    public AsyncDistributedNavigableSet<K> navigableKeySet() {
        return this.backingMap.navigableKeySet();
    }

    @Override
    public AsyncDistributedNavigableSet<K> descendingKeySet() {
        return this.backingMap.descendingKeySet();
    }

    @Override
    public AtomicNavigableMap<K, V1> sync(Duration timeout) {
        return new BlockingAtomicNavigableMap(this, timeout.toMillis());
    }
}

