/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.grpc.netty;

import java.util.List;
import org.apache.zeppelin.jupyter.io.grpc.Attributes;
import org.apache.zeppelin.jupyter.io.grpc.Internal;
import org.apache.zeppelin.jupyter.io.grpc.ServerStreamTracer;
import org.apache.zeppelin.jupyter.io.grpc.internal.SharedResourcePool;
import org.apache.zeppelin.jupyter.io.grpc.internal.TransportTracer;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.grpc.netty.NettyServer;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.grpc.netty.Utils;
import org.apache.zeppelin.jupyter.io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;

@Internal
public final class InternalNettyServerBuilder {
    public static NettyServer buildTransportServers(NettyServerBuilder builder, List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        return builder.buildTransportServers(streamTracerFactories);
    }

    public static void setTransportTracerFactory(NettyServerBuilder builder, TransportTracer.Factory transportTracerFactory) {
        builder.setTransportTracerFactory(transportTracerFactory);
    }

    public static void setStatsEnabled(NettyServerBuilder builder, boolean value) {
        builder.setStatsEnabled(value);
    }

    public static void setStatsRecordStartedRpcs(NettyServerBuilder builder, boolean value) {
        builder.setStatsRecordStartedRpcs(value);
    }

    public static void setStatsRecordRealTimeMetrics(NettyServerBuilder builder, boolean value) {
        builder.setStatsRecordRealTimeMetrics(value);
    }

    public static void setTracingEnabled(NettyServerBuilder builder, boolean value) {
        builder.setTracingEnabled(value);
    }

    public static void setForceHeapBuffer(NettyServerBuilder builder, boolean value) {
        builder.setForceHeapBuffer(value);
    }

    public static void useNioTransport(NettyServerBuilder builder) {
        builder.channelType(NioServerSocketChannel.class);
        builder.bossEventLoopGroupPool(SharedResourcePool.forResource(Utils.NIO_BOSS_EVENT_LOOP_GROUP));
        builder.workerEventLoopGroupPool(SharedResourcePool.forResource(Utils.NIO_WORKER_EVENT_LOOP_GROUP));
    }

    public static void eagAttributes(NettyServerBuilder builder, Attributes eagAttributes) {
        builder.eagAttributes(eagAttributes);
    }

    private InternalNettyServerBuilder() {
    }
}

