/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.tabledata;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.tabledata.ColumnDef;
import org.apache.zeppelin.tabledata.Row;
import org.apache.zeppelin.tabledata.TableData;

public class InterpreterResultTableData
implements TableData,
Serializable {
    private final InterpreterResultMessage msg;
    ColumnDef[] columnDef;
    List<Row> rows = new LinkedList<Row>();

    public InterpreterResultTableData(InterpreterResultMessage msg) {
        this.msg = msg;
        String[] lines = msg.getData().split("\n");
        if (lines == null || lines.length == 0) {
            this.columnDef = null;
        } else {
            String[] headerRow = lines[0].split("\t");
            this.columnDef = new ColumnDef[headerRow.length];
            for (int i = 0; i < headerRow.length; ++i) {
                this.columnDef[i] = new ColumnDef(headerRow[i], ColumnDef.TYPE.STRING);
            }
            for (int r = 1; r < lines.length; ++r) {
                Object[] row = lines[r].split("\t");
                this.rows.add(new Row(row));
            }
        }
    }

    @Override
    public ColumnDef[] columns() {
        return this.columnDef;
    }

    @Override
    public Iterator<Row> rows() {
        return this.rows.iterator();
    }
}

