/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.function.Function;

public class Leader<T> {
    private final T id;
    private final long term;
    private final long termStartTime;

    public Leader(T id, long term, long termStartTime) {
        this.id = Preconditions.checkNotNull(id);
        Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be non-negative");
        this.term = term;
        Preconditions.checkArgument((termStartTime >= 0L ? 1 : 0) != 0, (Object)"termStartTime must be non-negative");
        this.termStartTime = termStartTime;
    }

    public T id() {
        return this.id;
    }

    public long term() {
        return this.term;
    }

    public long timestamp() {
        return this.termStartTime;
    }

    public <U> Leader<U> map(Function<T, U> mapper) {
        return new Leader<U>(mapper.apply(this.id), this.term, this.termStartTime);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && other instanceof Leader) {
            Leader that = (Leader)other;
            return Objects.equal(this.id, that.id) && this.term == that.term && this.termStartTime == that.termStartTime;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.term, this.termStartTime});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id).add("term", this.term).add("termStartTime", this.termStartTime).toString();
    }
}

