/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multiset.impl;

import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.atomix.core.collection.impl.TranscodingAsyncDistributedCollection;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.impl.BlockingDistributedMultiset;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.impl.TranscodingAsyncDistributedSet;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TranscodingAsyncDistributedMultiset<E1, E2>
extends TranscodingAsyncDistributedCollection<E1, E2>
implements AsyncDistributedMultiset<E1> {
    private final AsyncDistributedMultiset<E2> backingMultiset;
    private final Function<E1, E2> elementEncoder;
    private final Function<E2, E1> elementDecoder;

    public TranscodingAsyncDistributedMultiset(AsyncDistributedMultiset<E2> backingMultiset, Function<E1, E2> elementEncoder, Function<E2, E1> elementDecoder) {
        super(backingMultiset, elementEncoder, elementDecoder);
        this.backingMultiset = backingMultiset;
        this.elementEncoder = k -> k == null ? null : elementEncoder.apply(k);
        this.elementDecoder = k -> k == null ? null : elementDecoder.apply(k);
    }

    @Override
    public CompletableFuture<Integer> count(Object element) {
        return this.backingMultiset.count(this.elementEncoder.apply(element));
    }

    @Override
    public CompletableFuture<Integer> add(E1 element, int occurrences) {
        return this.backingMultiset.add(this.elementEncoder.apply(element), occurrences);
    }

    @Override
    public CompletableFuture<Integer> remove(Object element, int occurrences) {
        return this.backingMultiset.remove(this.elementEncoder.apply(element), occurrences);
    }

    @Override
    public CompletableFuture<Integer> setCount(E1 element, int count) {
        return this.backingMultiset.setCount(this.elementEncoder.apply(element), count);
    }

    @Override
    public CompletableFuture<Boolean> setCount(E1 element, int oldCount, int newCount) {
        return this.backingMultiset.setCount(this.elementEncoder.apply(element), oldCount, newCount);
    }

    @Override
    public AsyncDistributedSet<E1> elementSet() {
        return new TranscodingAsyncDistributedSet<E1, E2>(this.backingMultiset.elementSet(), this.elementEncoder, this.elementDecoder);
    }

    @Override
    public AsyncDistributedSet<Multiset.Entry<E1>> entrySet() {
        Function<Multiset.Entry, Multiset.Entry> entryEncoder = entry -> Multisets.immutableEntry(this.elementEncoder.apply(entry.getElement()), (int)entry.getCount());
        Function<Multiset.Entry, Multiset.Entry> entryDecoder = entry -> Multisets.immutableEntry(this.elementDecoder.apply(entry.getElement()), (int)entry.getCount());
        return new TranscodingAsyncDistributedSet<Multiset.Entry, Multiset.Entry>(this.backingMultiset.entrySet(), entryEncoder, entryDecoder);
    }

    @Override
    public DistributedMultiset<E1> sync(Duration operationTimeout) {
        return new BlockingDistributedMultiset(this, operationTimeout.toMillis());
    }
}

