/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Operation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.WatchListDeletable;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.StatefulSetOperationsImpl;

class StatefulSetRollingUpdater
extends RollingUpdater<StatefulSet, StatefulSetList> {
    StatefulSetRollingUpdater(ClientContext clientContext, String namespace) {
        super(clientContext, namespace);
    }

    StatefulSetRollingUpdater(ClientContext clientContext, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(clientContext, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected StatefulSet createClone(StatefulSet obj, String newName, String newDeploymentHash) {
        return ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)((StatefulSetFluent.SpecNested)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)new StatefulSetBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected WatchListDeletable<Pod, PodList> selectedPodLister(StatefulSet obj) {
        return this.selectedPodLister(obj.getSpec().getSelector());
    }

    @Override
    protected StatefulSet updateDeploymentKey(String name, String hash) {
        StatefulSet old = (StatefulSet)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        StatefulSet updated = ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)new StatefulSetBuilder(old).editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec()).build();
        return ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace(updated);
    }

    @Override
    protected StatefulSet removeDeploymentKey(String name) {
        StatefulSet old = (StatefulSet)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        StatefulSet updated = ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)new StatefulSetBuilder(old).editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec()).build();
        return ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace(updated);
    }

    @Override
    protected int getReplicas(StatefulSet obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected StatefulSet setReplicas(StatefulSet obj, int replicas) {
        return ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)new StatefulSetBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> resources() {
        return new StatefulSetOperationsImpl(this.clientContext);
    }
}

