# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "monitor metrics list-sub-definitions",
)
class ListSubDefinitions(AAZCommand):
    """List the metric definitions for the subscription.
    """

    _aaz_info = {
        "version": "2023-10-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.insights/metricdefinitions", "2023-10-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.metricnamespace = AAZStrArg(
            options=["--metricnamespace"],
            help="Metric namespace where the metrics you want reside.",
        )
        _args_schema.region = AAZStrArg(
            options=["--region"],
            help="The region where the metrics you want reside.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.MetricDefinitionsListAtSubscriptionScope(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        return result

    class MetricDefinitionsListAtSubscriptionScope(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metricDefinitions",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "metricnamespace", self.ctx.args.metricnamespace,
                ),
                **self.serialize_query_param(
                    "region", self.ctx.args.region,
                    required=True,
                ),
                **self.serialize_query_param(
                    "api-version", "2023-10-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.value = AAZListType(
                flags={"required": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.category = AAZStrType()
            _element.dimensions = AAZListType()
            _element.display_description = AAZStrType(
                serialized_name="displayDescription",
            )
            _element.id = AAZStrType()
            _element.is_dimension_required = AAZBoolType(
                serialized_name="isDimensionRequired",
            )
            _element.metric_availabilities = AAZListType(
                serialized_name="metricAvailabilities",
            )
            _element.metric_class = AAZStrType(
                serialized_name="metricClass",
            )
            _element.name = AAZObjectType()
            _ListSubDefinitionsHelper._build_schema_localizable_string_read(_element.name)
            _element.namespace = AAZStrType()
            _element.primary_aggregation_type = AAZStrType(
                serialized_name="primaryAggregationType",
            )
            _element.resource_id = AAZStrType(
                serialized_name="resourceId",
            )
            _element.supported_aggregation_types = AAZListType(
                serialized_name="supportedAggregationTypes",
            )
            _element.unit = AAZStrType()

            dimensions = cls._schema_on_200.value.Element.dimensions
            dimensions.Element = AAZObjectType()
            _ListSubDefinitionsHelper._build_schema_localizable_string_read(dimensions.Element)

            metric_availabilities = cls._schema_on_200.value.Element.metric_availabilities
            metric_availabilities.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.metric_availabilities.Element
            _element.retention = AAZStrType()
            _element.time_grain = AAZStrType(
                serialized_name="timeGrain",
            )

            supported_aggregation_types = cls._schema_on_200.value.Element.supported_aggregation_types
            supported_aggregation_types.Element = AAZStrType()

            return cls._schema_on_200


class _ListSubDefinitionsHelper:
    """Helper class for ListSubDefinitions"""

    _schema_localizable_string_read = None

    @classmethod
    def _build_schema_localizable_string_read(cls, _schema):
        if cls._schema_localizable_string_read is not None:
            _schema.localized_value = cls._schema_localizable_string_read.localized_value
            _schema.value = cls._schema_localizable_string_read.value
            return

        cls._schema_localizable_string_read = _schema_localizable_string_read = AAZObjectType()

        localizable_string_read = _schema_localizable_string_read
        localizable_string_read.localized_value = AAZStrType(
            serialized_name="localizedValue",
        )
        localizable_string_read.value = AAZStrType(
            flags={"required": True},
        )

        _schema.localized_value = cls._schema_localizable_string_read.localized_value
        _schema.value = cls._schema_localizable_string_read.value


__all__ = ["ListSubDefinitions"]
