/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fe10.highlighting.suspender;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.highlighter.ElementAnnotator;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "timeoutSeconds", "", "lastThrownExceptionTimestampPerFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "suspendTimeoutMs", "updateQueue", "Lcom/intellij/util/Alarm;", "suspend", "", "file", "scheduleUpdate", "", "unsuspend", "isSuspended", "cleanup", "updateNotifications", "Companion", "kotlin.highlighting.k1"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinHighlightingSuspender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinHighlightingSuspender.kt\norg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1#2:125\n1869#3,2:126\n1869#3,2:128\n*S KotlinDebug\n*F\n+ 1 KotlinHighlightingSuspender.kt\norg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender\n*L\n113#1:126,2\n114#1:128,2\n*E\n"})
public final class KotlinHighlightingSuspender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final int timeoutSeconds;
    @NotNull
    private final Map<VirtualFile, Long> lastThrownExceptionTimestampPerFile;
    private final long suspendTimeoutMs;
    @NotNull
    private final Alarm updateQueue;

    public KotlinHighlightingSuspender(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.timeoutSeconds = Registry.Companion.intValue("kotlin.highlighting.suspended.timeout", 10);
        this.lastThrownExceptionTimestampPerFile = new LinkedHashMap();
        this.suspendTimeoutMs = TimeUnit.SECONDS.toMillis(this.timeoutSeconds);
        this.updateQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)KotlinPluginDisposable.Companion.getInstance(this.project));
        ElementAnnotator.Companion.getSuppressDeprecatedAnnotationRegistryKey$kotlin_highlighting_k1().addListener(new RegistryValueListener(){

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ElementAnnotator.Companion.updateSuppressDeprecatedAnnotationValue$kotlin_highlighting_k1();
            }
        }, (Disposable)KotlinPluginDisposable.Companion.getInstance(this.project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean suspend(@NotNull VirtualFile file) {
        long l;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.cleanup();
        if (this.suspendTimeoutMs <= 0L) {
            return false;
        }
        long timestamp = System.currentTimeMillis();
        Map<VirtualFile, Long> map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map2) {
            long lastThrownExceptionTimestamp;
            long l2;
            boolean bl = false;
            Long l3 = this.lastThrownExceptionTimestampPerFile.get(file);
            if (l3 != null) {
                l2 = l3;
            } else {
                KotlinHighlightingSuspender $this$suspend_u24lambda_u240_u240 = this;
                boolean bl2 = false;
                $this$suspend_u24lambda_u240_u240.lastThrownExceptionTimestampPerFile.put(file, timestamp);
                l2 = 0L;
            }
            l = lastThrownExceptionTimestamp = l2;
        }
        long lastThrownExceptionTimestamp = l;
        this.scheduleUpdate(file);
        this.updateNotifications(file);
        return timestamp - lastThrownExceptionTimestamp > this.suspendTimeoutMs;
    }

    private final void scheduleUpdate(VirtualFile file) {
        Alarm alarm;
        Alarm $this$scheduleUpdate_u24lambda_u240 = alarm = this.updateQueue;
        boolean bl = false;
        $this$scheduleUpdate_u24lambda_u240.addRequest(() -> KotlinHighlightingSuspender.scheduleUpdate$lambda$0$0(this, file), this.suspendTimeoutMs + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsuspend(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<VirtualFile, Long> map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map2) {
            boolean bl = false;
            Long l = this.lastThrownExceptionTimestampPerFile.remove(file);
        }
        this.cleanup();
        this.updateNotifications(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSuspended(@NotNull VirtualFile file) {
        long l;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.cleanup();
        long timestamp = System.currentTimeMillis();
        Map<VirtualFile, Long> map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map2) {
            boolean bl = false;
            Long l2 = this.lastThrownExceptionTimestampPerFile.get(file);
            if (l2 == null) {
                boolean bl2 = false;
                return bl2;
            }
            long l3 = l2;
            l = l3;
        }
        long lastThrownExceptionTimestamp = l;
        return timestamp - lastThrownExceptionTimestamp < this.suspendTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup() {
        VirtualFile p0;
        long timestamp = System.currentTimeMillis();
        List filesToUpdate = new ArrayList();
        List filesToUpdateLater = new ArrayList();
        Map<VirtualFile, Long> map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map2) {
            boolean bl = false;
            if (this.lastThrownExceptionTimestampPerFile.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<VirtualFile, Long>> it = this.lastThrownExceptionTimestampPerFile.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<VirtualFile, Long> next2 = it.next();
                if (timestamp - ((Number)next2.getValue()).longValue() <= this.suspendTimeoutMs) continue;
                ((Collection)filesToUpdate).add(next2.getKey());
                it.remove();
            }
            boolean bl2 = filesToUpdateLater.addAll((Collection)this.lastThrownExceptionTimestampPerFile.keySet());
        }
        this.updateQueue.cancelAllRequests();
        Iterable $this$forEach$iv = filesToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (VirtualFile)element$iv;
            boolean bl = false;
            this.updateNotifications(p0);
        }
        $this$forEach$iv = filesToUpdateLater;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (VirtualFile)element$iv;
            boolean bl = false;
            this.scheduleUpdate(p0);
        }
    }

    private final void updateNotifications(VirtualFile file) {
        EditorNotifications.getInstance((Project)this.project).updateNotifications(file);
    }

    private static final void scheduleUpdate$lambda$0$0(KotlinHighlightingSuspender this$0, VirtualFile $file) {
        this$0.updateNotifications($file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.highlighting.k1"})
    @SourceDebugExtension(value={"SMAP\nKotlinHighlightingSuspender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinHighlightingSuspender.kt\norg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,124:1\n30#2,2:125\n*S KotlinDebug\n*F\n+ 1 KotlinHighlightingSuspender.kt\norg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender$Companion\n*L\n122#1:125,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinHighlightingSuspender getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinHighlightingSuspender> serviceClass$iv = KotlinHighlightingSuspender.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinHighlightingSuspender)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

