/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeParameterType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J-\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/ConvertNullablePropertyToLateinitIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "", "<init>", "()V", "getFamilyName", "", "isApplicableByPsi", "", "element", "invoke", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtProperty;)Lkotlin/Unit;", "kotlin.code-insight.intentions.shared"})
public final class ConvertNullablePropertyToLateinitIntention
extends KotlinApplicableModCommandAction<KtProperty, Unit> {
    public ConvertNullablePropertyToLateinitIntention() {
        super(Reflection.getOrCreateKotlinClass(KtProperty.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.to.lateinit.var", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtProperty element) {
        KtTypeReference typeReference;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            return false;
        }
        if (element.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            return false;
        }
        if (!element.isVar()) {
            return false;
        }
        if (element.getReceiverTypeReference() != null) {
            return false;
        }
        if (element.hasDelegate()) {
            return false;
        }
        LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element);
        if (!languageVersionSettings.supportsFeature(LanguageFeature.LateinitLocalVariables) && element.isLocal()) {
            return false;
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.LateinitTopLevelProperties) && element.isTopLevel()) {
            return false;
        }
        if (element.getGetter() != null || element.getSetter() != null) {
            return false;
        }
        if (!IfThenUtilsKt.isNullExpression(element.getInitializer())) {
            return false;
        }
        KtTypeReference ktTypeReference = typeReference = element.getTypeReference();
        return (ktTypeReference != null ? ktTypeReference.getTypeElement() : null) instanceof KtNullableType;
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtProperty element, @NotNull Unit elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtTypeReference ktTypeReference = element.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        KtNullableType ktNullableType = ktTypeElement instanceof KtNullableType ? (KtNullableType)ktTypeElement : null;
        if (ktNullableType == null) {
            return;
        }
        KtNullableType ktNullableType2 = ktNullableType;
        KtTypeElement ktTypeElement2 = ktNullableType2.getInnerType();
        if (ktTypeElement2 == null) {
            return;
        }
        KtTypeElement innerType = ktTypeElement2;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        String string = innerType.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        KtTypeReference newTypeReference = ktPsiFactory.createType(string);
        typeReference.replace((PsiElement)newTypeReference);
        element.addModifier(KtTokens.LATEINIT_KEYWORD);
        element.setInitializer(null);
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtProperty element) {
        KaType nonNullableType;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KaType returnType = $this$prepareContext.getSymbol(element).getReturnType();
        if (!element.isLocal()) {
            KaVariableSymbol kaVariableSymbol = $this$prepareContext.getSymbol(element);
            KaPropertySymbol kaPropertySymbol = kaVariableSymbol instanceof KaPropertySymbol ? (KaPropertySymbol)kaVariableSymbol : null;
            if (kaPropertySymbol == null) {
                return null;
            }
            KaPropertySymbol propertySymbol = kaPropertySymbol;
            if (propertySymbol.getBackingFieldSymbol() == null || $this$prepareContext.getHasFlexibleNullability(returnType)) {
                return null;
            }
        }
        if ((nonNullableType = $this$prepareContext.withNullability(returnType, false)) instanceof KaTypeParameterType || $this$prepareContext.isPrimitive(nonNullableType)) {
            return null;
        }
        KaClassSymbol classifier = $this$prepareContext.getExpandedSymbol(nonNullableType);
        if (classifier instanceof KaNamedClassSymbol && ((KaNamedClassSymbol)classifier).isInline()) {
            return null;
        }
        return Unit.INSTANCE;
    }
}

