/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.toolbar.floating.AbstractFloatingToolbarProvider;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.k2.ReloadScriptConfigurationKt;
import org.jetbrains.kotlin.idea.core.script.k2.ReloadScriptConfigurationService;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/ScriptConfigurationFloatingToolbarProvider;", "Lcom/intellij/openapi/editor/toolbar/floating/AbstractFloatingToolbarProvider;", "<init>", "()V", "autoHideable", "", "getAutoHideable", "()Z", "isApplicable", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "register", "", "component", "Lcom/intellij/openapi/editor/toolbar/floating/FloatingToolbarComponent;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.kotlin.base.scripting"})
@ApiStatus.Internal
public final class ScriptConfigurationFloatingToolbarProvider
extends AbstractFloatingToolbarProvider {
    private final boolean autoHideable;

    public ScriptConfigurationFloatingToolbarProvider() {
        super("KotlinScripts.ReloadConfigurationActionGroup");
    }

    public boolean getAutoHideable() {
        return this.autoHideable;
    }

    public boolean isApplicable(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        KtFile ktFile2 = ReloadScriptConfigurationKt.access$getProjectKtFile(dataContext);
        if (ktFile2 == null) {
            return false;
        }
        KtFile ktFile3 = ktFile2;
        String string = ktFile3.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null);
    }

    public void register(@NotNull DataContext dataContext, @NotNull FloatingToolbarComponent component, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ReloadScriptConfigurationService service2 = ReloadScriptConfigurationService.Companion.getInstance(project2);
        ApplicationKt.getApplication().getMessageBus().connect(parentDisposable).subscribe(ReloadScriptConfigurationService.TOPIC, (Object)new ReloadScriptConfigurationService.Listener(service2, component){
            final /* synthetic */ ReloadScriptConfigurationService $service;
            final /* synthetic */ FloatingToolbarComponent $component;
            {
                this.$service = $service;
                this.$component = $component;
            }

            public void onNotificationChanged(VirtualFile virtualFile) {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                this.$service.handleFloatingToolbarComponent(virtualFile, this.$component);
            }
        });
    }
}

