/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineDumpPanelKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIconKt;

@Deprecated(message="Coroutine dump will be shown in ThreadDumpPanel along with the regular Java thread dump, see IDEA-355724")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0005./012B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010 \u001a\u00020!H\u0002J%\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000bH\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0013j\b\u0012\u0004\u0012\u00020\u000b`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "dump", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/ui/ConsoleView;Lcom/intellij/openapi/actionSystem/DefaultActionGroup;Ljava/util/List;)V", "getDump", "()Ljava/util/List;", "exporterToTextFile", "Lcom/intellij/ide/ExporterToTextFile;", "mergedDump", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "filterField", "Lcom/intellij/ui/SearchTextField;", "getFilterField", "()Lcom/intellij/ui/SearchTextField;", "filterPanel", "getFilterPanel", "()Ljavax/swing/JPanel;", "coroutinesList", "Lcom/intellij/ui/components/JBList;", "", "kotlin.jvm.PlatformType", "updateCoroutinesList", "", "highlightOccurrences", "filter", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlightOccurrences$intellij_kotlin_jvm_debugger_coroutines", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "infoData", "CoroutineListCellRenderer", "FilterAction", "MergeStackTracesAction", "CopyToClipboardAction", "MyToFileExporter", "intellij.kotlin.jvm.debugger.coroutines"})
public final class CoroutineDumpPanel
extends JPanel
implements UiDataProvider {
    @NotNull
    private final List<CoroutineInfoData> dump;
    @NotNull
    private ExporterToTextFile exporterToTextFile;
    @NotNull
    private ArrayList<CoroutineInfoData> mergedDump;
    @NotNull
    private final SearchTextField filterField;
    @NotNull
    private final JPanel filterPanel;
    @NotNull
    private final JBList<Object> coroutinesList;

    public CoroutineDumpPanel(final @NotNull Project project, @NotNull ConsoleView consoleView, @NotNull DefaultActionGroup toolbarActions, @NotNull List<? extends CoroutineInfoData> dump) {
        block0: {
            JBList<Object> jBList;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
            Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
            Intrinsics.checkNotNullParameter(dump, (String)"dump");
            super(new BorderLayout());
            this.dump = dump;
            this.mergedDump = new ArrayList();
            this.filterField = new SearchTextField();
            this.filterPanel = new JPanel(new BorderLayout());
            this.coroutinesList = new JBList((ListModel)new DefaultListModel());
            this.mergedDump.addAll((Collection<CoroutineInfoData>)this.dump);
            this.filterField.addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(javax.swing.event.DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.updateCoroutinesList();
                }
            });
            JBList<Object> $this$_init__u24lambda_u240 = jBList = this.filterPanel;
            boolean bl = false;
            $this$_init__u24lambda_u240.add((Component)new JLabel(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.filter.field", new Object[0])), (Object)"West");
            $this$_init__u24lambda_u240.add((Component)this.filterField);
            $this$_init__u24lambda_u240.setVisible(false);
            jBList = this.coroutinesList;
            DefaultActionGroup $this$_init__u24lambda_u241 = jBList;
            boolean bl2 = false;
            $this$_init__u24lambda_u241.setCellRenderer((ListCellRenderer)((Object)new CoroutineListCellRenderer()));
            $this$_init__u24lambda_u241.setSelectionMode(0);
            $this$_init__u24lambda_u241.addListSelectionListener(arg_0 -> CoroutineDumpPanel.lambda$1$0($this$_init__u24lambda_u241, consoleView, arg_0));
            this.exporterToTextFile = new MyToFileExporter(project, this.dump);
            $this$_init__u24lambda_u241 = new FilterAction();
            Object $this$_init__u24lambda_u242 = $this$_init__u24lambda_u241;
            boolean bl3 = false;
            $this$_init__u24lambda_u242.registerCustomShortcutSet(ActionManager.getInstance().getAction("Find").getShortcutSet(), (JComponent)this.coroutinesList);
            Object filterAction = $this$_init__u24lambda_u241;
            DefaultActionGroup $this$_init__u24lambda_u243 = $this$_init__u24lambda_u241 = toolbarActions;
            boolean bl4 = false;
            $this$_init__u24lambda_u243.add((AnAction)filterAction);
            $this$_init__u24lambda_u243.add((AnAction)new CopyToClipboardAction(this.dump, project));
            $this$_init__u24lambda_u243.add(ActionManager.getInstance().getAction("ExportToTextFile"));
            $this$_init__u24lambda_u243.add((AnAction)new MergeStackTracesAction());
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("CoroutinesDump", (ActionGroup)toolbarActions, false);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            ActionToolbar toolbar = actionToolbar;
            toolbar.setTargetComponent((JComponent)this.coroutinesList);
            this.add((Component)toolbar.getComponent(), "West");
            JPanel $this$_init__u24lambda_u244 = bl4 = new JPanel(new BorderLayout());
            boolean bl5 = false;
            $this$_init__u24lambda_u244.add((Component)this.filterPanel, "North");
            $this$_init__u24lambda_u244.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.coroutinesList), (int)5), "Center");
            JPanel leftPanel = bl4;
            JPanel $this$_init__u24lambda_u245 = $this$_init__u24lambda_u244 = new Splitter(false, 0.3f);
            boolean bl6 = false;
            $this$_init__u24lambda_u245.setFirstComponent(leftPanel);
            $this$_init__u24lambda_u245.setSecondComponent(consoleView.getComponent());
            JPanel splitter = $this$_init__u24lambda_u244;
            this.add((Component)splitter, "Center");
            ListSpeedSearch.installOn((JList)((JList)this.coroutinesList)).setComparator(new SpeedSearchComparator(false, true));
            this.updateCoroutinesList();
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)consoleView.getPreferredFocusableComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getDocument()) == null) break block0;
            editor2.addDocumentListener(new DocumentListener(){

                public void documentChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String filter2 = this.getFilterField().getText();
                    if (StringUtil.isNotEmpty((String)filter2)) {
                        Intrinsics.checkNotNull((Object)filter2);
                        this.highlightOccurrences$intellij_kotlin_jvm_debugger_coroutines(filter2, project, editor);
                    }
                }
            }, (Disposable)consoleView);
        }
    }

    @NotNull
    public final List<CoroutineInfoData> getDump() {
        return this.dump;
    }

    @NotNull
    public final SearchTextField getFilterField() {
        return this.filterField;
    }

    @NotNull
    public final JPanel getFilterPanel() {
        return this.filterPanel;
    }

    private final void updateCoroutinesList() {
        String text = this.filterPanel.isVisible() ? this.filterField.getText() : "";
        Object selection = this.coroutinesList.getSelectedValue();
        ListModel listModel = this.coroutinesList.getModel();
        Intrinsics.checkNotNull((Object)listModel, (String)"null cannot be cast to non-null type javax.swing.DefaultListModel<kotlin.Any>");
        DefaultListModel model2 = (DefaultListModel)listModel;
        model2.clear();
        int selectedIndex = 0;
        int index2 = 0;
        List states = UISettings.Companion.getInstance().getState().getMergeEqualStackTraces() ? (List)this.mergedDump : this.dump;
        for (CoroutineInfoData state : states) {
            if (!StringUtil.containsIgnoreCase((String)CoroutineDumpPanelKt.access$stringStackTrace(state), (String)text) && !StringUtil.containsIgnoreCase((String)state.getName(), (String)text)) continue;
            model2.addElement(state);
            if (selection == state) {
                selectedIndex = index2;
            }
            ++index2;
        }
        if (!model2.isEmpty()) {
            this.coroutinesList.setSelectedIndex(selectedIndex);
        }
        this.coroutinesList.revalidate();
        this.coroutinesList.repaint();
    }

    public final void highlightOccurrences$intellij_kotlin_jvm_debugger_coroutines(@NotNull String filter2, @NotNull Project project, @NotNull Editor editor) {
        int nextOccurrence;
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String string = editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String documentText = string;
        int i2 = -1;
        while ((nextOccurrence = StringUtil.indexOfIgnoreCase((String)documentText, (String)filter2, (int)(i2 + 1))) >= 0) {
            i2 = nextOccurrence;
            highlightManager.addOccurrenceHighlight(editor, i2, i2 + filter2.length(), EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES, 4, null);
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.EXPORTER_TO_TEXT_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EXPORTER_TO_TEXT_FILE");
        sink.set(dataKey, (Object)this.exporterToTextFile);
    }

    private final SimpleTextAttributes getAttributes(CoroutineInfoData infoData) {
        SimpleTextAttributes simpleTextAttributes;
        if (infoData.isSuspended()) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAY_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAY_ATTRIBUTES");
        } else if (infoData.getContinuationStackFrames().isEmpty()) {
            simpleTextAttributes = new SimpleTextAttributes(0, Color.GRAY.brighter());
        } else {
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes3;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"REGULAR_ATTRIBUTES");
        }
        return simpleTextAttributes;
    }

    private static final void lambda$1$0(JBList $this_apply, ConsoleView $consoleView, ListSelectionEvent it) {
        int index2 = $this_apply.getSelectedIndex();
        if (index2 >= 0) {
            Object e = $this_apply.getModel().getElementAt(index2);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData");
            CoroutineInfoData selection = (CoroutineInfoData)e;
            AnalyzeStacktraceUtil.Companion.printStacktrace($consoleView, CoroutineDumpPanelKt.access$stringStackTrace(selection));
        } else {
            AnalyzeStacktraceUtil.Companion.printStacktrace($consoleView, "");
        }
        $this_apply.repaint();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$CopyToClipboardAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myCoroutinesDump", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "group", "Lcom/intellij/notification/NotificationGroup;", "intellij.kotlin.jvm.debugger.coroutines"})
    private static final class CopyToClipboardAction
    extends DumbAwareAction {
        @NotNull
        private final List<CoroutineInfoData> myCoroutinesDump;
        @NotNull
        private final Project myProject;
        @NotNull
        private final NotificationGroup group;

        public CopyToClipboardAction(@NotNull List<? extends CoroutineInfoData> myCoroutinesDump, @NotNull Project myProject) {
            Intrinsics.checkNotNullParameter(myCoroutinesDump, (String)"myCoroutinesDump");
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            super(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.copy.action", new Object[0]), KotlinDebuggerCoroutinesBundle.message("coroutine.dump.copy.description", new Object[0]), PlatformIcons.COPY_ICON);
            this.myCoroutinesDump = myCoroutinesDump;
            this.myProject = myProject;
            this.group = NotificationGroup.Companion.toolWindowGroup("Analyze coroutine dump", "Run", false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            StringBuilder buf = new StringBuilder();
            buf.append(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.full.title", new Object[0])).append("\n\n");
            for (CoroutineInfoData state : this.myCoroutinesDump) {
                buf.append(CoroutineDumpPanelKt.access$stringStackTrace(state)).append("\n\n");
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(buf.toString()));
            String string = KotlinDebuggerCoroutinesBundle.message("coroutine.dump.full.copied", new Object[0]);
            MessageType messageType = MessageType.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
            this.group.createNotification(string, messageType).notify(this.myProject);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J4\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$CoroutineListCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.kotlin.jvm.debugger.coroutines"})
    private final class CoroutineListCellRenderer
    extends ColoredListCellRenderer<Object> {
        protected void customizeCellRenderer(@NotNull JList<?> list2, @NotNull Object value, int index2, boolean selected, boolean hasFocus) {
            CoroutineInfoData infoData;
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CoroutineInfoData state = infoData = (CoroutineInfoData)value;
            this.setIcon(SimpleColoredTextIconKt.fromState(state.getState(), false));
            SimpleTextAttributes attrs = CoroutineDumpPanel.this.getAttributes(infoData);
            this.append(state.getName() + " (", attrs);
            Object detail = state.getState().name();
            if (detail == null) {
                detail = state.getState().name();
            }
            if (((String)detail).length() > 30) {
                String string = ((String)detail).substring(0, 30);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                detail = string + "...";
            }
            this.append((String)detail, attrs);
            this.append(")", attrs);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$FilterAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.kotlin.jvm.debugger.coroutines"})
    private final class FilterAction
    extends ToggleAction
    implements DumbAware {
        public FilterAction() {
            super(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.filter.action", new Object[0]), KotlinDebuggerCoroutinesBundle.message("coroutine.dump.filter.description", new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return CoroutineDumpPanel.this.getFilterPanel().isVisible();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CoroutineDumpPanel.this.getFilterPanel().setVisible(state);
            if (state) {
                IdeFocusManager.getInstance((Project)AnAction.getEventProject((AnActionEvent)e)).requestFocus((Component)CoroutineDumpPanel.this.getFilterField(), true);
                CoroutineDumpPanel.this.getFilterField().selectText();
            }
            CoroutineDumpPanel.this.updateCoroutinesList();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$MergeStackTracesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.kotlin.jvm.debugger.coroutines"})
    private final class MergeStackTracesAction
    extends ToggleAction
    implements DumbAware {
        public MergeStackTracesAction() {
            super(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.merge.action", new Object[0]), KotlinDebuggerCoroutinesBundle.message("coroutine.dump.merge.description", new Object[0]), AllIcons.Actions.Collapseall);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return UISettings.Companion.getInstance().getState().getMergeEqualStackTraces();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            UISettings.Companion.getInstance().getState().setMergeEqualStackTraces(state);
            CoroutineDumpPanel.this.updateCoroutinesList();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpPanel$MyToFileExporter;", "Lcom/intellij/ide/ExporterToTextFile;", "myProject", "Lcom/intellij/openapi/project/Project;", "infoData", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getReportText", "", "getDefaultFilePath", "canExport", "", "defaultReportFileName", "intellij.kotlin.jvm.debugger.coroutines"})
    private static final class MyToFileExporter
    implements ExporterToTextFile {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<CoroutineInfoData> infoData;
        @NotNull
        private final String defaultReportFileName;

        public MyToFileExporter(@NotNull Project myProject, @NotNull List<? extends CoroutineInfoData> infoData) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter(infoData, (String)"infoData");
            this.myProject = myProject;
            this.infoData = infoData;
            this.defaultReportFileName = "coroutines_report.txt";
        }

        @NotNull
        public String getReportText() {
            StringBuilder stringBuilder;
            StringBuilder $this$getReportText_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (CoroutineInfoData state : this.infoData) {
                $this$getReportText_u24lambda_u240.append(CoroutineDumpPanelKt.access$stringStackTrace(state)).append("\n\n");
            }
            return stringBuilder.toString();
        }

        @NotNull
        public String getDefaultFilePath() {
            String string = this.myProject.getBasePath();
            if (string == null) {
                string = "";
            }
            return string + File.separator + this.defaultReportFileName;
        }

        public boolean canExport() {
            return !((Collection)this.infoData).isEmpty();
        }
    }
}

