/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.LoopToCallChainIntention;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.LoopToLazyCallChainIntention;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchAndConvertKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchResult;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/LoopToCallChainInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Fix", "kotlin.idea"})
public final class LoopToCallChainInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return new KtVisitorVoid(holder2){
            private final LoopToCallChainIntention nonLazyIntention;
            private final LoopToLazyCallChainIntention lazyIntention;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                this.nonLazyIntention = new LoopToCallChainIntention();
                this.lazyIntention = new LoopToLazyCallChainIntention();
            }

            public final LoopToCallChainIntention getNonLazyIntention() {
                return this.nonLazyIntention;
            }

            public final LoopToLazyCallChainIntention getLazyIntention() {
                return this.lazyIntention;
            }

            public void visitForExpression(KtForExpression expression) {
                boolean lazyApplicable;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitForExpression(expression);
                boolean nonLazyApplicable = this.nonLazyIntention.applicabilityRange(expression) != null;
                boolean bl = lazyApplicable = this.lazyIntention.applicabilityRange(expression) != null;
                if (!nonLazyApplicable && !lazyApplicable) {
                    return;
                }
                List fixes = new ArrayList<E>();
                if (nonLazyApplicable) {
                    ((Collection)fixes).add(new Fix(false, this.nonLazyIntention.getText()));
                }
                if (lazyApplicable) {
                    ((Collection)fixes).add(new Fix(true, this.lazyIntention.getText()));
                }
                Collection $this$toTypedArray$iv = fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Fix[] fixArray = thisCollection$iv.toArray(new Fix[0]);
                this.$holder.registerProblem(expression.getForKeyword(), KotlinBundle.message((String)"loop.can.be.replaced.with.stdlib.operations", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(fixArray, fixArray.length));
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/LoopToCallChainInspection$Fix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "lazy", "", "text", "", "<init>", "(ZLjava/lang/String;)V", "getLazy", "()Z", "getText", "()Ljava/lang/String;", "getFamilyName", "getName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nLoopToCallChainInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoopToCallChainInspection.kt\norg/jetbrains/kotlin/idea/intentions/loopToCallChain/LoopToCallChainInspection$Fix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,139:1\n232#2:140\n*S KotlinDebug\n*F\n+ 1 LoopToCallChainInspection.kt\norg/jetbrains/kotlin/idea/intentions/loopToCallChain/LoopToCallChainInspection$Fix\n*L\n67#1:140\n*E\n"})
    public static final class Fix
    implements LocalQuickFix {
        private final boolean lazy;
        @NotNull
        private final String text;

        public Fix(boolean lazy, @Nls @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.lazy = lazy;
            this.text = text;
        }

        public /* synthetic */ Fix(boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "";
            }
            this(bl, string);
        }

        public final boolean getLazy() {
            return this.lazy;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public String getFamilyName() {
            return this.lazy ? KotlinBundle.message((String)"loop.to.call.fix.family.name2", (Object[])new Object[0]) : KotlinBundle.message((String)"loop.to.call.fix.family.name", (Object[])new Object[0]);
        }

        @NotNull
        public String getName() {
            return this.text;
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $this$getParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            PsiElement psiElement2 = psiElement;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtForExpression ktForExpression = (KtForExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtForExpression.class, (boolean)strict$iv);
            if (ktForExpression == null) {
                return;
            }
            KtForExpression expression = ktForExpression;
            Fix.applyFix$default(this, expression, null, 2, null);
        }

        public final void applyFix(@NotNull KtForExpression expression, @Nullable Editor editor) {
            block3: {
                int n;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                MatchResult matchResult = MatchAndConvertKt.match(expression, this.lazy, true);
                if (matchResult == null) {
                    return;
                }
                MatchResult match2 = matchResult;
                KtExpression result2 = MatchAndConvertKt.convertLoop(expression, match2);
                if (result2 instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)result2).getNameIdentifier();
                    n = psiElement != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement) : PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)result2));
                } else {
                    n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)result2));
                }
                int offset = n;
                Editor editor2 = editor;
                if (editor2 == null) break block3;
                GenerateUtilsKt.moveCaret$default(editor2, offset, null, 2, null);
            }
        }

        public static /* synthetic */ void applyFix$default(Fix fix3, KtForExpression ktForExpression, Editor editor, int n, Object object) {
            if ((n & 2) != 0) {
                editor = EditorUtilsKt.findExistingEditor((PsiElement)ktForExpression);
            }
            fix3.applyFix(ktForExpression, editor);
        }
    }
}

