/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.ui;

import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.ui.K2MoveTargetModel;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0016\u0010\u0003\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0016\u0010\u0007\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u000e\u0010\b\u001a\u00020\u0001*\u0004\u0018\u00010\u0006H\u0000\u001a(\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0016\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0016\u0010\u0012\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0016H\u0000\u00a8\u0006\u0017"}, d2={"isValidKotlinFile", "", "", "isMultiFileMove", "movedElements", "", "Lcom/intellij/psi/PsiElement;", "isSingleFileMove", "isSingleClassContainer", "isInSourceRoot", "project", "Lcom/intellij/openapi/project/Project;", "declarations", "targetContainer", "toFileElements", "Lcom/intellij/psi/PsiFileSystemItem;", "findSourceFileNameByMovedElements", "elementsToMove", "containNestedDeclarations", "findExplicitPkgMoveFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isMoveToExplicitPackage", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/ui/K2MoveTargetModel;", "intellij.kotlin.refactorings.move"})
@SourceDebugExtension(value={"SMAP\nmoveUiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 moveUiUtil.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/MoveUiUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1740#2,3:69\n1761#2,3:72\n1563#2:75\n1634#2,3:76\n1761#2,2:79\n1763#2:82\n1761#2,3:83\n1563#2:86\n1634#2,3:87\n1634#2,3:90\n67#3:81\n1#4:93\n*S KotlinDebug\n*F\n+ 1 moveUiUtil.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/ui/MoveUiUtilKt\n*L\n24#1:69,3\n35#1:72,3\n41#1:75\n41#1:76,3\n53#1:79,2\n53#1:82\n60#1:83,3\n61#1:86\n61#1:87,3\n62#1:90,3\n53#1:81\n*E\n"})
public final class MoveUiUtilKt {
    public static final boolean isValidKotlinFile(@NotNull String $this$isValidKotlinFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidKotlinFile, (String)"<this>");
        Object object = KotlinLanguage.INSTANCE.getAssociatedFileType();
        if (object == null || (object = object.getDefaultExtension()) == null) {
            return false;
        }
        return StringsKt.endsWith$default((String)$this$isValidKotlinFile, (String)object, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isValidKotlinFile, (String)".kts", (boolean)false, (int)2, null);
    }

    public static final boolean isMultiFileMove(@NotNull List<? extends PsiElement> movedElements) {
        Intrinsics.checkNotNullParameter(movedElements, (String)"movedElements");
        return CollectionsKt.toSet((Iterable)MoveUiUtilKt.toFileElements(movedElements)).size() > 1;
    }

    public static final boolean isSingleFileMove(@NotNull List<? extends PsiElement> movedElements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(movedElements, (String)"movedElements");
            Iterable $this$all$iv = movedElements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (it instanceof KtNamedDeclaration) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl || CollectionsKt.singleOrNull(movedElements) instanceof KtFile;
    }

    public static final boolean isSingleClassContainer(@Nullable PsiElement $this$isSingleClassContainer) {
        if (!($this$isSingleClassContainer instanceof KtClassOrObject)) {
            return false;
        }
        PsiElement psiElement = ((KtClassOrObject)$this$isSingleClassContainer).getParent();
        KtFile ktFile2 = psiElement instanceof KtFile ? (KtFile)psiElement : null;
        if (ktFile2 == null) {
            return false;
        }
        KtFile file = ktFile2;
        return Intrinsics.areEqual((Object)$this$isSingleClassContainer, (Object)CollectionsKt.singleOrNull((List)file.getDeclarations()));
    }

    public static final boolean isInSourceRoot(@NotNull Project project, @NotNull List<? extends PsiElement> declarations2, @Nullable PsiElement targetContainer) {
        boolean bl;
        ProjectFileIndex fileIndex;
        block6: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
            fileIndex = projectFileIndex;
            Iterable $this$any$iv = CollectionsKt.toSet((Iterable)MoveUiUtilKt.toFileElements(declarations2));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                    boolean bl2 = false;
                    if (!(!fileIndex.isInSourceContent(it.getVirtualFile()))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        if (targetContainer == null || targetContainer instanceof PsiDirectory) {
            return true;
        }
        PsiFile psiFile = targetContainer.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        PsiFile targetFile = psiFile;
        return fileIndex.isInSourceContent((VirtualFile)targetFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiFileSystemItem> toFileElements(@NotNull List<? extends PsiElement> $this$toFileElements) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toFileElements, (String)"<this>");
        Iterable $this$map$iv = $this$toFileElements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiDirectory psiDirectory = it instanceof PsiDirectory ? (PsiDirectory)it : null;
            collection.add(psiDirectory != null ? (PsiFileSystemItem)psiDirectory : (PsiFileSystemItem)it.getContainingFile());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String findSourceFileNameByMovedElements(@NotNull List<? extends PsiElement> elementsToMove) {
        Object object;
        KtElement firstElem;
        Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
        Object object2 = CollectionsKt.firstOrNull(elementsToMove);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        KtElement ktElement = firstElem = (KtElement)object2;
        if (ktElement instanceof KtFile) {
            String string = ((KtFile)firstElem).getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        } else if (ktElement instanceof KtNamedDeclaration) {
            LanguageFileType languageFileType = KotlinLanguage.INSTANCE.getAssociatedFileType();
            object = ((KtNamedDeclaration)firstElem).getName() + "." + (languageFileType != null ? languageFileType.getDefaultExtension() : null);
        } else {
            throw new IllegalStateException("Element to move should be a file or declaration".toString());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean containNestedDeclarations(@NotNull List<? extends PsiElement> elementsToMove) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
            Iterable $this$any$iv = elementsToMove;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    void $this$parentOfType$iv;
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    PsiElement psiElement = it;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType = false;
                    if (!(PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtNamedDeclaration.class, (boolean)true) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FqName findExplicitPkgMoveFqName(@NotNull List<? extends PsiElement> elementsToMove) {
        FqName samePackageFqName;
        FqName fqName2;
        void $this$mapTo$iv;
        KtFile it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        PsiFile implicitPackagePrefix;
        block11: {
            Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
            if (elementsToMove.isEmpty()) {
                return null;
            }
            PsiFile psiFile = ((PsiElement)CollectionsKt.first(elementsToMove)).getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getContainingDirectory()) == null || (psiFile = PackageUtilsKt.getImplicitPackagePrefix((PsiDirectory)psiFile)) == null) {
                return null;
            }
            implicitPackagePrefix = psiFile;
            if (implicitPackagePrefix.isRoot()) {
                return null;
            }
            Iterable $this$any$iv = elementsToMove;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    PsiElement it2 = (PsiElement)element$iv2;
                    boolean bl2 = false;
                    if (!(!(it2 instanceof KtFile) && !(it2 instanceof KtClassOrObject))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Iterable $this$map$iv = elementsToMove;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiElement psiElement = (PsiElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            KtElement ktElement = it instanceof KtElement ? (KtElement)it : null;
            if (ktElement == null || (ktElement = ktElement.getContainingKtFile()) == null) {
                return null;
            }
            collection.add(ktElement);
        }
        List ktFiles = (List)destination$iv$iv;
        $this$mapTo$iv$iv = ktFiles;
        Collection destination$iv = new LinkedHashSet();
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (KtFile)item$iv;
            collection = destination$iv;
            boolean bl4 = false;
            collection.add(it.getPackageFqName());
        }
        FqName fqName3 = (FqName)CollectionsKt.singleOrNull((Iterable)destination$iv);
        if (fqName3 == null) {
            return null;
        }
        FqName it3 = fqName2 = (samePackageFqName = fqName3);
        boolean bl5 = false;
        return Intrinsics.areEqual((Object)it3, (Object)implicitPackagePrefix) ? fqName2 : null;
    }

    public static final boolean isMoveToExplicitPackage(@NotNull K2MoveTargetModel $this$isMoveToExplicitPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$isMoveToExplicitPackage, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isMoveToExplicitPackage.getPkgName(), (Object)$this$isMoveToExplicitPackage.getExplicitPkgMoveFqName());
    }
}

