/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public final class CertificateCallbackCase
extends AuthCallbackCase {
    @NonNls
    private static final String CERTIFICATE_ERROR = "Error validating server certificate for";
    @NonNls
    private static final String UNTRUSTED_SERVER_CERTIFICATE = "Server SSL certificate untrusted";
    @NonNls
    private static final String CERTIFICATE_VERIFICATION_FAILED = "certificate verification failed";
    @NonNls
    private static final String CERTIFICATE_ISSUER_NOT_TRUSTED = "certificate verification failed: issuer is not trusted";
    private boolean accepted;

    CertificateCallbackCase(@NotNull AuthenticationService authenticationService, Url url) {
        if (authenticationService == null) {
            CertificateCallbackCase.$$$reportNull$$$0(0);
        }
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.startsWith(CERTIFICATE_ERROR) || error.contains(UNTRUSTED_SERVER_CERTIFICATE) || CertificateCallbackCase.isValidButUntrustedCertificate(error);
    }

    @Override
    public boolean getCredentials(String errText) throws SvnBindException {
        if (this.myAuthenticationService.acceptSSLServerCertificate(this.myUrl)) {
            this.accepted = true;
            return true;
        }
        throw new SvnBindException(SvnBundle.message("error.server.ssl.certificate.rejected", new Object[0]));
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        if (command == null) {
            CertificateCallbackCase.$$$reportNull$$$0(1);
        }
        if (this.accepted) {
            command.put("--trust-server-cert");
            command.put("--non-interactive");
        }
    }

    public static boolean isValidButUntrustedCertificate(@NotNull String error) {
        if (error == null) {
            CertificateCallbackCase.$$$reportNull$$$0(2);
        }
        return error.contains(CERTIFICATE_ISSUER_NOT_TRUSTED);
    }

    public static boolean isCertificateVerificationFailed(@NotNull String error) {
        if (error == null) {
            CertificateCallbackCase.$$$reportNull$$$0(3);
        }
        return error.contains(CERTIFICATE_VERIFICATION_FAILED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/commandLine/CertificateCallbackCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidButUntrustedCertificate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCertificateVerificationFailed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

