/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

class RepositoryLoader
extends Loader {
    @NotNull
    private final Queue<Pair<RepositoryTreeNode, Expander>> myLoadQueue;
    private boolean myQueueProcessorActive;

    RepositoryLoader(@NotNull SvnRepositoryCache cache) {
        if (cache == null) {
            RepositoryLoader.$$$reportNull$$$0(0);
        }
        super(cache);
        this.myLoadQueue = new LinkedList<Pair<RepositoryTreeNode, Expander>>();
        this.myQueueProcessorActive = false;
    }

    @Override
    public void load(@NotNull RepositoryTreeNode node, @NotNull Expander afterRefreshExpander) {
        if (node == null) {
            RepositoryLoader.$$$reportNull$$$0(1);
        }
        if (afterRefreshExpander == null) {
            RepositoryLoader.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Pair data = Pair.create((Object)node, (Object)afterRefreshExpander);
        if (!this.myQueueProcessorActive) {
            this.startLoadTask((Pair<RepositoryTreeNode, Expander>)data);
            this.myQueueProcessorActive = true;
        } else {
            this.myLoadQueue.offer((Pair<RepositoryTreeNode, Expander>)data);
        }
    }

    private void setResults(@NotNull Pair<RepositoryTreeNode, Expander> data, @NotNull List<DirectoryEntry> children) {
        if (data == null) {
            RepositoryLoader.$$$reportNull$$$0(3);
        }
        if (children == null) {
            RepositoryLoader.$$$reportNull$$$0(4);
        }
        this.myCache.put(((RepositoryTreeNode)data.first).getURL(), children);
        this.refreshNode((RepositoryTreeNode)data.first, children, (Expander)data.second);
    }

    private void setError(@NotNull Pair<RepositoryTreeNode, Expander> data, @NotNull VcsException error) {
        if (data == null) {
            RepositoryLoader.$$$reportNull$$$0(5);
        }
        if (error == null) {
            RepositoryLoader.$$$reportNull$$$0(6);
        }
        this.myCache.put(((RepositoryTreeNode)data.first).getURL(), error);
        this.refreshNodeError((RepositoryTreeNode)data.first, error);
    }

    private void startNext() {
        ThreadingAssertions.assertEventDispatchThread();
        Pair<RepositoryTreeNode, Expander> data = this.myLoadQueue.poll();
        if (data == null) {
            this.myQueueProcessorActive = false;
            return;
        }
        if (((RepositoryTreeNode)data.first).isDisposed()) {
            this.startNext();
        } else {
            this.startLoadTask(data);
        }
    }

    private void startLoadTask(@NotNull Pair<RepositoryTreeNode, Expander> data) {
        if (data == null) {
            RepositoryLoader.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)new LoadTask(data), (ProgressIndicator)new EmptyProgressIndicator());
    }

    @Override
    @NotNull
    protected NodeLoadState getNodeLoadState() {
        NodeLoadState nodeLoadState = NodeLoadState.REFRESHED;
        if (nodeLoadState == null) {
            RepositoryLoader.$$$reportNull$$$0(8);
        }
        return nodeLoadState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRefreshExpander";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLoadState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setResults";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startLoadTask";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private final class LoadTask
    extends Task.Backgroundable {
        @NotNull
        private final Pair<RepositoryTreeNode, Expander> myData;
        @NotNull
        private final List<DirectoryEntry> entries;
        @Nullable
        private VcsException error;

        private LoadTask(Pair<RepositoryTreeNode, Expander> data) {
            if (data == null) {
                LoadTask.$$$reportNull$$$0(0);
            }
            super(((RepositoryTreeNode)data.first).getVcs().getProject(), SvnBundle.message("progress.title.loading.child.entries", new Object[0]));
            this.entries = new ArrayList<DirectoryEntry>();
            this.myData = data;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                LoadTask.$$$reportNull$$$0(1);
            }
            RepositoryTreeNode node = (RepositoryTreeNode)this.myData.first;
            SvnVcs vcs = node.getVcs();
            Target target = Target.on(node.getURL());
            try {
                vcs.getFactoryFromSettings().createBrowseClient().list(target, Revision.HEAD, Depth.IMMEDIATES, this.entries::add);
            }
            catch (VcsException e) {
                this.error = e;
            }
        }

        public void onSuccess() {
            if (this.error != null) {
                RepositoryLoader.this.setError(this.myData, this.error);
            } else {
                RepositoryLoader.this.setResults(this.myData, ContainerUtil.sorted(this.entries, DirectoryEntry.CASE_INSENSITIVE_ORDER));
            }
            RepositoryLoader.this.startNext();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader$LoadTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

