/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.compilation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.ManifestBuilder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.maven.model.impl.MavenEjbClientConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenIdBean;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/project/compilation/ResourceConfigGenerator;", "", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "transformer", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;", "projectConfig", "Lorg/jetbrains/jps/maven/model/impl/MavenProjectConfiguration;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "<init>", "(Lcom/intellij/openapi/roots/ProjectFileIndex;Lorg/jetbrains/idea/maven/project/MavenProjectsManager;Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;Lorg/jetbrains/jps/maven/model/impl/MavenProjectConfiguration;Lorg/jetbrains/idea/maven/project/MavenProject;)V", "generateResourceConfig", "", "generate", "module", "Lcom/intellij/openapi/module/Module;", "moduleType", "Lorg/jetbrains/idea/maven/importing/StandardMavenModuleType;", "Companion", "intellij.maven"})
public final class ResourceConfigGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectFileIndex fileIndex;
    @NotNull
    private final MavenProjectsManager mavenProjectsManager;
    @NotNull
    private final RemotePathTransformerFactory.Transformer transformer;
    @NotNull
    private final MavenProjectConfiguration projectConfig;
    @NotNull
    private final MavenProject mavenProject;
    @NotNull
    private static final Logger LOG;
    @Nullable
    private static final String IDEA_MAVEN_DISABLE_MANIFEST;

    public ResourceConfigGenerator(@NotNull ProjectFileIndex fileIndex, @NotNull MavenProjectsManager mavenProjectsManager, @NotNull RemotePathTransformerFactory.Transformer transformer, @NotNull MavenProjectConfiguration projectConfig, @NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)fileIndex, (String)"fileIndex");
        Intrinsics.checkNotNullParameter((Object)mavenProjectsManager, (String)"mavenProjectsManager");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        Intrinsics.checkNotNullParameter((Object)projectConfig, (String)"projectConfig");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        this.fileIndex = fileIndex;
        this.mavenProjectsManager = mavenProjectsManager;
        this.transformer = transformer;
        this.projectConfig = projectConfig;
        this.mavenProject = mavenProject;
    }

    public final void generateResourceConfig() {
        if (Intrinsics.areEqual((Object)"pom", (Object)this.mavenProject.getPackaging())) {
            return;
        }
        VirtualFile pomXml = this.mavenProject.getFile();
        if (!Intrinsics.areEqual((Object)this.mavenProject.getDirectoryFile(), (Object)this.fileIndex.getContentRootForFile(pomXml))) {
            return;
        }
        Project project = this.mavenProjectsManager.getProject();
        Intrinsics.checkNotNull((Object)project);
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot();
        List<ModuleEntity> moduleEntities = MavenImportUtil.INSTANCE.getModuleEntities$intellij_maven(project, pomXml);
        for (ModuleEntity moduleEntity : moduleEntities) {
            ModuleBridge module;
            StandardMavenModuleType moduleType = MavenImportUtil.INSTANCE.getMavenModuleType(moduleEntity);
            if (moduleType == StandardMavenModuleType.COMPOUND_MODULE || (ModuleBridge)ModuleManagerBridgeImpl.Companion.getModuleMap((EntityStorage)storage).getDataByEntity((WorkspaceEntity)moduleEntity) == null) continue;
            this.generate((Module)module, moduleType);
        }
    }

    private final void generate(Module module, StandardMavenModuleType moduleType) {
        String overwrite;
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = string;
        MavenModuleResourceConfiguration resourceConfig = new MavenModuleResourceConfiguration();
        MavenId projectId = this.mavenProject.getMavenId();
        resourceConfig.id = new MavenIdBean(projectId.getGroupId(), projectId.getArtifactId(), projectId.getVersion());
        MavenId parentId = this.mavenProject.getParentId();
        if (parentId != null) {
            resourceConfig.parentId = new MavenIdBean(parentId.getGroupId(), parentId.getArtifactId(), parentId.getVersion());
        }
        String string2 = this.transformer.toRemotePathOrSelf(FileUtil.toSystemIndependentName((String)this.mavenProject.getDirectory()));
        Intrinsics.checkNotNull((Object)string2);
        resourceConfig.directory = string2;
        resourceConfig.delimitersPattern = MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(this.mavenProject).pattern();
        for (Map.Entry<String, String> entry : this.mavenProject.getModelMap().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            resourceConfig.modelMap.put(key, this.transformer.toRemotePathOrSelf(value));
        }
        Map map = resourceConfig.modelMap;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"modelMap");
        ResourceConfigGenerator.Companion.addEarModelMapEntries(this.mavenProject, map);
        Element pluginConfiguration = this.mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        resourceConfig.outputDirectory = this.transformer.toRemotePathOrSelf(ResourceConfigGenerator.Companion.getResourcesPluginGoalOutputDirectory(this.mavenProject, pluginConfiguration, "resources"));
        resourceConfig.testOutputDirectory = this.transformer.toRemotePathOrSelf(ResourceConfigGenerator.Companion.getResourcesPluginGoalOutputDirectory(this.mavenProject, pluginConfiguration, "testResources"));
        switch (WhenMappings.$EnumSwitchMapping$0[moduleType.ordinal()]) {
            case 1: {
                List list = resourceConfig.resources;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resources");
                ResourceConfigGenerator.Companion.addResources(this.transformer, list, this.mavenProject.getResources());
                List list2 = resourceConfig.testResources;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"testResources");
                ResourceConfigGenerator.Companion.addResources(this.transformer, list2, this.mavenProject.getTestResources());
                break;
            }
            case 2: {
                List list = resourceConfig.resources;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resources");
                ResourceConfigGenerator.Companion.addResources(this.transformer, list, this.mavenProject.getResources());
                break;
            }
            case 3: {
                List list = resourceConfig.testResources;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"testResources");
                ResourceConfigGenerator.Companion.addResources(this.transformer, list, this.mavenProject.getTestResources());
            }
        }
        ResourceConfigGenerator.Companion.addWebResources(this.transformer, moduleName, this.projectConfig, this.mavenProject);
        ResourceConfigGenerator.Companion.addEjbClientArtifactConfiguration(moduleName, this.projectConfig, this.mavenProject);
        resourceConfig.filteringExclusions.addAll(MavenProjectsTree.Companion.getFilterExclusions(this.mavenProject));
        Properties properties = ResourceConfigGenerator.Companion.getFilteringProperties(this.mavenProject, this.mavenProjectsManager);
        for (Object e : properties.entrySet()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Map.Entry propEntry = (Map.Entry)e;
            resourceConfig.properties.put((String)propEntry.getKey(), this.transformer.toRemotePathOrSelf((String)propEntry.getValue()));
        }
        resourceConfig.escapeString = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "escapeString", null);
        String escapeWindowsPaths = MavenJDOMUtil.findChildValueByPath$default(pluginConfiguration, "escapeWindowsPaths", null, 4, null);
        if (escapeWindowsPaths != null) {
            resourceConfig.escapeWindowsPaths = Boolean.parseBoolean(escapeWindowsPaths);
        }
        if ((overwrite = MavenJDOMUtil.findChildValueByPath$default(pluginConfiguration, "overwrite", null, 4, null)) != null) {
            resourceConfig.overwrite = Boolean.parseBoolean(overwrite);
        }
        this.projectConfig.moduleConfigurations.put(moduleName, resourceConfig);
        ResourceConfigGenerator.Companion.generateManifest(this.mavenProject, module, resourceConfig);
    }

    static {
        Logger logger = Logger.getInstance(ResourceConfigGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        IDEA_MAVEN_DISABLE_MANIFEST = System.getProperty("idea.maven.disable.manifest");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000eH\u0002J$\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J(\u0010%\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010)\u001a\u00020\n2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0+2\b\u0010,\u001a\u0004\u0018\u00010\b2\b\u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020\u0011H\u0002J\"\u0010/\u001a\u00020\n2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0+2\b\u00100\u001a\u0004\u0018\u00010\bH\u0002J \u00101\u001a\u00020\n2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/idea/maven/project/compilation/ResourceConfigGenerator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IDEA_MAVEN_DISABLE_MANIFEST", "", "addEarModelMapEntries", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "modelMap", "", "getResourcesPluginGoalOutputDirectory", "pluginConfiguration", "Lorg/jdom/Element;", "goal", "generateManifest", "module", "Lcom/intellij/openapi/module/Module;", "resourceConfig", "Lorg/jetbrains/jps/maven/model/impl/MavenModuleResourceConfiguration;", "getFilteringProperties", "Ljava/util/Properties;", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "addResources", "transformer", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;", "container", "", "Lorg/jetbrains/jps/maven/model/impl/ResourceRootConfiguration;", "resources", "", "Lorg/jetbrains/idea/maven/model/MavenResource;", "addWebResources", "moduleName", "projectCfg", "Lorg/jetbrains/jps/maven/model/impl/MavenProjectConfiguration;", "addConfigValues", "collection", "", "tag", "subTag", "resource", "addSplitAndTrimmed", "commaSeparatedList", "addEjbClientArtifactConfiguration", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nResourceConfigGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceConfigGenerator.kt\norg/jetbrains/idea/maven/project/compilation/ResourceConfigGenerator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,385:1\n1#2:386\n106#3:387\n78#3,22:388\n106#3:410\n78#3,22:411\n106#3:433\n78#3,22:434\n*S KotlinDebug\n*F\n+ 1 ResourceConfigGenerator.kt\norg/jetbrains/idea/maven/project/compilation/ResourceConfigGenerator$Companion\n*L\n242#1:387\n242#1:388,22\n246#1:410\n246#1:411,22\n341#1:433\n341#1:434,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void addEarModelMapEntries(MavenProject mavenProject, Map<String, String> modelMap) {
            Element pluginConfiguration = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-ear-plugin");
            String skinnyWars = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "skinnyWars", "false");
            modelMap.put("build.plugin.maven-ear-plugin.skinnyWars", skinnyWars);
        }

        private final String getResourcesPluginGoalOutputDirectory(MavenProject mavenProject, Element pluginConfiguration, String goal) {
            Element goalConfiguration = mavenProject.getPluginGoalConfiguration("org.apache.maven.plugins", "maven-resources-plugin", goal);
            String outputDirectory = MavenJDOMUtil.findChildValueByPath(goalConfiguration, "outputDirectory", null);
            if (outputDirectory == null) {
                outputDirectory = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "outputDirectory", null);
            }
            return outputDirectory == null || FileUtil.isAbsolute((String)outputDirectory) ? outputDirectory : mavenProject.getDirectory() + "/" + outputDirectory;
        }

        private final void generateManifest(MavenProject mavenProject, Module module, MavenModuleResourceConfiguration resourceConfig) {
            if (mavenProject.isAggregator()) {
                return;
            }
            if (Boolean.parseBoolean(IDEA_MAVEN_DISABLE_MANIFEST)) {
                resourceConfig.manifest = null;
                return;
            }
            try {
                String jdkVersion = null;
                Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (sdk != null) {
                    String string;
                    String it = string = sdk.getVersionString();
                    boolean bl = false;
                    jdkVersion = it;
                    if (string != null) {
                        String string2 = jdkVersion;
                        Intrinsics.checkNotNull((Object)string2);
                        int quoteIndex = StringsKt.indexOf$default((CharSequence)string2, (char)'\"', (int)0, (boolean)false, (int)6, null);
                        if (quoteIndex != -1) {
                            String string3 = jdkVersion.substring(quoteIndex + 1, jdkVersion.length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                            jdkVersion = string3;
                        }
                    }
                }
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(project, mavenProject.getFile());
                if (domModel != null) {
                    UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
                    new ManifestBuilder(mavenProject).withJdkVersion(jdkVersion).build().write((OutputStream)outputStream);
                    String resolvedText = MavenPropertyResolver.resolve(outputStream.toString(), domModel);
                    Base64.Encoder encoder = Base64.getEncoder();
                    Intrinsics.checkNotNull((Object)resolvedText);
                    String string = resolvedText;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    resourceConfig.manifest = encoder.encodeToString(byArray);
                }
                resourceConfig.classpath = ManifestBuilder.getClasspath(mavenProject);
            }
            catch (ManifestBuilder.ManifestBuilderException e) {
                LOG.warn("Unable to generate artifact manifest", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Unable to save generated artifact manifest", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Properties getFilteringProperties(MavenProject mavenProject, MavenProjectsManager mavenProjectsManager) {
            String javaVersion;
            Properties properties = new Properties();
            for (String each : mavenProject.getFilterPropertiesFiles()) {
                try {
                    Closeable closeable = new FileInputStream(each);
                    Throwable throwable = null;
                    try {
                        FileInputStream in = (FileInputStream)closeable;
                        boolean bl = false;
                        properties.load(in);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException iOException) {}
            }
            properties.putAll((Map<?, ?>)mavenProject.getProperties());
            properties.setProperty("settings.localRepository", ((Object)mavenProject.getLocalRepositoryPath().toAbsolutePath()).toString());
            String jreDir = MavenUtil.getModuleJreHome(mavenProjectsManager, mavenProject);
            if (jreDir != null) {
                properties.setProperty("java.home", jreDir);
            }
            if ((javaVersion = MavenUtil.getModuleJavaVersion(mavenProjectsManager, mavenProject)) != null) {
                properties.setProperty("java.version", javaVersion);
            }
            return properties;
        }

        private final void addResources(RemotePathTransformerFactory.Transformer transformer, List<ResourceRootConfiguration> container, Collection<? extends MavenResource> resources) {
            for (MavenResource mavenResource : resources) {
                boolean match$iv$iv;
                boolean bl;
                char it;
                int index$iv$iv;
                boolean startFound$iv$iv;
                int endIndex$iv$iv;
                int startIndex$iv$iv;
                boolean $i$f$trim;
                CharSequence $this$trim$iv$iv;
                String $this$trim$iv;
                Set set;
                String target;
                String dir;
                Intrinsics.checkNotNullExpressionValue((Object)mavenResource.getDirectory(), (String)"getDirectory(...)");
                ResourceRootConfiguration props = new ResourceRootConfiguration();
                Intrinsics.checkNotNull((Object)transformer.toRemotePathOrSelf(FileUtil.toSystemIndependentName((String)dir)));
                props.directory = props.directory;
                String string = target = transformer.toRemotePathOrSelf(mavenResource.getTargetPath());
                props.targetPath = string != null ? FileUtil.toSystemIndependentName((String)string) : null;
                props.isFiltered = mavenResource.isFiltered();
                props.includes.clear();
                for (String include : mavenResource.getIncludes()) {
                    Set set2 = props.includes;
                    Intrinsics.checkNotNull((Object)include);
                    String string2 = include;
                    set = set2;
                    boolean $i$f$trim2 = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    set.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                }
                props.excludes.clear();
                for (String exclude : mavenResource.getExcludes()) {
                    Set set3 = props.excludes;
                    Intrinsics.checkNotNull((Object)exclude);
                    $this$trim$iv = exclude;
                    set = set3;
                    boolean $i$f$trim2 = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        bl = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    set.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                }
                container.add(props);
            }
        }

        private final void addWebResources(RemotePathTransformerFactory.Transformer transformer, String moduleName, MavenProjectConfiguration projectCfg, MavenProject mavenProject) {
            Element warCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin");
            if (warCfg == null) {
                return;
            }
            boolean filterWebXml = Boolean.parseBoolean(warCfg.getChildTextTrim("filteringDeploymentDescriptors"));
            Element webResources = warCfg.getChild("webResources");
            String webArtifactName = MavenUtil.INSTANCE.getArtifactName("war", moduleName, true);
            MavenWebArtifactConfiguration artifactResourceCfg = (MavenWebArtifactConfiguration)projectCfg.webArtifactConfigs.get(webArtifactName);
            if (artifactResourceCfg == null) {
                artifactResourceCfg = new MavenWebArtifactConfiguration();
                artifactResourceCfg.moduleName = moduleName;
                projectCfg.webArtifactConfigs.put(webArtifactName, artifactResourceCfg);
            } else {
                LOG.error("MavenWebArtifactConfiguration already exists.");
            }
            List list = artifactResourceCfg.packagingIncludes;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packagingIncludes");
            this.addSplitAndTrimmed(list, warCfg.getChildTextTrim("packagingIncludes"));
            List list2 = artifactResourceCfg.packagingExcludes;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"packagingExcludes");
            this.addSplitAndTrimmed(list2, warCfg.getChildTextTrim("packagingExcludes"));
            Set set = artifactResourceCfg.nonFilteredFileExtensions;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"nonFilteredFileExtensions");
            this.addConfigValues(set, "nonFilteredFileExtensions", "nonFilteredFileExtension", warCfg);
            Object warSourceDirectory = warCfg.getChildTextTrim("warSourceDirectory");
            if (warSourceDirectory == null) {
                warSourceDirectory = "src/main/webapp";
            }
            if (!FileUtil.isAbsolute((String)warSourceDirectory)) {
                warSourceDirectory = mavenProject.getDirectory() + "/" + (String)warSourceDirectory;
            }
            artifactResourceCfg.warSourceDirectory = transformer.toRemotePathOrSelf(FileUtil.toSystemIndependentName((String)StringsKt.removeSuffix((String)warSourceDirectory, (CharSequence)"/")));
            List list3 = artifactResourceCfg.warSourceIncludes;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"warSourceIncludes");
            this.addSplitAndTrimmed(list3, warCfg.getChildTextTrim("warSourceIncludes"));
            List list4 = artifactResourceCfg.warSourceExcludes;
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"warSourceExcludes");
            this.addSplitAndTrimmed(list4, warCfg.getChildTextTrim("warSourceExcludes"));
            if (webResources != null) {
                for (Element resource : webResources.getChildren("resource")) {
                    ResourceRootConfiguration r = new ResourceRootConfiguration();
                    Object directory = resource.getChildTextTrim("directory");
                    CharSequence charSequence = (CharSequence)directory;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                    if (!FileUtil.isAbsolute((String)directory)) {
                        directory = mavenProject.getDirectory() + "/" + (String)directory;
                    }
                    Intrinsics.checkNotNull((Object)transformer.toRemotePathOrSelf((String)directory));
                    r.directory = r.directory;
                    r.isFiltered = Boolean.parseBoolean(resource.getChildTextTrim("filtering"));
                    r.targetPath = resource.getChildTextTrim("targetPath");
                    Set set2 = r.includes;
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"includes");
                    Collection collection = set2;
                    Intrinsics.checkNotNull((Object)resource);
                    this.addConfigValues(collection, "includes", "include", resource);
                    Set set3 = r.excludes;
                    Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"excludes");
                    this.addConfigValues(set3, "excludes", "exclude", resource);
                    artifactResourceCfg.webResources.add(r);
                }
            }
            if (filterWebXml) {
                ResourceRootConfiguration r = new ResourceRootConfiguration();
                String string = transformer.toRemotePathOrSelf((String)warSourceDirectory);
                Intrinsics.checkNotNull((Object)string);
                r.directory = string;
                Object[] objectArray = new String[]{"WEB-INF/web.xml"};
                r.includes = SetsKt.mutableSetOf((Object[])objectArray);
                r.isFiltered = true;
                r.targetPath = "";
                artifactResourceCfg.webResources.add(r);
            }
        }

        private final void addConfigValues(Collection<String> collection, String tag, String subTag, Element resource) {
            Element config = resource.getChild(tag);
            if (config != null) {
                for (Element value : config.getChildren(subTag)) {
                    String text = value.getTextTrim();
                    Intrinsics.checkNotNull((Object)text);
                    if (((CharSequence)text).length() == 0) continue;
                    collection.add(text);
                }
                if (config.getChildren(subTag).isEmpty()) {
                    this.addSplitAndTrimmed(collection, config.getTextTrim());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void addSplitAndTrimmed(Collection<String> collection, String commaSeparatedList) {
            if (commaSeparatedList != null) {
                for (String s : StringUtil.split((String)commaSeparatedList, (String)",")) {
                    void $this$trim$iv;
                    Intrinsics.checkNotNull((Object)s);
                    String string = s;
                    Collection<String> collection2 = collection;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    collection2.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                }
            }
        }

        private final void addEjbClientArtifactConfiguration(String moduleName, MavenProjectConfiguration projectCfg, MavenProject mavenProject) {
            Element excludes;
            Element pluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-ejb-plugin");
            if (pluginCfg == null || !Boolean.parseBoolean(pluginCfg.getChildTextTrim("generateClient"))) {
                return;
            }
            MavenEjbClientConfiguration ejbClientCfg = new MavenEjbClientConfiguration();
            Element includes = pluginCfg.getChild("clientIncludes");
            if (includes != null) {
                for (Element include : includes.getChildren("clientInclude")) {
                    String includeText = include.getTextTrim();
                    Intrinsics.checkNotNull((Object)includeText);
                    if (((CharSequence)includeText).length() == 0) continue;
                    ejbClientCfg.includes.add(includeText);
                }
            }
            if ((excludes = pluginCfg.getChild("clientExcludes")) != null) {
                for (Element exclude : excludes.getChildren("clientExclude")) {
                    String excludeText = exclude.getTextTrim();
                    Intrinsics.checkNotNull((Object)excludeText);
                    if (((CharSequence)excludeText).length() == 0) continue;
                    ejbClientCfg.excludes.add(excludeText);
                }
            }
            if (!ejbClientCfg.isEmpty()) {
                projectCfg.ejbClientArtifactConfigs.put(MavenUtil.INSTANCE.getEjbClientArtifactName(moduleName, true), ejbClientCfg);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StandardMavenModuleType.values().length];
            try {
                nArray[StandardMavenModuleType.SINGLE_MODULE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardMavenModuleType.MAIN_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardMavenModuleType.TEST_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

