/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import org.freeplane.core.ui.AntiAliasingConfigurator;
import org.freeplane.core.ui.components.DoubleTextIcon;
import org.freeplane.core.ui.components.TextIcon;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.features.bookmarks.mindmapmode.NodeNavigator;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.view.swing.map.outline.MapTreeNode;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.OutlineNodeDragGestureListener;
import org.freeplane.view.swing.map.outline.OutlineNodeDropTargetListener;
import org.freeplane.view.swing.map.outline.TreeNode;
import org.freeplane.view.swing.ui.NodeDropUtils;

class NodeButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final String COPY_ACTION_KEY = "outlineCopy";
    private static final String PASTE_ACTION_KEY = "outlinePaste";
    private static final int MENU_SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final KeyStroke COPY_KEY_STROKE = KeyStroke.getKeyStroke(67, MENU_SHORTCUT_MASK);
    private static final KeyStroke PASTE_KEY_STROKE = KeyStroke.getKeyStroke(86, MENU_SHORTCUT_MASK);
    private static final FocusListener repaint = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintParent(e.getComponent());
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintParent(e.getComponent());
        }

        private void repaintParent(Component component) {
            Container parent = component.getParent();
            if (parent != null) {
                parent.repaint(0, component.getY() - 3, parent.getWidth(), component.getHeight() + 6);
            }
        }
    };
    private static final ButtonUI nodeButtonUI = new BasicButtonUI(){

        @Override
        protected void installDefaults(AbstractButton b) {
            String pp = this.getPropertyPrefix();
            Font f = b.getFont();
            if (f == null || f instanceof UIResource) {
                String defaultFontName = pp + "font";
                b.setFont(UIManager.getFont(defaultFontName));
            }
            b.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            b.setOpaque(false);
            b.addFocusListener(repaint);
        }
    };
    private final TreeNode node;
    private boolean dropFeedbackVisible;
    private final boolean usesColoredOutlineItems;
    private final boolean showsFoldingStatus;

    NodeButton(TreeNode node, boolean usesColoredOutlineItems, ComponentOrientation componentOrientation) {
        this(node, usesColoredOutlineItems, true, 0, componentOrientation);
    }

    NodeButton(TreeNode node, boolean usesColoredOutlineItems, boolean showsFoldingStatus, int fontStyle, ComponentOrientation componentOrientation) {
        this.node = node;
        this.usesColoredOutlineItems = usesColoredOutlineItems;
        this.showsFoldingStatus = showsFoldingStatus;
        float itemFontSize = OutlineGeometry.getInstance().getItemFontSize();
        Font font = this.getFont().deriveFont(fontStyle, itemFontSize);
        this.setFont(font);
        this.setHorizontalAlignment(10);
        this.updateLabel();
        this.installNodePopupMenu();
        this.installDragAndDrop();
        this.installClipboardActions();
        this.setComponentOrientation(componentOrientation);
    }

    @Override
    public void updateUI() {
        this.setUI(nodeButtonUI);
    }

    TreeNode getNode() {
        return this.node;
    }

    NodeModel getNodeModel() {
        if (this.node instanceof MapTreeNode) {
            return ((MapTreeNode)this.node).getNodeModel();
        }
        return null;
    }

    private void installNodePopupMenu() {
        if (!(this.node instanceof MapTreeNode)) {
            return;
        }
        MapTreeNode mapTreeNode = (MapTreeNode)this.node;
        NodeModel nodeModel = mapTreeNode.getNodeModel();
        if (nodeModel == null) {
            return;
        }
        NodeNavigator nodeNavigator = new NodeNavigator(nodeModel);
        JPopupMenu popupMenu = new JPopupMenu();
        this.addGotoNodeMenuItem(popupMenu, nodeNavigator);
        this.addOpenAsRootDirectMenuItem(popupMenu, nodeNavigator);
        this.addOpenAsNewViewRootMenuItem(popupMenu, nodeNavigator);
        popupMenu.addSeparator();
        this.addCopyMenuItem(popupMenu);
        this.addPasteMenuItem(popupMenu);
        this.setComponentPopupMenu(popupMenu);
    }

    private void addGotoNodeMenuItem(JPopupMenu popupMenu, NodeNavigator nodeNavigator) {
        JMenuItem menuItem = TranslatedElementFactory.createMenuItem("bookmark.goto_node");
        menuItem.addActionListener(actionEvent -> nodeNavigator.open(false));
        popupMenu.add(menuItem);
    }

    private void addOpenAsRootDirectMenuItem(JPopupMenu popupMenu, NodeNavigator nodeNavigator) {
        JMenuItem menuItem = TranslatedElementFactory.createMenuItem("bookmark.open_as_root");
        menuItem.addActionListener(actionEvent -> nodeNavigator.open(true));
        popupMenu.add(menuItem);
    }

    private void addOpenAsNewViewRootMenuItem(JPopupMenu popupMenu, NodeNavigator nodeNavigator) {
        JMenuItem menuItem = TranslatedElementFactory.createMenuItem("bookmark.open_as_new_view_root");
        menuItem.addActionListener(actionEvent -> nodeNavigator.openAsNewView());
        popupMenu.add(menuItem);
    }

    private void addCopyMenuItem(JPopupMenu popupMenu) {
        JMenuItem copyMenuItem = TranslatedElementFactory.createMenuItem("menu_copy");
        copyMenuItem.addActionListener(actionEvent -> this.performCopyAction());
        popupMenu.add(copyMenuItem);
    }

    private void addPasteMenuItem(JPopupMenu popupMenu) {
        JMenuItem pasteMenuItem = TranslatedElementFactory.createMenuItem("simplyhtml.pasteLabel");
        pasteMenuItem.addActionListener(actionEvent -> this.performPasteAction());
        popupMenu.add(pasteMenuItem);
    }

    private void installDragAndDrop() {
        if (!(this.node instanceof MapTreeNode)) {
            return;
        }
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 0x40000003, new OutlineNodeDragGestureListener(this));
        DropTarget dropTarget = new DropTarget(this, 0x40000003, new OutlineNodeDropTargetListener());
    }

    void showDropFeedback() {
        if (!this.dropFeedbackVisible) {
            this.dropFeedbackVisible = true;
            this.repaint();
        }
    }

    void clearDropFeedback() {
        if (this.dropFeedbackVisible) {
            this.dropFeedbackVisible = false;
            this.repaint();
        }
    }

    private void installClipboardActions() {
        if (!(this.node instanceof MapTreeNode)) {
            return;
        }
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeButton.this.performCopyAction();
            }
        };
        AbstractAction pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeButton.this.performPasteAction();
            }
        };
        this.getInputMap(0).put(COPY_KEY_STROKE, COPY_ACTION_KEY);
        this.getActionMap().put(COPY_ACTION_KEY, copyAction);
        this.getInputMap(0).put(PASTE_KEY_STROKE, PASTE_ACTION_KEY);
        this.getActionMap().put(PASTE_ACTION_KEY, pasteAction);
    }

    private void performCopyAction() {
        NodeModel nodeModel = this.getNodeModel();
        if (nodeModel == null) {
            return;
        }
        MapClipboardController clipboardController = MapClipboardController.getController();
        MindMapNodesSelection selection = clipboardController.copy(Collections.singletonList(nodeModel), MapClipboardController.CopiedNodeSet.ALL_NODES, MapClipboardController.CopiedNodeSet.ALL_NODES);
        if (selection == null) {
            return;
        }
        selection.setDropAction(1);
        selection.setNodeObjects(Collections.singletonList(nodeModel), false);
        clipboardController.setClipboardContents(selection);
    }

    private void performPasteAction() {
        NodeModel nodeModel = this.getNodeModel();
        if (nodeModel == null) {
            return;
        }
        MapClipboardController clipboardController = MapClipboardController.getController();
        if (!(clipboardController instanceof MMapClipboardController)) {
            return;
        }
        MMapClipboardController mapClipboardController = (MMapClipboardController)clipboardController;
        Transferable clipboardContents = mapClipboardController.getClipboardContents();
        if (clipboardContents == null) {
            return;
        }
        int dropAction = NodeDropUtils.getDropAction(clipboardContents, 1);
        mapClipboardController.paste(clipboardContents, nodeModel, NodeModel.Side.DEFAULT, dropAction);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Icon icon = this.getIcon();
        if (icon != null) {
            Graphics2D g2 = (Graphics2D)graphics.create();
            AntiAliasingConfigurator.setAntialiasing(g2);
            if (!this.usesColoredOutlineItems && icon instanceof TextIcon) {
                TextIcon textIcon = (TextIcon)icon;
                Color foreground = this.getForeground();
                textIcon.setIconTextColor(foreground);
                if (textIcon.getBorderStroke() != null) {
                    textIcon.setIconBorderColor(foreground);
                }
            }
            super.paintComponent(g2);
            g2.dispose();
        } else {
            super.paintComponent(graphics);
        }
        if (this.dropFeedbackVisible) {
            this.paintDropFeedback(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDropFeedback(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.setColor(this.getForeground());
            graphics2D.setStroke(new BasicStroke(2.0f));
            int height = this.getHeight() - 4;
            int y = 2;
            graphics2D.drawLine(2, y, 2, y + height);
            graphics2D.drawLine(this.getWidth() - 3, y, this.getWidth() - 3, y + height);
        }
        finally {
            graphics2D.dispose();
        }
    }

    void updateLabel() {
        if (this.node instanceof MapTreeNode) {
            this.setIcon(((MapTreeNode)this.node).createIcon(this, this.usesColoredOutlineItems, this.showsFoldingStatus));
        } else {
            String buttonText = this.node.getTitle();
            this.setText(buttonText);
        }
    }

    boolean isFirstIconClick(MouseEvent event) {
        if (event == null || event.getSource() != this) {
            return false;
        }
        Icon icon = this.getIcon();
        if (!(icon instanceof DoubleTextIcon)) {
            return false;
        }
        Rectangle iconArea = this.calculateIconRect(icon);
        if (iconArea == null || !iconArea.contains(event.getX(), event.getY())) {
            return false;
        }
        int relativeX = event.getX() - iconArea.x;
        int rightIconX = ((DoubleTextIcon)icon).getRightIconX(this);
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        if (componentOrientation.isHorizontal() && !componentOrientation.isLeftToRight()) {
            return relativeX > rightIconX;
        }
        return relativeX < rightIconX;
    }

    private Rectangle calculateIconRect(Icon icon) {
        if (icon == null) {
            return null;
        }
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle viewRect = new Rectangle();
        Insets insets = this.getInsets();
        viewRect.x = insets.left;
        viewRect.y = insets.top;
        viewRect.width = this.getWidth() - (insets.left + insets.right);
        viewRect.height = this.getHeight() - (insets.top + insets.bottom);
        SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getIconTextGap());
        return iconRect.width > 0 ? iconRect : null;
    }
}

