/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freeplane.view.swing.map.outline.TreeNode;

final class OutlineSelectionHistory {
    private final Map<String, String> lastSelectedChildByParent = new HashMap<String, String>();

    OutlineSelectionHistory() {
    }

    void record(TreeNode node) {
        if (node == null) {
            return;
        }
        TreeNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        this.lastSelectedChildByParent.put(parent.getId(), node.getId());
    }

    TreeNode preferredChild(TreeNode parent) {
        if (parent == null) {
            return null;
        }
        List<TreeNode> children = parent.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        String preferredChildId = this.lastSelectedChildByParent.get(parent.getId());
        if (preferredChildId != null) {
            for (TreeNode child : children) {
                if (!preferredChildId.equals(child.getId())) continue;
                return child;
            }
        }
        return children.get(0);
    }
}

