/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Iterator;
import java.util.Set;

class GridShorthandBuilder
extends ShorthandBuilder {
    GridShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("grid", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 3;
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        BaseCSSStyleDeclaration style = this.getParentStyle();
        if (!(style.isPropertySet("grid-template-rows") && style.isPropertySet("grid-template-columns") && style.isPropertySet("grid-template-areas"))) {
            return 1;
        }
        if (style.isPropertySet("grid-auto-rows") && style.isPropertySet("grid-auto-columns") && style.isPropertySet("grid-auto-flow")) {
            return new FullGridShorthandBuilder(style).appendShorthandSet(buf, declaredSet, important);
        }
        return new GridTemplateShorthandBuilder(style).appendShorthandSet(buf, declaredSet, important);
    }

    @Override
    protected boolean isNotInitialValue(StyleValue cssVal, String propertyName) {
        return cssVal != null && !this.isEffectiveInitialKeyword(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, StyleValue cssVal) {
        buf.append(cssVal.getMinifiedCssText(this.getShorthandName()));
    }

    private boolean isIdentifier(StyleValue cssVal) {
        return cssVal.getPrimitiveType() == CSSValue.Type.IDENT;
    }

    private boolean isIdentifier(StyleValue cssVal, String ident) {
        return this.isIdentifier(cssVal) && ident.equalsIgnoreCase(((CSSTypedValue)((Object)cssVal)).getStringValue());
    }

    private class FullGridShorthandBuilder
    extends GridShorthandBuilder {
        FullGridShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
            super(parentStyle);
        }

        @Override
        int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
            String[] subp;
            buf.append(this.getShorthandName()).append(':');
            byte check = this.checkValuesForInherit(declaredSet);
            if (check == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                return 0;
            }
            if (check == 2) {
                return 1;
            }
            check = this.checkValuesForType(CSSValue.Type.REVERT, declaredSet);
            if (check == 1) {
                buf.append("revert");
                this.appendPriority(buf, important);
                return 0;
            }
            if (check == 2) {
                return 1;
            }
            if (this.checkValuesForType(CSSValue.Type.INTERNAL, declaredSet) != 0) {
                return 1;
            }
            for (String property : subp = this.getLonghandProperties()) {
                StyleValue cssVal = this.getCSSValue(property);
                if (cssVal.getCssValueType() != CSSValue.CssType.LIST || !((ValueList)cssVal).isCommaSeparated()) continue;
                return 1;
            }
            GridValues values = new GridValues(declaredSet);
            if (values.isNoneValue()) {
                buf.append("none");
                this.appendPriority(buf, important);
                return 0;
            }
            if (values.defaultGridTAreas) {
                if (!values.rowAFlow && values.defaultGridARows && values.defaultGridTColumns) {
                    if (values.gridColumnAutoFlowSyntax(buf, declaredSet)) {
                        this.appendPriority(buf, important);
                        return 0;
                    }
                } else if (values.rowAFlow && values.defaultGridAColumns && values.defaultGridTRows && (!values.defaultGridARows || values.isAutoflowDense()) && values.gridRowAutoFlowSyntax(buf, declaredSet)) {
                    this.appendPriority(buf, important);
                    return 0;
                }
            } else if (!values.defaultGridTAreas && values.lacksRepeatInGridTRows && values.gridAreasSyntax(buf, declaredSet)) {
                this.appendPriority(buf, important);
                return 0;
            }
            values.gridRowsColumnsSyntax(buf, declaredSet, important);
            return 0;
        }
    }

    private class GridTemplateShorthandBuilder
    extends GridShorthandBuilder {
        GridTemplateShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
            super(parentStyle);
        }

        @Override
        int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
            String[] subp;
            if (!(declaredSet.contains("grid-template-areas") || declaredSet.contains("grid-template-rows") || declaredSet.contains("grid-template-columns"))) {
                this.appendLeftoverProperties(buf, declaredSet, important);
                return 0;
            }
            buf.append(this.getShorthandName()).append(':');
            byte check = this.checkValuesForInherit(declaredSet);
            if (check == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                this.appendLeftoverProperties(buf, declaredSet, important);
                return 0;
            }
            if (check == 2) {
                return 1;
            }
            check = this.checkValuesForType(CSSValue.Type.REVERT, declaredSet);
            if (check == 1) {
                buf.append("revert");
                this.appendPriority(buf, important);
                this.appendLeftoverProperties(buf, declaredSet, important);
                return 0;
            }
            if (check == 2) {
                return 1;
            }
            if (this.checkValuesForType(CSSValue.Type.INTERNAL, declaredSet) != 0) {
                return 1;
            }
            for (String property : subp = this.getLonghandProperties()) {
                StyleValue cssVal = this.getCSSValue(property);
                if (cssVal.getCssValueType() != CSSValue.CssType.LIST || !((ValueList)cssVal).isCommaSeparated()) continue;
                return 1;
            }
            GridTemplateValues values = new GridTemplateValues(declaredSet);
            if (values.isNoneValue()) {
                buf.append("none");
                this.appendPriority(buf, important);
                this.appendLeftoverProperties(buf, declaredSet, important);
                return 0;
            }
            if (!values.defaultGridTAreas && values.lacksRepeatInGridTRows && values.gridAreasSyntax(buf, declaredSet)) {
                this.appendPriority(buf, important);
                this.appendLeftoverProperties(buf, declaredSet, important);
                return 0;
            }
            values.gridRowsColumnsSyntax(buf, declaredSet, important);
            this.appendLeftoverProperties(buf, declaredSet, important);
            return 0;
        }

        private void appendLeftoverProperties(StringBuilder buf, Set<String> declaredSet, boolean important) {
            if (declaredSet.contains("grid-auto-rows")) {
                this.appendIndividualProperty(buf, "grid-auto-rows", important);
            }
            if (declaredSet.contains("grid-auto-columns")) {
                this.appendIndividualProperty(buf, "grid-auto-columns", important);
            }
            if (declaredSet.contains("grid-auto-flow")) {
                this.appendIndividualProperty(buf, "grid-auto-flow", important);
            }
        }

        private void appendIndividualProperty(StringBuilder buf, String property, boolean important) {
            BufferSimpleWriter wri = new BufferSimpleWriter(buf);
            DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
            StyleValue value = this.getCSSValue(property);
            buf.append(property).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(wri, context, value, property);
            this.appendPriority(buf, important);
        }

        @Override
        String getShorthandName() {
            return "grid-template";
        }

        @Override
        protected int getTotalSetSize() {
            return 3;
        }
    }

    private class GridValues
    extends GridTemplateValues {
        final StyleValue cssGridARows;
        final StyleValue cssGridAColumns;
        final StyleValue cssGridAFlow;
        final boolean defaultGridARows;
        final boolean defaultGridAColumns;
        final boolean defaultGridAFlow;
        final boolean rowAFlow;

        GridValues(Set<String> declaredSet) {
            super(declaredSet);
            this.cssGridARows = GridShorthandBuilder.this.getCSSValue("grid-auto-rows");
            this.cssGridAColumns = GridShorthandBuilder.this.getCSSValue("grid-auto-columns");
            this.cssGridAFlow = GridShorthandBuilder.this.getCSSValue("grid-auto-flow");
            this.defaultGridARows = GridShorthandBuilder.this.isIdentifier(this.cssGridARows, "auto") || !declaredSet.contains("grid-auto-rows") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridARows);
            this.defaultGridAColumns = GridShorthandBuilder.this.isIdentifier(this.cssGridAColumns, "auto") || !declaredSet.contains("grid-auto-columns") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridAColumns);
            this.defaultGridAFlow = GridShorthandBuilder.this.isIdentifier(this.cssGridAFlow, "row") || !declaredSet.contains("grid-auto-flow") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridAFlow);
            this.rowAFlow = this.isRowAutoflow();
        }

        @Override
        void gridRowsColumnsSyntax(StringBuilder buf, Set<String> declaredSet, boolean important) {
            super.gridRowsColumnsSyntax(buf, declaredSet, important);
            if (!this.defaultGridARows) {
                buf.append("grid-auto-rows:");
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridARows);
                GridShorthandBuilder.this.appendPriority(buf, important);
            }
            if (!this.defaultGridAColumns) {
                buf.append("grid-auto-columns:");
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridAColumns);
                GridShorthandBuilder.this.appendPriority(buf, important);
            }
            if (!this.defaultGridAFlow) {
                buf.append("grid-auto-flow:");
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridAFlow);
                GridShorthandBuilder.this.appendPriority(buf, important);
            }
        }

        private boolean gridRowAutoFlowSyntax(StringBuilder buf, Set<String> declaredSet) {
            if (!this.isAutoflowDense()) {
                buf.append("auto-flow ");
            } else {
                buf.append("auto-flow dense ");
            }
            GridShorthandBuilder.this.appendValueText(buf, this.cssGridARows);
            if (!this.defaultGridTColumns) {
                buf.append('/');
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTColumns);
            }
            return true;
        }

        private boolean gridColumnAutoFlowSyntax(StringBuilder buf, Set<String> declaredSet) {
            GridShorthandBuilder.this.appendValueText(buf, this.cssGridTRows);
            if (!this.defaultGridAColumns) {
                buf.append('/');
                if (!this.isAutoflowDense()) {
                    buf.append("auto-flow ");
                } else {
                    buf.append("auto-flow dense ");
                }
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridAColumns);
            }
            return true;
        }

        @Override
        boolean isNoneValue() {
            return this.defaultGridTAreas && this.defaultGridTRows && this.defaultGridTColumns && this.defaultGridARows && this.defaultGridAColumns && this.defaultGridAFlow;
        }

        private boolean isRowAutoflow() {
            if (this.cssGridAFlow.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList list = (ValueList)this.cssGridAFlow;
                if (list.getLength() == 2) {
                    return "row".equalsIgnoreCase(list.item(0).getCssText()) || "row".equalsIgnoreCase(list.item(1).getCssText());
                }
            } else {
                return "row".equalsIgnoreCase(this.cssGridAFlow.getCssText());
            }
            return false;
        }

        private boolean isAutoflowDense() {
            ValueList list;
            if (this.cssGridAFlow.getCssValueType() == CSSValue.CssType.LIST && (list = (ValueList)this.cssGridAFlow).getLength() == 2) {
                return "dense".equalsIgnoreCase(list.item(1).getCssText()) || "dense".equalsIgnoreCase(list.item(0).getCssText());
            }
            return false;
        }
    }

    private class GridTemplateValues {
        final StyleValue cssGridTAreas;
        final StyleValue cssGridTRows;
        final StyleValue cssGridTColumns;
        final boolean defaultGridTAreas;
        final boolean defaultGridTRows;
        final boolean defaultGridTColumns;
        boolean lacksRepeatInGridTRows;

        GridTemplateValues(Set<String> declaredSet) {
            this.cssGridTAreas = GridShorthandBuilder.this.getCSSValue("grid-template-areas");
            this.cssGridTRows = GridShorthandBuilder.this.getCSSValue("grid-template-rows");
            this.cssGridTColumns = GridShorthandBuilder.this.getCSSValue("grid-template-columns");
            this.defaultGridTAreas = GridShorthandBuilder.this.isIdentifier(this.cssGridTAreas, "none") || !declaredSet.contains("grid-template-areas") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridTAreas);
            this.defaultGridTRows = GridShorthandBuilder.this.isIdentifier(this.cssGridTRows, "none") || !declaredSet.contains("grid-template-rows") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridTRows);
            this.defaultGridTColumns = GridShorthandBuilder.this.isIdentifier(this.cssGridTColumns, "none") || !declaredSet.contains("grid-template-columns") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridTColumns);
            this.lacksRepeatInGridTRows = this.lacksRepeatFunction(this.cssGridTRows);
        }

        private boolean lacksRepeatFunction(StyleValue value) {
            if (value.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList list = (ValueList)value;
                for (StyleValue item : list) {
                    if (this.lacksRepeatFunction(item)) continue;
                    return false;
                }
            } else if (value.getCssValueType() == CSSValue.CssType.TYPED) {
                CSSTypedValue primi = (CSSTypedValue)((Object)value);
                return primi.getPrimitiveType() != CSSValue.Type.FUNCTION || !"repeat".equalsIgnoreCase(primi.getStringValue());
            }
            return true;
        }

        boolean gridAreasSyntax(StringBuilder buf, Set<String> declaredSet) {
            int lm1;
            if (GridShorthandBuilder.this.isIdentifier(this.cssGridTRows, "auto") || !declaredSet.contains("grid-template-rows")) {
                StyleValue areavalue = this.getGridTemplateAreaItem(0);
                GridShorthandBuilder.this.appendValueText(buf, areavalue);
                int idx = 1;
                while ((areavalue = this.getGridTemplateAreaItem(idx)) != null) {
                    buf.append(' ');
                    GridShorthandBuilder.this.appendValueText(buf, areavalue);
                    ++idx;
                }
            } else if (this.cssGridTRows.getCssValueType() == CSSValue.CssType.LIST) {
                if (!((ValueList)this.cssGridTRows).isBracketList()) {
                    int rowlistIdx = 0;
                    ValueList rowsslist = (ValueList)this.cssGridTRows;
                    Iterator<StyleValue> it = rowsslist.iterator();
                    boolean bracketLast = false;
                    while (it.hasNext()) {
                        ValueList bracketlist;
                        StyleValue value = it.next();
                        if (value.getCssValueType() == CSSValue.CssType.LIST && (bracketlist = (ValueList)value).isBracketList()) {
                            int sz = bracketlist.getLength();
                            if (sz < 2) {
                                GridShorthandBuilder.this.appendValueText(buf, value);
                            } else if (sz == 2) {
                                buf.append('[');
                                GridShorthandBuilder.this.appendValueText(buf, bracketlist.item(0));
                                buf.append("] [");
                                GridShorthandBuilder.this.appendValueText(buf, bracketlist.item(1));
                                buf.append(']');
                            } else {
                                return false;
                            }
                            StyleValue areavalue = this.getGridTemplateAreaItem(rowlistIdx);
                            if (areavalue != null) {
                                buf.append(' ');
                                GridShorthandBuilder.this.appendValueText(buf, areavalue);
                                buf.append(' ');
                                ++rowlistIdx;
                                bracketLast = true;
                                continue;
                            }
                            if (!it.hasNext()) continue;
                            return false;
                        }
                        StyleValue areavalue = this.getGridTemplateAreaItem(rowlistIdx);
                        if (areavalue != null && !bracketLast) {
                            GridShorthandBuilder.this.appendValueText(buf, areavalue);
                            buf.append(' ');
                            ++rowlistIdx;
                        }
                        if (!GridShorthandBuilder.this.isIdentifier(value) || !"auto".equalsIgnoreCase(value.getCssText())) {
                            GridShorthandBuilder.this.appendValueText(buf, value);
                            buf.append(' ');
                        }
                        bracketLast = false;
                    }
                } else {
                    StyleValue areavalue;
                    GridShorthandBuilder.this.appendValueText(buf, this.cssGridTRows);
                    int idx = 0;
                    while ((areavalue = this.getGridTemplateAreaItem(idx)) != null) {
                        buf.append(' ');
                        GridShorthandBuilder.this.appendValueText(buf, areavalue);
                        buf.append(' ');
                        ++idx;
                    }
                }
            } else {
                StyleValue areavalue = this.getGridTemplateAreaItem(0);
                GridShorthandBuilder.this.appendValueText(buf, areavalue);
                buf.append(' ');
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTRows);
                int idx = 1;
                while ((areavalue = this.getGridTemplateAreaItem(idx)) != null) {
                    buf.append(' ');
                    GridShorthandBuilder.this.appendValueText(buf, areavalue);
                    buf.append(' ');
                    ++idx;
                }
            }
            if (buf.charAt(lm1 = buf.length() - 1) == ' ') {
                buf.setLength(lm1);
            }
            if (!this.defaultGridTColumns) {
                buf.append('/');
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTColumns);
            }
            return true;
        }

        void gridRowsColumnsSyntax(StringBuilder buf, Set<String> declaredSet, boolean important) {
            GridShorthandBuilder.this.appendValueText(buf, this.cssGridTRows);
            if (!this.defaultGridTColumns || GridShorthandBuilder.this.isIdentifier(this.cssGridTRows, "auto")) {
                buf.append('/');
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTColumns);
            }
            GridShorthandBuilder.this.appendPriority(buf, important);
            if (!this.defaultGridTAreas) {
                buf.append("grid-template-areas:");
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTAreas);
                GridShorthandBuilder.this.appendPriority(buf, important);
            }
        }

        boolean isNoneValue() {
            return this.defaultGridTAreas && this.defaultGridTRows && this.defaultGridTColumns;
        }

        StyleValue getGridTemplateAreaItem(int index) {
            if (this.cssGridTAreas.getCssValueType() == CSSValue.CssType.LIST) {
                return ((ValueList)this.cssGridTAreas).item(index);
            }
            if (!this.defaultGridTAreas && index == 0) {
                return this.cssGridTAreas;
            }
            return null;
        }
    }
}

