/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.GroupedResult;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

class Select {
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    private HashSet groupColumnNames;
    TableFilter[] tFilter;
    Expression limitCondition;
    Expression queryCondition;
    Expression havingCondition;
    Expression[] exprColumns;
    int iResultLen;
    int iGroupLen;
    int iHavingLen;
    int iOrderLen;
    int[] sortOrder;
    int[] sortDirection;
    boolean sortUnion;
    HsqlNameManager.HsqlName sIntoTable;
    int intoType;
    Select[] unionArray;
    int unionMaxDepth;
    Select unionSelect;
    int unionType;
    int unionDepth;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    private boolean simpleLimit;
    Result.ResultMetaData resultMetaData;
    IntKeyHashMap asteriskPositions;
    boolean isResolved = false;

    Select() {
    }

    HashMap getColumnAliases() {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.iResultLen; ++i) {
            String string = this.exprColumns[i].getAlias();
            if (string == null) continue;
            hashMap.put(string, this.exprColumns[i]);
        }
        return hashMap;
    }

    void resolve(Session session) throws HsqlException {
        this.resolveTables();
        this.resolveTypes(session);
        this.setFilterConditions(session);
    }

    private void resolveTables() throws HsqlException {
        int n;
        int n2;
        for (n2 = this.iResultLen; n2 < this.exprColumns.length; ++n2) {
            if (this.exprColumns[n2].getType() == 2) {
                if (this.exprColumns[n2].joinedTableColumnIndex != -1) continue;
                n = this.exprColumns[n2].isDescending() ? 1 : 0;
                this.exprColumns[n2] = this.exprColumns[n2].getExpressionForAlias(this.exprColumns, this.iResultLen);
                if (n == 0) continue;
                this.exprColumns[n2].setDescending();
                continue;
            }
            this.exprColumns[n2].replaceAliases(this.exprColumns, this.iResultLen);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceAliases(this.exprColumns, this.iResultLen);
        }
        n2 = this.tFilter.length;
        for (n = 0; n < n2; ++n) {
            this.resolveTables(this.tFilter[n]);
        }
    }

    void resolveUnionColumnTypes() throws HsqlException {
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            for (int i = 0; i < this.iResultLen; ++i) {
                Expression expression = this.exprColumns[i];
                if (expression.isTypeEqual(this.unionSelect.exprColumns[i])) continue;
                this.unionSelect.exprColumns[i] = new Expression(this.unionSelect.exprColumns[i], expression.getDataType(), expression.getColumnSize(), expression.getColumnScale());
            }
        }
    }

    void resolveTypes(Session session) throws HsqlException {
        int n = this.exprColumns.length;
        for (int i = 0; i < n; ++i) {
            this.exprColumns[i].resolveTypes(session);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session);
        }
    }

    void resolveTablesUnion(TableFilter tableFilter) throws HsqlException {
        if (this.unionArray == null) {
            this.resolveTables(tableFilter);
        } else {
            for (int i = 0; i < this.unionArray.length; ++i) {
                this.unionArray[i].resolveTables(tableFilter);
            }
        }
    }

    void resolveTables(TableFilter tableFilter) throws HsqlException {
        int n = this.exprColumns.length;
        for (int i = 0; i < n; ++i) {
            this.exprColumns[i].resolveTables(tableFilter);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTables(tableFilter);
        }
    }

    private void setFilterConditions(Session session) throws HsqlException {
        if (this.queryCondition == null) {
            return;
        }
        for (int i = 0; i < this.tFilter.length; ++i) {
            this.tFilter[i].setConditions(session, this.queryCondition);
        }
    }

    boolean checkResolved(boolean bl) throws HsqlException {
        int n;
        boolean bl2 = true;
        int n2 = this.exprColumns.length;
        for (n = 0; n < n2; ++n) {
            bl2 = bl2 && this.exprColumns[n].checkResolved(bl);
        }
        if (this.queryCondition != null) {
            boolean bl3 = bl2 = bl2 && this.queryCondition.checkResolved(bl);
        }
        if (this.havingCondition != null) {
            bl2 = bl2 && this.havingCondition.checkResolved(bl);
        }
        for (n = 0; n < this.tFilter.length; ++n) {
            if (this.tFilter[n].filterIndex != null) continue;
            this.tFilter[n].filterIndex = this.tFilter[n].filterTable.getPrimaryIndex();
        }
        return bl2;
    }

    Object getValue(Session session, int n) throws HsqlException {
        this.resolve(session);
        Result result = this.getResult(session, 2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        if (n3 == 1) {
            if (n2 == 0) {
                return null;
            }
            if (n2 == 1) {
                Object object = result.rRoot.data[0];
                return result.metaData.colTypes[0] == n ? object : Column.convertObject(object, n);
            }
            throw Trace.error(17);
        }
        HsqlException hsqlException = Trace.error(17);
        throw new HsqlInternalException(hsqlException);
    }

    void prepareResult(Session session) throws HsqlException {
        int n;
        this.resolveAll(session, true);
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            for (n = this.iResultLen; n < this.iResultLen + this.iGroupLen; ++n) {
                this.exprColumns[n].collectAllColumnNames(this.groupColumnNames);
            }
        }
        n = this.exprColumns.length;
        Result.ResultMetaData resultMetaData = this.resultMetaData = new Result.ResultMetaData(n);
        int n2 = this.iResultLen;
        int n3 = n2 + this.iGroupLen;
        int n4 = n3 + this.iHavingLen;
        int n5 = n4 + this.iOrderLen;
        for (int i = 0; i < n; ++i) {
            Expression expression = this.exprColumns[i];
            resultMetaData.colTypes[i] = expression.getDataType();
            resultMetaData.colSizes[i] = expression.getColumnSize();
            resultMetaData.colScales[i] = expression.getColumnScale();
            if (expression.isAggregate()) {
                this.isAggregated = true;
            }
            if (i >= n2 && i < n3 && !this.exprColumns[i].canBeInGroupBy()) {
                Trace.error(68, this.exprColumns[i]);
            }
            if (i >= n3 && i < n3 + this.iHavingLen && !this.exprColumns[i].isConditional()) {
                Trace.error(69, this.exprColumns[i]);
            }
            if (i >= n4 && i < n5 && !this.exprColumns[i].canBeInOrderBy()) {
                Trace.error(70, this.exprColumns[i]);
            }
            if (i >= this.iResultLen) continue;
            resultMetaData.colLabels[i] = expression.getAlias();
            resultMetaData.isLabelQuoted[i] = expression.isAliasQuoted();
            resultMetaData.schemaNames[i] = expression.getTableSchemaName();
            resultMetaData.tableNames[i] = expression.getTableName();
            resultMetaData.colNames[i] = expression.getColumnName();
            if (resultMetaData.isTableColumn(i)) {
                resultMetaData.colNullable[i] = expression.nullability;
                resultMetaData.isIdentity[i] = expression.isIdentity;
                resultMetaData.isWritable[i] = expression.isWritable;
            }
            resultMetaData.classNames[i] = expression.getValueClassName();
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        this.checkAggregateOrGroupByColumns(n3, n4);
        this.checkAggregateOrGroupByOrderColumns(n4, n5);
        this.prepareSort();
        this.simpleLimit = !this.isDistinctSelect && !this.isGrouped && this.unionSelect == null && this.iOrderLen == 0;
    }

    void prepareUnions() throws HsqlException {
        int n = 0;
        Select select = this;
        while (select != null) {
            select = select.unionSelect;
            ++n;
        }
        if (n == 1) {
            if (this.unionDepth != 0) {
                throw Trace.error(121);
            }
            return;
        }
        this.unionArray = new Select[n];
        n = 0;
        select = this;
        while (select != null) {
            this.unionArray[n] = select;
            this.unionMaxDepth = select.unionDepth > this.unionMaxDepth ? select.unionDepth : this.unionMaxDepth;
            select = select.unionSelect;
            ++n;
        }
        if (this.unionArray[this.unionArray.length - 1].unionDepth != 0) {
            throw Trace.error(121);
        }
    }

    Result getResult(Session session, int n) throws HsqlException {
        Result result;
        if (this.unionArray == null) {
            result = this.getSingleResult(session, n);
        } else {
            result = this.getResultMain(session);
            if (this.sortUnion) {
                this.sortResult(session, result);
                result.trimResult(this.getLimitStart(session), this.getLimitCount(session, n));
            }
        }
        result.setColumnCount(this.iResultLen);
        return result;
    }

    private Result getResultMain(Session session) throws HsqlException {
        int n;
        Result[] resultArray = new Result[this.unionArray.length];
        for (n = 0; n < this.unionArray.length; ++n) {
            resultArray[n] = this.unionArray[n].getSingleResult(session, Integer.MAX_VALUE);
        }
        for (n = this.unionMaxDepth; n >= 0; --n) {
            block2: for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.unionArray.length - 1; ++j) {
                    int n2;
                    if (resultArray[j] == null || this.unionArray[j].unionDepth < n || i == 0 && this.unionArray[j].unionType != 3 || i == 1 && this.unionArray[j].unionType == 3) continue;
                    for (n2 = j + 1; n2 < this.unionArray.length && resultArray[n2] == null; ++n2) {
                    }
                    if (n2 == this.unionArray.length) continue block2;
                    this.unionArray[j].mergeResults(session, resultArray[j], resultArray[n2]);
                    resultArray[n2] = resultArray[j];
                    resultArray[j] = null;
                }
            }
        }
        return resultArray[resultArray.length - 1];
    }

    private void mergeResults(Session session, Result result, Result result2) throws HsqlException {
        switch (this.unionType) {
            case 1: {
                result.append(result2);
                result.removeDuplicates(session, this.iResultLen);
                break;
            }
            case 2: {
                result.append(result2);
                break;
            }
            case 3: {
                result.removeDifferent(session, result2, this.iResultLen);
                break;
            }
            case 4: {
                result.removeSecond(session, result2, this.iResultLen);
            }
        }
    }

    int getLimitStart(Session session) throws HsqlException {
        Integer n;
        if (this.limitCondition != null && (n = (Integer)this.limitCondition.getArg().getValue(session)) != null) {
            return n;
        }
        return 0;
    }

    int getLimitCount(Session session, int n) throws HsqlException {
        Integer n2;
        int n3 = 0;
        if (this.limitCondition != null && (n2 = (Integer)this.limitCondition.getArg2().getValue(session)) != null) {
            n3 = n2;
        }
        if (n != 0 && (n3 == 0 || n < n3)) {
            n3 = n;
        }
        return n3;
    }

    int getMaxRowCount(Session session, int n) throws HsqlException {
        int n2 = this.getLimitStart(session);
        int n3 = this.getLimitCount(session, n);
        if (!this.simpleLimit) {
            n = Integer.MAX_VALUE;
        } else {
            if (n == 0) {
                n = n3;
            }
            n = n == 0 || n > Integer.MAX_VALUE - n2 ? Integer.MAX_VALUE : (n += n2);
        }
        return n;
    }

    private Result getSingleResult(Session session, int n) throws HsqlException {
        if (this.resultMetaData == null) {
            this.prepareResult(session);
        }
        Result result = this.buildResult(session, this.getMaxRowCount(session, n));
        if (this.isDistinctSelect) {
            result.removeDuplicates(session, this.iResultLen);
        }
        if (!this.sortUnion) {
            this.sortResult(session, result);
            result.trimResult(this.getLimitStart(session), this.getLimitCount(session, n));
        }
        return result;
    }

    private void prepareSort() {
        int n;
        if (this.iOrderLen == 0) {
            return;
        }
        this.sortOrder = new int[this.iOrderLen];
        this.sortDirection = new int[this.iOrderLen];
        int n2 = n = this.iResultLen + this.iGroupLen + this.iHavingLen;
        for (int i = 0; i < this.iOrderLen; ++i) {
            int n3 = n2;
            if (this.exprColumns[n2].joinedTableColumnIndex != -1) {
                n3 = this.exprColumns[n2].joinedTableColumnIndex;
            }
            this.sortOrder[i] = n3;
            this.sortDirection[i] = this.exprColumns[n2].isDescending() ? -1 : 1;
            ++n2;
        }
    }

    private void sortResult(Session session, Result result) throws HsqlException {
        if (this.iOrderLen == 0) {
            return;
        }
        result.sortResult(session, this.sortOrder, this.sortDirection);
    }

    private void checkAggregateOrGroupByColumns(int n, int n2) throws HsqlException {
        if (n < n2) {
            int n3;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            for (n3 = n; n3 < n2; ++n3) {
                this.exprColumns[n3].collectInGroupByExpressions(hsqlArrayList);
            }
            int n4 = hsqlArrayList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                Expression expression = (Expression)hsqlArrayList.get(n3);
                if (this.inAggregateOrGroupByClause(expression)) continue;
                throw Trace.error(67, expression);
            }
        }
    }

    private void checkAggregateOrGroupByOrderColumns(int n, int n2) throws HsqlException {
        this.checkAggregateOrGroupByColumns(n, n2);
        if (n < n2 && this.isDistinctSelect) {
            int n3;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            for (n3 = n; n3 < n2; ++n3) {
                this.exprColumns[n3].collectInGroupByExpressions(hsqlArrayList);
            }
            int n4 = hsqlArrayList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                Expression expression = (Expression)hsqlArrayList.get(n3);
                if (this.isSimilarIn(expression, 0, this.iResultLen)) continue;
                throw Trace.error(71, expression);
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression expression) {
        if (this.isGrouped) {
            return this.isSimilarIn(expression, this.iResultLen, this.iResultLen + this.iGroupLen) || Select.allColumnsAreDefinedIn(expression, this.groupColumnNames);
        }
        if (this.isAggregated) {
            return expression.canBeInAggregate();
        }
        return true;
    }

    private boolean isSimilarIn(Expression expression, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!expression.similarTo(this.exprColumns[i])) continue;
            return true;
        }
        return false;
    }

    static boolean allColumnsAreDefinedIn(Expression expression, HashSet hashSet) {
        HashSet hashSet2 = new HashSet();
        expression.collectAllColumnNames(hashSet2);
        if (hashSet2.size() > 0 && hashSet == null) {
            return false;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private Result buildResult(Session session, int n) throws HsqlException {
        int n2;
        int n3;
        Object[] objectArray;
        boolean bl;
        GroupedResult groupedResult = new GroupedResult(this, this.resultMetaData);
        int n4 = this.exprColumns.length;
        int n5 = this.tFilter.length;
        boolean[] blArray = new boolean[n5];
        boolean[] blArray2 = new boolean[n5];
        int n6 = 0;
        boolean bl2 = bl = this.queryCondition == null || !this.queryCondition.isFixedConditional() || this.queryCondition.testCondition(session);
        while (bl && n6 >= 0) {
            objectArray = this.tFilter[n6];
            if (!blArray[n6]) {
                n3 = objectArray.findFirst(session);
                n2 = objectArray.isOuterJoin && n3 == 0 && !blArray2[n6] && !objectArray.nonJoinIsNull && objectArray.nextOuter(session) ? 1 : 0;
                blArray2[n6] = n2;
                blArray[n6] = n3;
            } else {
                n3 = objectArray.next(session);
                n2 = objectArray.isOuterJoin && n3 == 0 && !blArray[n6] && !blArray2[n6] && !objectArray.nonJoinIsNull && objectArray.nextOuter(session) ? 1 : 0;
                blArray2[n6] = n2;
                blArray[n6] = n3;
            }
            if (n3 == 0 && n2 == 0) {
                --n6;
                continue;
            }
            if (n6 < n5 - 1) {
                ++n6;
                continue;
            }
            while (blArray2[n6]) {
                blArray2[n6--] = false;
            }
            if (this.queryCondition != null && !this.queryCondition.testCondition(session)) continue;
            try {
                int n7;
                Object[] objectArray2 = new Object[n4];
                for (n7 = groupedResult.groupBegin; n7 < groupedResult.groupEnd; ++n7) {
                    objectArray2[n7] = this.exprColumns[n7].getValue(session);
                }
                objectArray2 = groupedResult.getRow(objectArray2);
                for (n7 = 0; n7 < groupedResult.groupBegin; ++n7) {
                    objectArray2[n7] = this.isAggregated && this.exprColumns[n7].isAggregate() ? this.exprColumns[n7].updateAggregatingValue(session, objectArray2[n7]) : this.exprColumns[n7].getValue(session);
                }
                for (n7 = groupedResult.groupEnd; n7 < n4; ++n7) {
                    objectArray2[n7] = this.isAggregated && this.exprColumns[n7].isAggregate() ? this.exprColumns[n7].updateAggregatingValue(session, objectArray2[n7]) : this.exprColumns[n7].getValue(session);
                }
                groupedResult.addRow(objectArray2);
                if (groupedResult.size() < n) continue;
                break;
            }
            catch (HsqlInternalException hsqlInternalException) {
            }
        }
        if (this.isAggregated && !this.isGrouped && groupedResult.size() == 0) {
            objectArray = new Object[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray[n3] = this.exprColumns[n3].isAggregate() ? null : this.exprColumns[n3].getValue(session);
            }
            groupedResult.addRow(objectArray);
        }
        objectArray = groupedResult.iterator();
        while (objectArray.hasNext()) {
            Object[] objectArray3 = (Object[])objectArray.next();
            if (this.isAggregated) {
                for (n2 = 0; n2 < n4; ++n2) {
                    if (!this.exprColumns[n2].isAggregate()) continue;
                    objectArray3[n2] = this.exprColumns[n2].getAggregatedValue(session, objectArray3[n2]);
                }
            }
            if (this.iHavingLen <= 0 || Boolean.TRUE.equals(objectArray3[this.iResultLen + this.iGroupLen])) continue;
            objectArray.remove();
        }
        return groupedResult.getResult();
    }

    public StringBuffer getDDL() throws HsqlException {
        TableFilter tableFilter;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        for (n = 0; n < this.iResultLen; ++n) {
            stringBuffer.append(this.exprColumns[n].getDDL());
            if (n >= this.iResultLen - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append("FROM");
        for (n = 0; n < this.tFilter.length; ++n) {
            tableFilter = this.tFilter[n];
            if (n != 0 && tableFilter.isOuterJoin) {
                stringBuffer.append("FROM").append(' ');
                stringBuffer.append("JOIN").append(' ');
            }
            stringBuffer.append(',');
        }
        stringBuffer.append(' ').append("WHERE").append(' ');
        for (n = 0; n < this.tFilter.length; ++n) {
            tableFilter = this.tFilter[n];
        }
        stringBuffer.append(' ').append("GROUP").append(' ');
        for (n = this.iResultLen; n < this.iResultLen + this.iGroupLen; ++n) {
            stringBuffer.append(this.exprColumns[n].getDDL());
            if (n >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(' ').append("HAVING").append(' ');
        for (n = this.iResultLen + this.iGroupLen; n < this.iResultLen + this.iGroupLen + this.iHavingLen; ++n) {
            stringBuffer.append(this.exprColumns[n].getDDL());
            if (n >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    stringBuffer.append(' ').append("EXCEPT").append(' ');
                    break;
                }
                case 3: {
                    stringBuffer.append(' ').append("INTERSECT").append(' ');
                    break;
                }
                case 1: {
                    stringBuffer.append(' ').append("UNION").append(' ');
                    break;
                }
                case 2: {
                    stringBuffer.append(' ').append("UNION").append(' ').append("ALL").append(' ');
                }
            }
        }
        n = this.iResultLen + this.iGroupLen;
        int n2 = n + this.iHavingLen;
        int n3 = n2 + this.iOrderLen;
        stringBuffer.append(' ').append("ORDER").append("BY").append(' ');
        for (int i = n2; i < n3; ++i) {
            stringBuffer.append(this.exprColumns[i].getDDL());
            if (i >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer;
    }

    boolean resolveAll(Session session, boolean bl) throws HsqlException {
        if (this.isResolved) {
            return true;
        }
        this.resolve(session);
        this.isResolved = this.checkResolved(bl);
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            for (int i = 0; i < this.iResultLen; ++i) {
                Expression expression = this.exprColumns[i];
                if (expression.isTypeEqual(this.unionSelect.exprColumns[i])) continue;
                this.unionSelect.exprColumns[i] = new Expression(this.unionSelect.exprColumns[i], expression.getDataType(), expression.getColumnSize(), expression.getColumnScale());
            }
            this.isResolved &= this.unionSelect.resolveAll(session, bl);
        }
        return this.isResolved;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String describe(Session session) {
        int n;
        try {
            this.getResult(session, 1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            stringBuffer.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        if (this.limitCondition != null) {
            stringBuffer.append("offset=[").append(this.limitCondition.getArg().describe(session)).append("]\n");
            stringBuffer.append("limit=[").append(this.limitCondition.getArg2().describe(session)).append("]\n");
        }
        stringBuffer.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuffer.append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuffer.append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuffer.append("columns=[");
        int n2 = this.exprColumns.length - this.iOrderLen;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.exprColumns[n].describe(session));
        }
        stringBuffer.append("\n]\n");
        stringBuffer.append("tableFilters=[\n");
        for (n = 0; n < this.tFilter.length; ++n) {
            stringBuffer.append("[\n");
            stringBuffer.append(this.tFilter[n].describe(session));
            stringBuffer.append("\n]");
        }
        stringBuffer.append("]\n");
        String string = this.queryCondition == null ? "null" : this.queryCondition.describe(session);
        stringBuffer.append("eCondition=[").append(string).append("]\n");
        string = this.havingCondition == null ? "null" : this.havingCondition.describe(session);
        stringBuffer.append("havingCondition=[").append(string).append("]\n");
        stringBuffer.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    stringBuffer.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    stringBuffer.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    stringBuffer.append(" UNION ");
                    break;
                }
                case 2: {
                    stringBuffer.append(" UNION ALL ");
                    break;
                }
                default: {
                    stringBuffer.append(" UNKNOWN SET OPERATION ");
                }
            }
            stringBuffer.append("[\n").append(this.unionSelect.describe(session)).append("]\n");
        }
        return stringBuffer.toString();
    }

    Result describeResult() {
        Result result = new Result(3, this.iResultLen);
        Result.ResultMetaData resultMetaData = result.metaData;
        for (int i = 0; i < this.iResultLen; ++i) {
            Expression expression = this.exprColumns[i];
            resultMetaData.colTypes[i] = expression.getDataType();
            resultMetaData.colSizes[i] = expression.getColumnSize();
            resultMetaData.colScales[i] = expression.getColumnScale();
            resultMetaData.colLabels[i] = expression.getAlias();
            resultMetaData.isLabelQuoted[i] = expression.isAliasQuoted();
            resultMetaData.tableNames[i] = expression.getTableName();
            resultMetaData.colNames[i] = expression.getColumnName();
            if (!resultMetaData.isTableColumn(i)) continue;
            resultMetaData.colNullable[i] = expression.nullability;
            resultMetaData.isIdentity[i] = expression.isIdentity;
            resultMetaData.isWritable[i] = expression.isWritable;
        }
        return result;
    }
}

