/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene84;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene84.ForUtil;
import org.apache.lucene.backward_codecs.lucene84.PForUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.PackedInts;

public class ForDeltaUtil {
    private static final long[] IDENTITY_PLUS_ONE = new long[128];
    private final ForUtil forUtil;

    private static void prefixSumOfOnes(long[] arr, long base) {
        System.arraycopy(IDENTITY_PLUS_ONE, 0, arr, 0, 128);
        int i = 0;
        while (i < 128) {
            int n = i++;
            arr[n] = arr[n] + base;
        }
    }

    ForDeltaUtil(ForUtil forUtil) {
        this.forUtil = forUtil;
    }

    void encodeDeltas(long[] longs, DataOutput out) throws IOException {
        if (longs[0] == 1L && PForUtil.allEqual(longs)) {
            out.writeByte((byte)0);
        } else {
            long or = 0L;
            for (long l : longs) {
                or |= l;
            }
            assert (or != 0L);
            int bitsPerValue = PackedInts.bitsRequired((long)or);
            out.writeByte((byte)bitsPerValue);
            this.forUtil.encode(longs, bitsPerValue, out);
        }
    }

    void decodeAndPrefixSum(DataInput in, long base, long[] longs) throws IOException {
        int bitsPerValue = Byte.toUnsignedInt(in.readByte());
        if (bitsPerValue == 0) {
            ForDeltaUtil.prefixSumOfOnes(longs, base);
        } else {
            this.forUtil.decodeAndPrefixSum(bitsPerValue, in, base, longs);
        }
    }

    void skip(DataInput in) throws IOException {
        int bitsPerValue = Byte.toUnsignedInt(in.readByte());
        if (bitsPerValue != 0) {
            in.skipBytes((long)this.forUtil.numBytes(bitsPerValue));
        }
    }

    static {
        for (int i = 0; i < 128; ++i) {
            ForDeltaUtil.IDENTITY_PLUS_ONE[i] = i + 1;
        }
    }
}

