/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.TargetGroup;
import software.amazon.awssdk.services.ec2.model.TargetGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetGroupsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetGroupsConfig> {
    private static final SdkField<List<TargetGroup>> TARGET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetGroups").getter(TargetGroupsConfig.getter(TargetGroupsConfig::targetGroups)).setter(TargetGroupsConfig.setter(Builder::targetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroups").unmarshallLocationName("targetGroups").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetGroupsConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<TargetGroup> targetGroups;

    private TargetGroupsConfig(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
    }

    public final boolean hasTargetGroups() {
        return this.targetGroups != null && !(this.targetGroups instanceof SdkAutoConstructList);
    }

    public final List<TargetGroup> targetGroups() {
        return this.targetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroups() ? this.targetGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupsConfig)) {
            return false;
        }
        TargetGroupsConfig other = (TargetGroupsConfig)obj;
        return this.hasTargetGroups() == other.hasTargetGroups() && Objects.equals(this.targetGroups(), other.targetGroups());
    }

    public final String toString() {
        return ToString.builder((String)"TargetGroupsConfig").add("TargetGroups", this.hasTargetGroups() ? this.targetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroups": {
                return Optional.ofNullable(clazz.cast(this.targetGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<TargetGroup>>> map = new HashMap<String, SdkField<List<TargetGroup>>>();
        map.put("TargetGroups", TARGET_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupsConfig, T> g) {
        return obj -> g.apply((TargetGroupsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TargetGroup> targetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupsConfig model) {
            this.targetGroups(model.targetGroups);
        }

        public final List<TargetGroup.Builder> getTargetGroups() {
            List<TargetGroup.Builder> result = TargetGroupsCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetGroups(Collection<TargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroup ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<TargetGroup.Builder> ... targetGroups) {
            this.targetGroups(Stream.of(targetGroups).map(c -> (TargetGroup)((TargetGroup.Builder)TargetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TargetGroupsConfig build() {
            return new TargetGroupsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetGroupsConfig> {
        public Builder targetGroups(Collection<TargetGroup> var1);

        public Builder targetGroups(TargetGroup ... var1);

        public Builder targetGroups(Consumer<TargetGroup.Builder> ... var1);
    }
}

