/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.chunker;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.neuralsearch.processor.chunker.ChunkerParameterParser;
import org.opensearch.neuralsearch.processor.chunker.Parser;
import org.opensearch.neuralsearch.processor.chunker.Validator;

public abstract class Chunker
implements Validator,
Parser {
    public static String MAX_CHUNK_LIMIT_FIELD = "max_chunk_limit";
    public static String CHUNK_STRING_COUNT_FIELD = "chunk_string_count";
    public static int DEFAULT_MAX_CHUNK_LIMIT = 100;
    public static int DISABLED_MAX_CHUNK_LIMIT = -1;
    private int maxChunkLimit;

    @Override
    public void parse(Map<String, Object> parameters) throws IllegalArgumentException {
        int maxChunkLimit = ChunkerParameterParser.parseIntegerWithDefault(parameters, MAX_CHUNK_LIMIT_FIELD, DEFAULT_MAX_CHUNK_LIMIT);
        this.validateMaxChunkLimit(maxChunkLimit);
        this.maxChunkLimit = maxChunkLimit;
    }

    public abstract List<String> chunk(String var1, Map<String, Object> var2);

    static boolean checkRunTimeMaxChunkLimit(int chunkResultSize, int runtimeMaxChunkLimit, int chunkStringCount) {
        return runtimeMaxChunkLimit != DISABLED_MAX_CHUNK_LIMIT && chunkResultSize + chunkStringCount >= runtimeMaxChunkLimit;
    }

    public abstract String getAlgorithmName();

    @Override
    public void validate(Map<String, Object> parameters) throws IllegalArgumentException {
        int maxChunkLimit = ChunkerParameterParser.parseIntegerWithDefault(parameters, MAX_CHUNK_LIMIT_FIELD, DEFAULT_MAX_CHUNK_LIMIT);
        this.validateMaxChunkLimit(maxChunkLimit);
    }

    void validateMaxChunkLimit(int maxChunkLimit) throws IllegalArgumentException {
        if (maxChunkLimit <= 0 && maxChunkLimit != DISABLED_MAX_CHUNK_LIMIT) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Parameter [%s] must be positive or %s to disable this parameter", MAX_CHUNK_LIMIT_FIELD, DISABLED_MAX_CHUNK_LIMIT));
        }
    }

    @Generated
    public int getMaxChunkLimit() {
        return this.maxChunkLimit;
    }
}

