# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_zola_global_optspecs
	string join \n r/root= c/config= h/help V/version
end

function __fish_zola_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_zola_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_zola_using_subcommand
	set -l cmd (__fish_zola_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c zola -n "__fish_zola_needs_command" -s r -l root -d 'Directory to use as root of project' -r -F
complete -c zola -n "__fish_zola_needs_command" -s c -l config -d 'Path to a config file other than config.toml in the root of project' -r -F
complete -c zola -n "__fish_zola_needs_command" -s h -l help -d 'Print help'
complete -c zola -n "__fish_zola_needs_command" -s V -l version -d 'Print version'
complete -c zola -n "__fish_zola_needs_command" -f -a "init" -d 'Create a new Zola project'
complete -c zola -n "__fish_zola_needs_command" -f -a "build" -d 'Deletes the output directory if there is one and builds the site'
complete -c zola -n "__fish_zola_needs_command" -f -a "serve" -d 'Serve the site. Rebuild and reload on change automatically'
complete -c zola -n "__fish_zola_needs_command" -f -a "check" -d 'Try to build the project without rendering it. Checks links'
complete -c zola -n "__fish_zola_needs_command" -f -a "completion" -d 'Generate shell completion'
complete -c zola -n "__fish_zola_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c zola -n "__fish_zola_using_subcommand init" -s f -l force -d 'Force creation of project even if directory is non-empty'
complete -c zola -n "__fish_zola_using_subcommand init" -s h -l help -d 'Print help'
complete -c zola -n "__fish_zola_using_subcommand build" -s u -l base-url -d 'Force the base URL to be that value (defaults to the one in config.toml)' -r
complete -c zola -n "__fish_zola_using_subcommand build" -s o -l output-dir -d 'Outputs the generated site in the given path (by default \'public\' dir in project root)' -r -F
complete -c zola -n "__fish_zola_using_subcommand build" -s f -l force -d 'Force building the site even if output directory is non-empty'
complete -c zola -n "__fish_zola_using_subcommand build" -l drafts -d 'Include drafts when loading the site'
complete -c zola -n "__fish_zola_using_subcommand build" -l minify -d 'Minify generated HTML files'
complete -c zola -n "__fish_zola_using_subcommand build" -s h -l help -d 'Print help'
complete -c zola -n "__fish_zola_using_subcommand serve" -s i -l interface -d 'Interface to bind on' -r
complete -c zola -n "__fish_zola_using_subcommand serve" -s p -l port -d 'Which port to use' -r
complete -c zola -n "__fish_zola_using_subcommand serve" -s o -l output-dir -d 'Outputs assets of the generated site in the given path (by default \'public\' dir in project root). HTML/XML will be stored in memory' -r -F
complete -c zola -n "__fish_zola_using_subcommand serve" -s u -l base-url -d 'Changes the base_url' -r
complete -c zola -n "__fish_zola_using_subcommand serve" -l extra-watch-path -d 'Extra path to watch for changes, relative to the project root' -r
complete -c zola -n "__fish_zola_using_subcommand serve" -s d -l debounce -d 'Debounce time in milliseconds for the file watcher (at least 1ms)' -r
complete -c zola -n "__fish_zola_using_subcommand serve" -l force -d 'Force use of the directory for serving the site even if output directory is non-empty'
complete -c zola -n "__fish_zola_using_subcommand serve" -l drafts -d 'Include drafts when loading the site'
complete -c zola -n "__fish_zola_using_subcommand serve" -s O -l open -d 'Open site in the default browser'
complete -c zola -n "__fish_zola_using_subcommand serve" -l store-html -d 'Also store HTML in the public/ folder (by default HTML is only stored in-memory)'
complete -c zola -n "__fish_zola_using_subcommand serve" -s f -l fast -d 'Only rebuild the minimum on change - useful when working on a specific page/section'
complete -c zola -n "__fish_zola_using_subcommand serve" -l no-port-append -d 'Default append port to the base url'
complete -c zola -n "__fish_zola_using_subcommand serve" -s h -l help -d 'Print help'
complete -c zola -n "__fish_zola_using_subcommand check" -l drafts -d 'Include drafts when loading the site'
complete -c zola -n "__fish_zola_using_subcommand check" -l skip-external-links -d 'Skip external links'
complete -c zola -n "__fish_zola_using_subcommand check" -s h -l help -d 'Print help'
complete -c zola -n "__fish_zola_using_subcommand completion" -s h -l help -d 'Print help'
complete -c zola -n "__fish_zola_using_subcommand help; and not __fish_seen_subcommand_from init build serve check completion help" -f -a "init" -d 'Create a new Zola project'
complete -c zola -n "__fish_zola_using_subcommand help; and not __fish_seen_subcommand_from init build serve check completion help" -f -a "build" -d 'Deletes the output directory if there is one and builds the site'
complete -c zola -n "__fish_zola_using_subcommand help; and not __fish_seen_subcommand_from init build serve check completion help" -f -a "serve" -d 'Serve the site. Rebuild and reload on change automatically'
complete -c zola -n "__fish_zola_using_subcommand help; and not __fish_seen_subcommand_from init build serve check completion help" -f -a "check" -d 'Try to build the project without rendering it. Checks links'
complete -c zola -n "__fish_zola_using_subcommand help; and not __fish_seen_subcommand_from init build serve check completion help" -f -a "completion" -d 'Generate shell completion'
complete -c zola -n "__fish_zola_using_subcommand help; and not __fish_seen_subcommand_from init build serve check completion help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
