.TH PBIBTEX 1 "12 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\h'-0.17m'\v'+0.21m'E\v'-0.21m'\h'-0.04m'X\fP
.el .ds OX TeX\"
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\"=====================================================================
.SH NAME
pbibtex, upbibtex \- make a (Japanese) bibliography for (La)TeX
.SH SYNOPSIS
.B pbibtex
.RI [ options ]
.IR auxname [ \fB.aux\fP ]
.\"=====================================================================
.SH DESCRIPTION
p\*(BX (\fBpbibtex\fR)
is a modified version of 
.BR bibtex (1)
for handling Japanese bibliographies. It sorts entries according to code
points in EUC-JP, and provides new and modified built-in functions
described below.
.PP
up\*(BX (\fBupbibtex\fR) is a modified version of p\*(BX, which sorts
entries according to code points in Unicode.
.PP
.B Extensions to bibliography style (bst) functions
.PP
A new built-in function is available, and some other functions
are modified to simplify Japanese handling.
.PP
.TP 5
.B is.kanji.str$
[New built-in]
Pops the top (string) literal to see if it contains any non-ASCII
characters. Pushes 1 if it contains at least one, 0 if not.
.PP
.TP 5
.B substring$
Modified to avoid dividing a character string in the middle of
a multibyte character.
.PP
.TP 5
.B text.prefix$
Similar modification as to
.BR substring$ .
.PP
.TP 5
.B add.period$
Modified to prevent appending "." after the Japanese punctuation marks
corresponding to "!", "?" and ".",
namely U+FF01, U+FF1F, U+3002 and U+FF0E.
.PP
.TP 5
.B format.name$
Modified to accept Japanese \fIzenkaku\fR ideographic space
(U+3000) for names displayed in Japanese.
Also modified to recognize Japanese commas (U+3001 and U+FF0C)
similar to "and" between names.
.\"=====================================================================
.SH OPTIONS
See
.BR tex (1)
for details of command-line parsing, and
.BR bibtex (1)
for common options: \fB-min-crossrefs\fP, \fB-terse\fP, \fB-help\fP,
\fB-version\fP.
.TP
.B [-no]-guess-input-enc
Disable/enable guessing of the input file encoding.
.TP
.BI -kanji= string
Set Japanese encoding, where \fIstring\fP is one of
\fIeuc\fP, \fIjis\fP, \fIsjis\fP, \fIutf8\fP, \fIuptex\fP.
.TP
.BI -kanji-internal= string
Set Japanese internal encoding, where \fIstring\fP is one of \fIeuc\fP
or \fIuptex\fP.
.\"=====================================================================
.SH "SEE ALSO"
.BR bibtex (1),
.BR ptex (1).
.\"=====================================================================
.SH AUTHORS
\*(BX was written by Oren Patashnik at Stanford University.
.PP
The Japanese version of \*(BX was originally developed by Shouichi Matsui
as J\*(BX until 1991.
It was developed to behave consistently with NTT J\*(TX in handling
legacy Japanese encodings.
The old documentation files jbibtex.pdf, jbtxdoc.tex, jbtxhak.tex
(all available in \*(TX Live)
describe Japanese handling capability and some additional notes
of J\*(BX.
.PP
Current (u)p\*(BX is a forked version of J\*(BX,
and has replaced the encoding conversion routine with one that is
compatible with the (u)p\*(TX community edition using the ptexenc library.
Descriptions of encodings in the old documentation files
j*.pdf (especially Section 3.3 of jbibtex.pdf, such as BIBTERMCODE
and BIBFILECODE) are no longer correct.
.PP
This manual page was written by Hironobu Yamashita.
.PP
Email bug reports to issue@texjp.org.
