.TH PDFTOSRC 1 "16 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.\"=====================================================================
.SH NAME
pdftosrc \- extract source file or stream from PDF file
.SH SYNOPSIS
.B pdftosrc
.I PDF-file
.RI [ stream-object-number ]
.\"=====================================================================
.SH DESCRIPTION
If only
.I PDF-file
is given as argument,
.B pdftosrc
extracts the embedded source file
from the first found stream object
with /Type /SourceFile within the
.I PDF-file
and writes it to a file with the name /SourceName
as defined in that PDF stream object
(see application example below).
.PP
If both
.I PDF-file
and
.I stream-object-number
are given as arguments, and
.I stream-object-number
is positive,
.B pdftosrc
extracts and uncompresses the PDF stream of the object
given by its
.I stream-object-number
from the
.I PDF-file
and writes it to a file named
.IR PDF-file . stream-object-number
with the ending
.B .pdf
or
.B .PDF
stripped from the original
.I PDF-file
name.
.PP
A special case is related to XRef object streams that are part
of the PDF standard from PDF-1.5 onward:
If
.I stream-object-number
equals -1,
then
.B pdftosrc
decompresses the XRef stream from the PDF file and writes it
in human-readable PDF cross-reference table format to a file named
.IB PDF-file .xref
(these XRef streams cannot be extracted just by giving their object number).
.PP
In any case,
an existing file with the output file name will be overwritten.
.PP
.B Notes
.PP
An embedded source file is written unchanged,
i.e., it will not be uncompressed.
.PP
Only the stream of the object will be written,
i.e., not the dictionary of that object.
.PP
Knowing which
.I stream-object-number
to query requires information about the PDF file
that has to be gained elsewhere,
e.g., by looking into the PDF file with an editor or dumping it with a
utility.
.PP
The stream extraction capabilities of
.B pdftosrc
(regarding known PDF versions and filter types, for instance)
follow the capabilities of the underlying
.B xpdf
program version.
.PP
Currently the generation number of the stream object
is not supported.
The default value 0 (zero) is taken.
.PP
The wording
.I stream-object-number
has nothing to do with the `object streams' introduced
by the \fIAdobe PDF Reference\fP, 5th edition, version 1.6.
.SH EXAMPLES
An external file, say \fImyfile.zip\fP, can be embedded into a file
\fIfoo.pdf\fP by using pdf\*(TX primitives, as illustrated by the
following example:
.PP
.RS
\\immediate\\pdfobj
    stream attr {/Type /SourceFile /SourceName (myfile.zip)}
    file{myfile.zip}
\\pdfcatalog{/SourceObject \\the\\pdflastobj\\space 0 R}
.RE
Then \fImyfile.zip\fP can be extracted from \fIfoo.pdf\fP
by calling "pdftosrc foo.pdf".
.\"=====================================================================
.SH OPTIONS
None.
.SH ENVIRONMENT
None.
.\"=====================================================================
.SH DIAGNOSTICS
If success, the exit code of
.B pdftosrc
is 0, else 1.
.PP
All messages go to stderr.
At program invocation,
.B pdftosrc
issues the current version number of the program
.BR xpdf ,
on which
.B pdftosrc
is based, though it is maintained as part of pdf\*(TX.
.PP
When
.B pdftosrc
was successful with the output file writing,
one of the following messages will be issued:
.PP
.RS
Source file extracted to
.I source-file-name
.RE
or
.RS
Stream object extracted to
.IR PDF-file . stream-object-number
.RE
or
.RS
Cross-reference table extracted to
.IR PDF-file .xref
.RE
.PP
When the object given by the
.I stream-object-number
does not contain a stream,
.B pdftosrc
issues the following error message:
.RS
Not a Stream object
.RE
.PP
When the
.I PDF-file
can't be opened, the error message is:
.RS
Error: Couldn't open file
.RI ' PDF-file '.
.RE
.PP
When
.B pdftosrc
encounters an invalid PDF file,
the error message (several lines) is:
.RS
Error: May not be a PDF file (continuing anyway)
.RE
.RS
(more lines)
.RE
.RS
Invalid PDF file
.RE
.PP
There are other error messages from
.B pdftosrc
for various kinds of broken PDF files.
.\"=====================================================================
.SH BUGS
Not all embedded source files will be extracted,
only the first one found.
.\"=====================================================================
.SH SEE ALSO
.BR pdfimages (1),
.BR pdftex (1),
.BR pdftotext (1),
.BR xpdf (1).
.\"=====================================================================
.SH AUTHORS
.B pdftosrc
is part of pdf\*(TX was written by H\[`a]n The Th\[`a]nh, using
.B xpdf
functionality from Derek Noonburg. Man page written by Hartmut Henkel.
.PP
Public discussion list for pdftosrc:
https://lists.tug.org/pdftex
