.TH VFTOVP 1 "30 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.\"=====================================================================
.SH NAME
vftovp \- convert TeX virtual font (vf) files to virtual property lists (vpl)
.SH SYNOPSIS
.B vftovp
.RI [ options ]
.IR vf_file [ \fB.vf\fP ]
.RI [ tfm_file [ \fB.tfm\fP ]
.RI [ vpl_file [ \fB.vpl\fP ]]]
.\"=====================================================================
.SH DESCRIPTION
The
.B vftovp
program translates a (binary) virtual font file and its accompanying
\*(TX font metric file to a (plain text) property list file. Thus, the
virtual font can be edited, and its exact contents can be displayed
mnemonically. It also serves as a vf-file validating program, i.e., if
no error messages are given, the input files are correct.
.PP
The filenames are extended with the appropriate extension if necessary.
.PP
\*(TX's virtual font format supports composing new characters from
characters from any number of existing fonts, and also using rules in
characters. This allows, for example, re-encoding with a mixture of
characters from different fonts. These vf fonts are entirely unrelated
to the variable fonts that can be created with OpenType, which also
conventionally use the \fI.vf\fP extension.
.\"=====================================================================
.SH OPTIONS
See
.BR tex (1)
for details of command-line parsing.
.TP
.BI -charcode-format= format
The argument
.I format
specifies how character codes are output in the vpl file.  By default (the
historical behavior), ASCII letters and digits are output using the "C"
code (i.e., as themselves), and other characters are output in octal;
unless the font's coding scheme starts with "TeX math sy" or "TeX math
ex", in which case all character codes are output in octal.
.IP
If
.I format
is
.BR ascii ,
all character codes that correspond to graphic characters, besides the
left and right parentheses, are output in ASCII.
.IP
Finally, if
.I format
is
.BR octal ,
all character codes are output in octal.  (This option is the same as in
\fBtftopl\fP.)
.TP
.B -verbose
By default, the program operates silently. With this option, some
reports are written to stdout.
.PP
The standard
.B -help
and
.B -version
options are also supported.
.\"=====================================================================
.SH ENVIRONMENT
The program looks for
.I vf_file
using the environment variable VFFONTS, and
.I tfm_file
using the environment variable TFMFONTS. If either is not set, it then
checks the variable TEXFONTS. If that is not set, it uses the system
default. See the Kpathsea manual at https://tug.org/kpathsea for the
details of the searching.
.\"=====================================================================
.SH "SEE ALSO"
.BR pltotf (1),
.BR tftopl (1),
.BR vptovf (1).
.PP
Brief description of virtual fonts, and additional references:
https://tug.org/texinfohtml/dvips.html#Virtual-fonts
.br
Knuth's original message introducing virtual fonts:
https://mirror.ctan.org/info/virtual-fonts.knuth
.br
Font utility topic on CTAN: https://ctan.org/topic/font-util
.br
Package page on CTAN: https://ctan.org/pkg/vftovp
.br
Section in the Web2c manual:
https://tug.org/texinfohtml/web2c.html#vftovp-invocation
.br
Typeset source code, including the vf file format description:
https://ctan.org/pkg/knuth-pdf
.\"=====================================================================
.SH AUTHORS
Donald E. Knuth wrote the program, based in part on an idea of David Fuchs,
starting with the code for
.BR tftopl (1).
Karl Berry adapted it for compilation with
.BR web2c .
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
