---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes
---

# Comment définir un style de paragraphe ?

Les paramètres de définition d'un paragraphe sont :

- `\parindent` pour fixer la longueur du retrait d'alinéa ;
- `\parskip` pour gérer l'espace entre les paragraphes.

L'extension <ctanpkg:layouts> permet de visualiser ces deux éléments 
avec sa commande `\paragraphdiagram` ou sa commande `\paragraphdesign`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{layouts}

\begin{document}
Un graphique de définition :
\paragraphdiagram

Un graphique associé avec les valeurs courantes :
\paragraphdesign
\end{document}
```

Généralement, ces commandes sont modifiées avec une commande similaire 
à ce qui suit :

```{noedit}
\setlength{\parindent}{-10em}
```

En TeX, la syntaxe est différente :

```{noedit}
\parindent=-10em
```

Des exemples de modification sont donnés dans la section 
[Indentation des paragraphes](indentation/start) :
- [](indentation/changer_l_indentation_en_debut_de_paragraphe) ;
- [](indentation/supprimer_l_indentation_en_debut_de_paragraphe).

:::{todo} Ajouter \baselineskip et \linewidth.
:::