---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, interlignage, \linespread, 
              \baselineskip
---

# Pourquoi la commande `\linespread` ne fonctionne pas ?

La commande `\linespread{⟨facteur⟩}` est censée multiplier 
la valeur courante de `\baselineskip` par le coefficient `⟨facteur⟩`.
Autrement dit, cette commande augmente la taille de l'interligne 
(mesuré de la base d'une ligne à la base de la suivante) 
de ce facteur multiplicatif.

Toutefois, parfois, cette commande ne semble pas marcher.

En fait, la commande équivaut à `\renewcommand{\baselinestretch}{⟨facteur⟩}`. 
Ceci permet de comprendre que l'effet n'est pas immédiat : 
le facteur `\baselinestretch` n'est utilisé que lorsqu'une police 
est sélectionnée. Un simple changement de `\baselinestretch` ne change pas 
la police, pas plus que la commande 
`\fontsize{⟨taille de la fonte⟩}{⟨taille de la \baselineskip⟩}`. 
De fait, vous devez suivre l'une des deux solutions suivantes intégrant 
`\selectfont` :

```{noedit}
\fontsize{10}{12}%
\selectfont
```

La question "[](modifier_l_interligne)" illustre ce point.

Bien sûr, une extension telle que <ctanpkg:setspace>, dont le travail 
est de gérer la ligne de base, s'occupera de tout cela, comme illustré 
à la question "[](modifier_l_interligne)". Ceci dit, si vous voulez éviter 
<ctanpkg:setspace>, méfiez-vous du comportement 
[des espaces interlignes au sein d'un paragraphe](obtenir_plus_d_un_baselineskip).


:::{sources}
[Why doesn't `\linespread` work?](faquk:FAQ-linespread)
:::