.PS
# pwrsupply.m4
cct_init
ifdef(`m4pco',`resetrgb')

ifelse(0,1,`
Singlephase:[
    linewid = linewid*1.2
    down_
  T:transformer
    line left_ elen_/8 from T.P1
    rgbdraw(0,0,1,fuse(left_ elen_/3,D))
    reversed(`switch',left_ elen_*2/3)
    gap(down_ to (Here,T.P2))
    { fuse(right_ 2*dimen_/5 at last []) }
    line to T.P2
    blen = dimen_/2
  W: T.TS+(dimen_/2,0)
  N: W+(blen,blen)
  S: W+(blen,-blen)
  E: S+(blen,blen)
    diode(from W to N)
    diode(from S to E)
  G: gap(from E+(dimen_,0) down_ (E.y-S.y)*5/4); llabel(+,,-)
  C: capacitor(down_ G.start.y-G.end.y from 0.5 between E and G.start,C)
  
  setrgb(255,0,0)
    line from T.S1 to (T.S1,N); line to N
    dot
    diode(to E); dot
    line from E to G.start; dot
    dot(at C.start)
  resetrgb
  
  setrgb(0,255,0,,D)
    dot(at C.end)
    dot(at G.end)
    ground
    line to (W,Here); line to W; dot
    diode(to S); dot
    line to (T.S2,Here); line to T.S2
  resetrgb
  ]

Threephase: [
L:[ loadht = 2*elen_
  Load: ebox(down_ loadht,0.4,0.25); llabel(+,,-)
    hsep = dimen_*3/4
    for_(1,3,1,
     `line left_ hsep; ifelse(m4x,3,,dot)
      { diode(up_ loadht/3) ; line up_ loadht/3; diode(up_ loadht/3)
      T`'m4x: ifelse(m4x,3,Here,dot)
      line right hsep } ')
  ]

T:[
  X1: transformer(down_ dimen_*2/3,,,,4)
  X2: transformer(down_ dimen_*2/3,,,,4) with .P1 at X1.P2
  X3: transformer(down_ dimen_*2/3,,,,4) with .P1 at X2.P2
      line from X1.M4Core1.end to X3.M4Core1.start
      line from X1.M4Core2.end to X3.M4Core2.start
  for_(1,3,1,
   `move to X`'m4x.P2 ; ifelse(m4x,3,,dot)
    line left_ dimen_
    P`'m4x: dot(,,1)')
    line left_ dimen_/2 from X1.P1 then down X1.P1.y-P3.y; dot
  B: X1.S2+(dimen_/2,0)
    line from X1.S1 right B.x-X1.S2.x then down X1.S1.y-X3.S1.y then to X3.S1 
    line from X2.S1 to (B,X2.S1); dot
  ] with .X2.S2 at L.w-(dimen_,0)

  line from T.X1.S2 to (L.T3,T.X1.S2); dot 
  line from T.X2.S2 to (L.T2,T.X2.S2); dot 
  line from T.X3.S2 to (L.T1,T.X3.S2); dot 
] with .sw at Singlephase.se+(0.3,0)
')


#.PE
#.PS
# PS50.m4
# Fig 9.49 p. 630
#cct_init

PS50: [
svg_font(sans-serif,9bp__)

   h = dimen_*2.5
 T: dot
 Cs: capacitor(down_ h/2)
   llabel(,"C`'svg_sub(s)" ljust "0.1-1`'svg_micro`'F" ljust)
   dot; { line right_ dimen_*3/4; ground(,,F) }
 Rs: resistor(down_ Cs.len)
   llabel(,"R`'svg_sub(s)" ljust "10`'svg_ohm-" ljust "100`'svg_ohm" ljust)
 B: dot
 Br: [ size=dimen_/2
   N: dot; E: dot(at N+(size,-size))
   W: dot(at N+(-size,-size)); S: dot(at W+(size,-size))
   diode(from N to E); diode(from W to N)
   diode(from W to S); diode(from S to E)
   thinlines_
   box dashed wid 3*size ht 3*size with .c at 0.5 between N and S
   "GBU604" at last box.n above rjust ] with .W at Cs.end+(dimen_*3/2,0)
   line from Br.N to (Br.N,T) then left Br.N.x-Cs.x+dimen_*3/4
   { line from (Here,B) to (Br.S,B) then to Br.S }
 T80: transformer(up_ h,,,W) with .P2 at Here
   "115 V:80 V CT" at T80+(-dimen_/4,-h/2-dimen_/3) "4 A"

   line from Br.E right dimen_/2 then up T.y-Br.E.y then right_ dimen_*2/3
   dot; {C1: capacitor(down_ Cs.len+dimen_/3,C+); rlabel(,C`'svg_sub(1))
    dot; C2: capacitor(down_ C1.len,C+); rlabel(,C`'svg_sub(2)); dot}
   {"2 x 8200`'svg_micro`'F" \
    at C1.start+(0,dimen_/2) "80 Vdc" }
   {line right_ dimen_*3/2
 P50: dot(,dotrad_*3/2,1)
     "+50 V" at last [].e ljust "2 A" ljust }
   dot(at 1/2 between Here and P50)
 R2: resistor(down_ C1.len)
   llabel(,"R`'svg_sub(2)" ljust "680" ljust "5 W" ljust)
   {dot; line to (C1,Here)}
   {line to (P50,Here); dot(,dotrad_*3/2,1)
    "COM" wid 24bp__ at last [].e ljust}
 R3: resistor(down_ C2.len)
   llabel(,"R`'svg_sub(3)" ljust "680" ljust "5 W" ljust); dot
   {line to (P50,Here); dot(,dotrad_*3/2,1); 
     "-50 V" at last [].e ljust "2 A" ljust }
   line left_ Here.x-Br.W.x+dimen_/2; continue to (Here,Br.W) then to Br.W
   line from T80.TP right_ (Rs.x-T80.TP.x)/2 \
     then down_ T80.TP.y-B.y + (B.y-C2.end.y)/2
   continue to (Br.E+(dimen_/2,0),Here) 
   continue to (Here,C2.start) then to C2.start
   dot(at (T80.S2,T)-(dimen_*4/3,0))
   { line from (T80.S2,T) to Here-(dimen_/2,0)
    line dashed to Here-(dimen_/2,0) chop dimen_/10; In1: Here }
   { line from (T80.S2,B) to (Here-(dimen_/2,0),B)
    line dashed to Here-(dimen_/2,0) chop dimen_/10; In2: Here}
 F2: fuse(down_ h/2,D)
   llabel(,"F`'svg_sub(2)" ljust "100 svg_deg`'C" ljust "cutout" ljust)
 MOV: ebox(down_ to (Here,B))
   "MOV" at last [].e ljust "130 Vac" ljust "S20K130" ljust
   variable(,uNN,,dimen_/2)
   { arc dashed from 3rd last [].w-(2bp__,0) to 2nd last [].w-(2bp__,0) \
      rad dimen_ }
   dot(at MOV.end)

#SB: In1+(dimen_*4,dimen_/2)
#ST: SB+(0,h)
 SB: In2
 ST: In1
 T880: transformer(right_ dimen_*7/8,,,WD1) at (ST+SB)/2-(2*dimen_,0)
   line from T880.P2 to (T880.P2,SB) then to SB; dot(,dotrad_*3/2,1)
   line from T880.S2 to (T880.S2,ST) then to ST; dot(,dotrad_*3/2,1)
   line dashed from ST.e right_ dimen_/2 chop dimen_/10
   line dashed from SB.e right_ dimen_/2 chop dimen_/10
   dot(at (T880.P2,ST)+(dimen_,0))
 Cy: capacitor(down_ h/2); rlabel(C`'svg_sub(y),,2.2 nF); dot
   {line right_ dimen_/3; ground(,,F)}
   capacitor(down_ to (Here,SB)); rlabel(C`'svg_sub(y),,2.2 nF); dot
 Socket: pconnex(U,PF) at T880.w-(dimen_*3.5,0)
   line right_ dimen_/2 from Socket.G.e; ground(,,F)
   line from Socket.H.n to (Socket.H.n,ST); 
 F1: fuse(right_ dimen_,D); llabel(,"F1"); rlabel(,"6 A SB")
 TS: lswitch(right_ dimen_*3/4,,D); { line to (T880.S1,Here) then to T880.S1 }
   dot(at Here+(dimen_/2,0))
   { R1: resistor(down_ to (Here,SB)); rlabel(,"R`'svg_sub(1)" rjust \
      "1 M`'svg_ohm" rjust); dot }
   dot(at Here+(dimen_/2,0))
 Cx: capacitor(down_ to (Here,SB)); llabel(C`'svg_sub(x),,100 nF); dot
   line from Socket.N.s to (Socket.N.s,SB) then to (TS.start,SB)
 BS: lswitch(right_ TS.len,,D); { line dashed from TS to BS chop dimen_/3 }
   line to (T880.P1,Here) then to T880.P1
   "Qualtek 880-06/006" at Cx.start+(dimen_/2,dimen_/4)

command "</g>"
 ] #with .nw at Singlephase.sw+(0,-0.2)

.PE
