; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 -disable-output 2>&1 | FileCheck %s

; One side exit dominating the latch, exact backedge taken count is known.
define void @test_01() {
; CHECK-LABEL: 'test_01'
; CHECK-NEXT:  Determining loop execution counts for: @test_01
; CHECK-NEXT:  Loop %loop: <multiple exits> backedge-taken count is i32 50
; CHECK-NEXT:    exit count for loop: i32 50
; CHECK-NEXT:    exit count for backedge: i32 100
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 50
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 50
; CHECK-NEXT:    symbolic max exit count for loop: i32 50
; CHECK-NEXT:    symbolic max exit count for backedge: i32 100
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %backedge ]
  %side.cond = icmp slt i32 %iv, 50
  br i1 %side.cond, label %backedge, label %side.exit

backedge:
  %iv.next = add i32 %iv, 1
  %loop.cond = icmp slt i32 %iv, 100
  br i1 %loop.cond, label %loop, label %exit

exit:
  ret void

side.exit:
  ret void
}

define void @test_02(i1 %c) {
; CHECK-LABEL: 'test_02'
; CHECK-NEXT:  Determining loop execution counts for: @test_02
; CHECK-NEXT:  Loop %loop: <multiple exits> backedge-taken count is i32 50
; CHECK-NEXT:    exit count for merge: i32 50
; CHECK-NEXT:    exit count for backedge: i32 100
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 50
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 50
; CHECK-NEXT:    symbolic max exit count for merge: i32 50
; CHECK-NEXT:    symbolic max exit count for backedge: i32 100
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %backedge ]
  br i1 %c, label %if.true, label %if.false

if.true:
  br label %merge

if.false:
  br label %merge

merge:
  %side.cond = icmp slt i32 %iv, 50
  br i1 %side.cond, label %backedge, label %side.exit

backedge:
  %iv.next = add i32 %iv, 1
  %loop.cond = icmp slt i32 %iv, 100
  br i1 %loop.cond, label %loop, label %exit

exit:
  ret void

side.exit:
  ret void
}
