; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn -mcpu=verde -verify-machineinstrs < %s | FileCheck -check-prefixes=SI %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=VI %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn -mcpu=gfx900 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9 %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn -mcpu=gfx1010 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10 %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn -mcpu=gfx1100 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11 %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn -mcpu=gfx1200 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12 %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=r600 -mcpu=redwood < %s | FileCheck -check-prefixes=EG %s

; mul24 and mad24 are affected

define amdgpu_kernel void @test_mul_v2i32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; SI-LABEL: test_mul_v2i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_lo_u32 v1, v1, v3
; SI-NEXT:    v_mul_lo_u32 v0, v0, v2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_mul_v2i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_lo_u32 v1, v1, v3
; VI-NEXT:    v_mul_lo_u32 v0, v0, v2
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: test_mul_v2i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX9-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: test_mul_v2i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX10-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: test_mul_v2i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[8:11], 0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX11-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: test_mul_v2i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[8:11], null
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_lo_u32 v1, v1, v3
; GFX12-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: test_mul_v2i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MULLO_INT * T0.Y, T0.Y, T0.W,
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T0.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %b_ptr = getelementptr <2 x i32>, ptr addrspace(1) %in, i32 1
  %a = load <2 x i32>, ptr addrspace(1) %in
  %b = load <2 x i32>, ptr addrspace(1) %b_ptr
  %result = mul <2 x i32> %a, %b
  store <2 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_mul_v4i32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; SI-LABEL: v_mul_v4i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_lo_u32 v3, v3, v7
; SI-NEXT:    v_mul_lo_u32 v2, v2, v6
; SI-NEXT:    v_mul_lo_u32 v1, v1, v5
; SI-NEXT:    v_mul_lo_u32 v0, v0, v4
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_mul_v4i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; VI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_lo_u32 v3, v3, v7
; VI-NEXT:    v_mul_lo_u32 v2, v2, v6
; VI-NEXT:    v_mul_lo_u32 v1, v1, v5
; VI-NEXT:    v_mul_lo_u32 v0, v0, v4
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_mul_v4i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GFX9-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX9-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX9-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX9-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX9-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_mul_v4i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GFX10-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX10-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX10-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX10-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX10-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_mul_v4i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[8:11], 0
; GFX11-NEXT:    buffer_load_b128 v[4:7], off, s[8:11], 0 offset:16
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX11-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX11-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX11-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX11-NEXT:    buffer_store_b128 v[0:3], off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_mul_v4i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[8:11], null
; GFX12-NEXT:    buffer_load_b128 v[4:7], off, s[8:11], null offset:16
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_lo_u32 v3, v3, v7
; GFX12-NEXT:    v_mul_lo_u32 v2, v2, v6
; GFX12-NEXT:    v_mul_lo_u32 v1, v1, v5
; GFX12-NEXT:    v_mul_lo_u32 v0, v0, v4
; GFX12-NEXT:    buffer_store_b128 v[0:3], off, s[4:7], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_mul_v4i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 5, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     MULLO_INT * T0.W, T0.W, T1.W,
; EG-NEXT:     MULLO_INT * T0.Z, T0.Z, T1.Z,
; EG-NEXT:     MULLO_INT * T0.Y, T0.Y, T1.Y,
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T1.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %b_ptr = getelementptr <4 x i32>, ptr addrspace(1) %in, i32 1
  %a = load <4 x i32>, ptr addrspace(1) %in
  %b = load <4 x i32>, ptr addrspace(1) %b_ptr
  %result = mul <4 x i32> %a, %b
  store <4 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_trunc_i64_mul_to_i32(ptr addrspace(1) %out, i64 %a, i64 %b) {
; SI-LABEL: s_trunc_i64_mul_to_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mul_i32 s0, s3, s2
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_trunc_i64_mul_to_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s3, s[4:5], 0x34
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mul_i32 s0, s3, s2
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_trunc_i64_mul_to_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x34
; GFX9-NEXT:    ; kill: killed $sgpr4_sgpr5
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s0, s3, s2
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_trunc_i64_mul_to_i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dword s3, s[4:5], 0x34
; GFX10-NEXT:    ; kill: killed $sgpr4_sgpr5
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mul_i32 s2, s3, s2
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_trunc_i64_mul_to_i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s3, s[4:5], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mul_i32 s2, s3, s2
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_trunc_i64_mul_to_i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s3, s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mul_i32 s2, s3, s2
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: s_trunc_i64_mul_to_i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MULLO_INT * T1.X, KC0[3].Y, KC0[2].W,
entry:
  %mul = mul i64 %b, %a
  %trunc = trunc i64 %mul to i32
  store i32 %trunc, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v_trunc_i64_mul_to_i32(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr) nounwind {
; SI-LABEL: v_trunc_i64_mul_to_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s14, s6
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; SI-NEXT:    buffer_load_dword v1, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_lo_u32 v0, v1, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_trunc_i64_mul_to_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s14, s6
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s12, s2
; VI-NEXT:    s_mov_b32 s13, s3
; VI-NEXT:    s_mov_b32 s15, s7
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; VI-NEXT:    buffer_load_dword v1, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_lo_u32 v0, v1, v0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_trunc_i64_mul_to_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s14, s6
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s2
; GFX9-NEXT:    s_mov_b32 s13, s3
; GFX9-NEXT:    s_mov_b32 s15, s7
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; GFX9-NEXT:    buffer_load_dword v1, off, s[8:11], 0
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_trunc_i64_mul_to_i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s14, s6
; GFX10-NEXT:    s_mov_b32 s15, s7
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s12, s2
; GFX10-NEXT:    s_mov_b32 s13, s3
; GFX10-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; GFX10-NEXT:    buffer_load_dword v1, off, s[8:11], 0
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX10-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_trunc_i64_mul_to_i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s14, s10
; GFX11-NEXT:    s_mov_b32 s15, s11
; GFX11-NEXT:    s_mov_b32 s6, s10
; GFX11-NEXT:    s_mov_b32 s7, s11
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s2
; GFX11-NEXT:    s_mov_b32 s13, s3
; GFX11-NEXT:    buffer_load_b32 v0, off, s[12:15], 0
; GFX11-NEXT:    buffer_load_b32 v1, off, s[4:7], 0
; GFX11-NEXT:    s_mov_b32 s8, s0
; GFX11-NEXT:    s_mov_b32 s9, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX11-NEXT:    buffer_store_b32 v0, off, s[8:11], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_trunc_i64_mul_to_i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_mov_b32 s10, -1
; GFX12-NEXT:    s_mov_b32 s11, 0x31016000
; GFX12-NEXT:    s_mov_b32 s14, s10
; GFX12-NEXT:    s_mov_b32 s15, s11
; GFX12-NEXT:    s_mov_b32 s6, s10
; GFX12-NEXT:    s_mov_b32 s7, s11
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s12, s2
; GFX12-NEXT:    s_mov_b32 s13, s3
; GFX12-NEXT:    buffer_load_b32 v0, off, s[12:15], null
; GFX12-NEXT:    buffer_load_b32 v1, off, s[4:7], null
; GFX12-NEXT:    s_mov_b32 s8, s0
; GFX12-NEXT:    s_mov_b32 s9, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_lo_u32 v0, v1, v0
; GFX12-NEXT:    buffer_store_b32 v0, off, s[8:11], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_trunc_i64_mul_to_i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 1, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 2, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T1.X, T1.X, 0, #1
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV T0.X, KC0[2].Z,
; EG-NEXT:     MOV * T1.X, KC0[2].W,
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T1.X, T0.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %a = load i64, ptr addrspace(1) %aptr, align 8
  %b = load i64, ptr addrspace(1) %bptr, align 8
  %mul = mul i64 %b, %a
  %trunc = trunc i64 %mul to i32
  store i32 %trunc, ptr addrspace(1) %out, align 8
  ret void
}

; This 64-bit multiply should just use MUL_HI and MUL_LO, since the top
; 32-bits of both arguments are sign bits.

define amdgpu_kernel void @mul64_sext_c(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: mul64_sext_c:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    v_mov_b32_e32 v0, 0x50
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mul_hi_i32 v1, s6, v0
; SI-NEXT:    s_mulk_i32 s6, 0x50
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: mul64_sext_c:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v0, 0x50
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mad_i64_i32 v[0:1], s[2:3], s2, v0, 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_nop 2
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: mul64_sext_c:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_hi_i32 s4, s6, 0x50
; GFX9-NEXT:    s_mulk_i32 s6, 0x50
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul64_sext_c:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mul_i32 s3, s2, 0x50
; GFX10-NEXT:    s_mul_hi_i32 s2, s2, 0x50
; GFX10-NEXT:    v_mov_b32_e32 v0, s3
; GFX10-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: mul64_sext_c:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mul_i32 s3, s2, 0x50
; GFX11-NEXT:    s_mul_hi_i32 s2, s2, 0x50
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: mul64_sext_c:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_ashr_i32 s3, s2, 31
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_mul_u64 s[4:5], s[2:3], 0x50
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: mul64_sext_c:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MULHI_INT * T0.Y, KC0[2].Z, literal.x,
; EG-NEXT:    80(1.121039e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, KC0[2].Z, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
entry:
  %0 = sext i32 %in to i64
  %1 = mul i64 %0, 80
  store i64 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @mul64_zext_c(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: mul64_zext_c:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    v_mov_b32_e32 v0, 0x50
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mul_hi_u32 v1, s6, v0
; SI-NEXT:    s_mulk_i32 s6, 0x50
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: mul64_zext_c:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v0, 0x50
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], s2, v0, 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_nop 2
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: mul64_zext_c:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_hi_u32 s4, s6, 0x50
; GFX9-NEXT:    s_mulk_i32 s6, 0x50
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul64_zext_c:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mul_i32 s3, s2, 0x50
; GFX10-NEXT:    s_mul_hi_u32 s2, s2, 0x50
; GFX10-NEXT:    v_mov_b32_e32 v0, s3
; GFX10-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: mul64_zext_c:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mul_i32 s3, s2, 0x50
; GFX11-NEXT:    s_mul_hi_u32 s2, s2, 0x50
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: mul64_zext_c:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b96 s[0:2], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s3, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mul_u64 s[4:5], s[2:3], 0x50
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: mul64_zext_c:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MULHI * T0.Y, KC0[2].Z, literal.x,
; EG-NEXT:    80(1.121039e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, KC0[2].Z, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
entry:
  %0 = zext i32 %in to i64
  %1 = mul i64 %0, 80
  store i64 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_mul64_sext_c(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; SI-LABEL: v_mul64_sext_c:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_movk_i32 s2, 0x50
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_hi_i32 v1, v0, s2
; SI-NEXT:    v_mul_lo_u32 v0, v0, s2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_mul64_sext_c:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-NEXT:    s_movk_i32 s2, 0x50
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mad_i64_i32 v[0:1], s[2:3], v0, s2, 0
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_mul64_sext_c:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-NEXT:    s_movk_i32 s2, 0x50
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_hi_i32 v1, v0, s2
; GFX9-NEXT:    v_mul_lo_u32 v0, v0, s2
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_mul64_sext_c:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_hi_i32 v1, 0x50, v0
; GFX10-NEXT:    v_mul_lo_u32 v0, 0x50, v0
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_mul64_sext_c:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_hi_i32 v1, 0x50, v0
; GFX11-NEXT:    v_mul_lo_u32 v0, 0x50, v0
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_mul64_sext_c:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    buffer_load_b32 v0, off, s[8:11], null
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_hi_i32 v1, 0x50, v0
; GFX12-NEXT:    v_mul_lo_u32 v0, 0x50, v0
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_mul64_sext_c:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MULHI_INT * T0.Y, T0.X, literal.x,
; EG-NEXT:    80(1.121039e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
entry:
  %val = load i32, ptr addrspace(1) %in, align 4
  %ext = sext i32 %val to i64
  %mul = mul i64 %ext, 80
  store i64 %mul, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v_mul64_zext_c(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; SI-LABEL: v_mul64_zext_c:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_movk_i32 s2, 0x50
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_hi_u32 v1, v0, s2
; SI-NEXT:    v_mul_lo_u32 v0, v0, s2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_mul64_zext_c:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-NEXT:    s_movk_i32 s2, 0x50
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v0, s2, 0
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_mul64_zext_c:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-NEXT:    s_movk_i32 s2, 0x50
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_hi_u32 v1, v0, s2
; GFX9-NEXT:    v_mul_lo_u32 v0, v0, s2
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_mul64_zext_c:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_hi_u32 v1, 0x50, v0
; GFX10-NEXT:    v_mul_lo_u32 v0, 0x50, v0
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_mul64_zext_c:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_hi_u32 v1, 0x50, v0
; GFX11-NEXT:    v_mul_lo_u32 v0, 0x50, v0
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_mul64_zext_c:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    buffer_load_b32 v0, off, s[8:11], null
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_hi_u32 v1, 0x50, v0
; GFX12-NEXT:    v_mul_lo_u32 v0, 0x50, v0
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_mul64_zext_c:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MULHI * T0.Y, T0.X, literal.x,
; EG-NEXT:    80(1.121039e-43), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 80(1.121039e-43)
entry:
  %val = load i32, ptr addrspace(1) %in, align 4
  %ext = zext i32 %val to i64
  %mul = mul i64 %ext, 80
  store i64 %mul, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v_mul64_sext_inline_imm(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; SI-LABEL: v_mul64_sext_inline_imm:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_hi_i32 v1, v0, 9
; SI-NEXT:    v_mul_lo_u32 v0, v0, 9
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_mul64_sext_inline_imm:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mad_i64_i32 v[0:1], s[2:3], v0, 9, 0
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_mul64_sext_inline_imm:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_hi_i32 v1, v0, 9
; GFX9-NEXT:    v_mul_lo_u32 v0, v0, 9
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_mul64_sext_inline_imm:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_hi_i32 v1, v0, 9
; GFX10-NEXT:    v_mul_lo_u32 v0, v0, 9
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_mul64_sext_inline_imm:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_hi_i32 v1, v0, 9
; GFX11-NEXT:    v_mul_lo_u32 v0, v0, 9
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_mul64_sext_inline_imm:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    buffer_load_b32 v0, off, s[8:11], null
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_hi_i32 v1, 9, v0
; GFX12-NEXT:    v_mul_lo_u32 v0, 9, v0
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_mul64_sext_inline_imm:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 4, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MULHI_INT * T0.Y, T0.X, literal.x,
; EG-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, literal.y,
; EG-NEXT:    2(2.802597e-45), 9(1.261169e-44)
entry:
  %val = load i32, ptr addrspace(1) %in, align 4
  %ext = sext i32 %val to i64
  %mul = mul i64 %ext, 9
  store i64 %mul, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @s_mul_i32(ptr addrspace(1) %out, [8 x i32], i32 %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: s_mul_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s6, s[4:5], 0x13
; SI-NEXT:    s_load_dword s7, s[4:5], 0x1c
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mul_i32 s4, s6, s7
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_mul_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s6, s[4:5], 0x4c
; VI-NEXT:    s_load_dword s7, s[4:5], 0x70
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mul_i32 s4, s6, s7
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_mul_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x4c
; GFX9-NEXT:    s_load_dword s7, s[4:5], 0x70
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s4, s6, s7
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_mul_i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    s_load_dword s2, s[4:5], 0x4c
; GFX10-NEXT:    s_load_dword s3, s[4:5], 0x70
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mul_i32 s2, s2, s3
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_mul_i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x4c
; GFX11-NEXT:    s_load_b32 s3, s[4:5], 0x70
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mul_i32 s2, s2, s3
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_mul_i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    s_load_b32 s2, s[4:5], 0x4c
; GFX12-NEXT:    s_load_b32 s3, s[4:5], 0x70
; GFX12-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mul_i32 s2, s2, s3
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: s_mul_i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MULLO_INT * T1.X, KC0[4].Z, KC0[6].W,
entry:
  %mul = mul i32 %a, %b
  store i32 %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_mul_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; SI-LABEL: v_mul_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_lo_u32 v0, v0, v1
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_mul_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_lo_u32 v0, v0, v1
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_mul_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_mul_i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_mul_i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_load_b64 v[0:1], off, s[8:11], 0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX11-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_mul_i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    buffer_load_b64 v[0:1], off, s[8:11], null
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX12-NEXT:    buffer_store_b32 v0, off, s[4:7], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_mul_i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 2, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     LSHR T1.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T0.Y,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %b_ptr = getelementptr i32, ptr addrspace(1) %in, i32 1
  %a = load i32, ptr addrspace(1) %in
  %b = load i32, ptr addrspace(1) %b_ptr
  %result = mul i32 %a, %b
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_mul_i1(ptr addrspace(1) %out, [8 x i32], i1 %a, [8 x i32], i1 %b) nounwind {
; SI-LABEL: s_mul_i1:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s6, s[4:5], 0x13
; SI-NEXT:    s_load_dword s7, s[4:5], 0x1c
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mul_i32 s6, s6, s7
; SI-NEXT:    s_and_b32 s4, s6, 1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_mul_i1:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s6, s[4:5], 0x4c
; VI-NEXT:    s_load_dword s7, s[4:5], 0x70
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mul_i32 s6, s6, s7
; VI-NEXT:    s_and_b32 s4, s6, 1
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_mul_i1:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x4c
; GFX9-NEXT:    s_load_dword s7, s[4:5], 0x70
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s4, s6, 1
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_mul_i1:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    s_load_dword s2, s[4:5], 0x4c
; GFX10-NEXT:    s_load_dword s3, s[4:5], 0x70
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mul_i32 s2, s2, s3
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    s_and_b32 s2, s2, 1
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_mul_i1:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x4c
; GFX11-NEXT:    s_load_b32 s3, s[4:5], 0x70
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mul_i32 s2, s2, s3
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_and_b32 s2, s2, 1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_mul_i1:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    s_load_b32 s2, s[4:5], 0x4c
; GFX12-NEXT:    s_load_b32 s3, s[4:5], 0x70
; GFX12-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mul_i32 s2, s2, s3
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    s_and_b32 s2, s2, 1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: s_mul_i1:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @10, KC0[], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 12, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T1.X, T0.X, 72, #3
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 108, #3
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, 0.0,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T1.X, T0.X,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T1.W, PS, 1,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %mul = mul i1 %a, %b
  store i1 %mul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_mul_i1(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; SI-LABEL: v_mul_i1:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; SI-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0 offset:4
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_lo_u32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 1, v0
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_mul_i1:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; VI-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0 offset:4
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_lo_u32 v0, v0, v1
; VI-NEXT:    v_and_b32_e32 v0, 1, v0
; VI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_mul_i1:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX9-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0 offset:4
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_mul_i1:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; GFX10-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0 offset:4
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX10-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_mul_i1:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_load_u8 v0, off, s[8:11], 0
; GFX11-NEXT:    buffer_load_u8 v1, off, s[8:11], 0 offset:4
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    buffer_store_b8 v0, off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_mul_i1:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    buffer_load_u8 v0, off, s[8:11], null
; GFX12-NEXT:    buffer_load_u8 v1, off, s[8:11], null offset:4
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_lo_u32 v0, v0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX12-NEXT:    buffer_store_b8 v0, off, s[4:7], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_mul_i1:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 12, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T1.X, T0.X, 4, #1
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T1.X,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T1.W, PS, 1,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %b_ptr = getelementptr i32, ptr addrspace(1) %in, i32 1
  %a = load i1, ptr addrspace(1) %in
  %b = load i1, ptr addrspace(1) %b_ptr
  %result = mul i1 %a, %b
  store i1 %result, ptr addrspace(1) %out
  ret void
}

; A standard 64-bit multiply.  The expansion should be around 6 instructions.
; It would be difficult to match the expansion correctly without writing
; a really complicated list of FileCheck expressions.  I don't want
; to confuse people who may 'break' this test with a correct optimization,
; so this test just uses FUNC-LABEL to make sure the compiler does not
; crash with a 'failed to select' error.

define amdgpu_kernel void @s_mul_i64(ptr addrspace(1) %out, i64 %a, i64 %b) nounwind {
; SI-LABEL: s_mul_i64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    v_mul_hi_u32 v0, s2, v0
; SI-NEXT:    s_mul_i32 s0, s2, s9
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; SI-NEXT:    s_mul_i32 s0, s3, s8
; SI-NEXT:    v_add_i32_e32 v1, vcc, s0, v0
; SI-NEXT:    s_mul_i32 s0, s2, s8
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_mul_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[10:11], s2, v0, 0
; VI-NEXT:    s_mul_i32 s0, s2, s9
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_add_u32_e32 v1, vcc, s0, v1
; VI-NEXT:    s_mul_i32 s0, s3, s8
; VI-NEXT:    v_add_u32_e32 v1, vcc, s0, v1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_mul_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_mul_i32 s0, s2, s9
; GFX9-NEXT:    s_mul_hi_u32 s1, s2, s8
; GFX9-NEXT:    s_add_i32 s0, s1, s0
; GFX9-NEXT:    s_mul_i32 s1, s3, s8
; GFX9-NEXT:    s_add_i32 s0, s0, s1
; GFX9-NEXT:    s_mul_i32 s1, s2, s8
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_mul_i64:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mul_i32 s4, s2, s7
; GFX10-NEXT:    s_mul_hi_u32 s5, s2, s6
; GFX10-NEXT:    s_mul_i32 s3, s3, s6
; GFX10-NEXT:    s_add_i32 s4, s5, s4
; GFX10-NEXT:    s_mul_i32 s2, s2, s6
; GFX10-NEXT:    s_add_i32 s4, s4, s3
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_mul_i64:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mul_i32 s5, s2, s5
; GFX11-NEXT:    s_mul_hi_u32 s6, s2, s4
; GFX11-NEXT:    s_mul_i32 s3, s3, s4
; GFX11-NEXT:    s_add_i32 s5, s6, s5
; GFX11-NEXT:    s_mul_i32 s2, s2, s4
; GFX11-NEXT:    s_add_i32 s5, s5, s3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_mul_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mul_u64 s[4:5], s[2:3], s[4:5]
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: s_mul_i64:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MULHI * T0.X, KC0[2].W, KC0[3].Y,
; EG-NEXT:     MULLO_INT * T0.Y, KC0[2].W, KC0[3].Z,
; EG-NEXT:     ADD_INT T0.W, T0.X, PS,
; EG-NEXT:     MULLO_INT * T0.X, KC0[3].X, KC0[3].Y,
; EG-NEXT:     ADD_INT * T0.Y, PV.W, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MULLO_INT * T0.X, KC0[2].W, KC0[3].Y,
entry:
  %mul = mul i64 %a, %b
  store i64 %mul, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v_mul_i64(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr) {
; SI-LABEL: v_mul_i64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s14, s6
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    buffer_load_dwordx2 v[2:3], off, s[12:15], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_lo_u32 v1, v2, v1
; SI-NEXT:    v_mul_hi_u32 v4, v2, v0
; SI-NEXT:    v_mul_lo_u32 v3, v3, v0
; SI-NEXT:    v_mul_lo_u32 v0, v2, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; SI-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_mul_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s12, s2
; VI-NEXT:    s_mov_b32 s13, s3
; VI-NEXT:    s_mov_b32 s14, s6
; VI-NEXT:    s_mov_b32 s15, s7
; VI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; VI-NEXT:    buffer_load_dwordx2 v[2:3], off, s[12:15], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_lo_u32 v4, v2, v1
; VI-NEXT:    v_mad_u64_u32 v[1:2], s[2:3], v2, v0, 0
; VI-NEXT:    v_mul_lo_u32 v0, v3, v0
; VI-NEXT:    v_add_u32_e32 v2, vcc, v4, v2
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v0
; VI-NEXT:    buffer_store_dwordx2 v[1:2], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_mul_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s2
; GFX9-NEXT:    s_mov_b32 s13, s3
; GFX9-NEXT:    s_mov_b32 s14, s6
; GFX9-NEXT:    s_mov_b32 s15, s7
; GFX9-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GFX9-NEXT:    buffer_load_dwordx2 v[2:3], off, s[12:15], 0
; GFX9-NEXT:    s_mov_b32 s4, s0
; GFX9-NEXT:    s_mov_b32 s5, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX9-NEXT:    v_mul_hi_u32 v4, v2, v0
; GFX9-NEXT:    v_mul_lo_u32 v3, v3, v0
; GFX9-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX9-NEXT:    v_add_u32_e32 v1, v4, v1
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v3
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_mul_i64:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_mov_b32 s14, s6
; GFX10-NEXT:    s_mov_b32 s15, s7
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s12, s2
; GFX10-NEXT:    s_mov_b32 s13, s3
; GFX10-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GFX10-NEXT:    buffer_load_dwordx2 v[2:3], off, s[12:15], 0
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX10-NEXT:    v_mul_hi_u32 v4, v2, v0
; GFX10-NEXT:    v_mul_lo_u32 v3, v3, v0
; GFX10-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, v4, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v1, v1, v3
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_mul_i64:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-NEXT:    s_mov_b32 s10, -1
; GFX11-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, s10
; GFX11-NEXT:    s_mov_b32 s7, s11
; GFX11-NEXT:    s_mov_b32 s14, s10
; GFX11-NEXT:    s_mov_b32 s15, s11
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s12, s2
; GFX11-NEXT:    s_mov_b32 s13, s3
; GFX11-NEXT:    buffer_load_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    buffer_load_b64 v[2:3], off, s[12:15], 0
; GFX11-NEXT:    s_mov_b32 s8, s0
; GFX11-NEXT:    s_mov_b32 s9, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mul_lo_u32 v1, v2, v1
; GFX11-NEXT:    v_mul_hi_u32 v4, v2, v0
; GFX11-NEXT:    v_mul_lo_u32 v3, v3, v0
; GFX11-NEXT:    v_mul_lo_u32 v0, v2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v4, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v1, v3
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[8:11], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_mul_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_mov_b32 s10, -1
; GFX12-NEXT:    s_mov_b32 s11, 0x31016000
; GFX12-NEXT:    s_mov_b32 s6, s10
; GFX12-NEXT:    s_mov_b32 s7, s11
; GFX12-NEXT:    s_mov_b32 s14, s10
; GFX12-NEXT:    s_mov_b32 s15, s11
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s12, s2
; GFX12-NEXT:    s_mov_b32 s13, s3
; GFX12-NEXT:    buffer_load_b64 v[0:1], off, s[4:7], null
; GFX12-NEXT:    buffer_load_b64 v[2:3], off, s[12:15], null
; GFX12-NEXT:    s_mov_b32 s8, s0
; GFX12-NEXT:    s_mov_b32 s9, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mul_lo_u32 v3, v0, v3
; GFX12-NEXT:    v_mul_lo_u32 v1, v1, v2
; GFX12-NEXT:    v_mul_hi_u32 v4, v0, v2
; GFX12-NEXT:    v_mul_lo_u32 v0, v0, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_nc_u32_e32 v1, v3, v1
; GFX12-NEXT:    v_add_nc_u32_e32 v1, v1, v4
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[8:11], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_mul_i64:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 1, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 7, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T2.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T1.XY, T1.X, 0, #1
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV T0.X, KC0[2].Z,
; EG-NEXT:     MOV * T1.X, KC0[2].W,
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MULHI * T0.Z, T0.X, T1.X,
; EG-NEXT:     MULLO_INT * T0.W, T0.X, T1.Y,
; EG-NEXT:     ADD_INT T0.W, T0.Z, PS,
; EG-NEXT:     MULLO_INT * T0.Y, T0.Y, T1.X,
; EG-NEXT:     ADD_INT * T0.Y, PV.W, PS,
; EG-NEXT:     LSHR T2.X, KC0[2].Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T1.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %a = load i64, ptr addrspace(1) %aptr, align 8
  %b = load i64, ptr addrspace(1) %bptr, align 8
  %mul = mul i64 %a, %b
  store i64 %mul, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @mul32_in_branch(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %a, i32 %b, i32 %c) {
; SI-LABEL: mul32_in_branch:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s0, 0
; SI-NEXT:    s_cbranch_scc0 .LBB15_2
; SI-NEXT:  ; %bb.1: ; %else
; SI-NEXT:    s_mul_i32 s8, s0, s1
; SI-NEXT:    s_mov_b64 s[6:7], 0
; SI-NEXT:    s_branch .LBB15_3
; SI-NEXT:  .LBB15_2:
; SI-NEXT:    s_mov_b64 s[6:7], -1
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:  .LBB15_3: ; %Flow
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_andn2_b64 vcc, exec, s[6:7]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 vcc, vcc
; SI-NEXT:    s_cbranch_vccnz .LBB15_5
; SI-NEXT:  ; %bb.4: ; %if
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; SI-NEXT:    s_branch .LBB15_6
; SI-NEXT:  .LBB15_5:
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:  .LBB15_6: ; %endif
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: mul32_in_branch:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s0, 0
; VI-NEXT:    s_cbranch_scc0 .LBB15_2
; VI-NEXT:  ; %bb.1: ; %else
; VI-NEXT:    s_mul_i32 s8, s0, s1
; VI-NEXT:    s_mov_b64 s[6:7], 0
; VI-NEXT:    s_branch .LBB15_3
; VI-NEXT:  .LBB15_2:
; VI-NEXT:    s_mov_b64 s[6:7], -1
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:  .LBB15_3: ; %Flow
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_andn2_b64 vcc, exec, s[6:7]
; VI-NEXT:    s_cbranch_vccnz .LBB15_5
; VI-NEXT:  ; %bb.4: ; %if
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; VI-NEXT:    s_branch .LBB15_6
; VI-NEXT:  .LBB15_5:
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:  .LBB15_6: ; %endif
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: mul32_in_branch:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s0, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB15_2
; GFX9-NEXT:  ; %bb.1: ; %else
; GFX9-NEXT:    s_mul_i32 s8, s0, s1
; GFX9-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-NEXT:    s_branch .LBB15_3
; GFX9-NEXT:  .LBB15_2:
; GFX9-NEXT:    s_mov_b64 s[6:7], -1
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:  .LBB15_3: ; %Flow
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_andn2_b64 vcc, exec, s[6:7]
; GFX9-NEXT:    s_cbranch_vccnz .LBB15_5
; GFX9-NEXT:  ; %bb.4: ; %if
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, s2
; GFX9-NEXT:    s_mov_b32 s5, s3
; GFX9-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_branch .LBB15_6
; GFX9-NEXT:  .LBB15_5:
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:  .LBB15_6: ; %endif
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul32_in_branch:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x34
; GFX10-NEXT:    s_mov_b32 s6, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cmp_lg_u32 s0, 0
; GFX10-NEXT:    s_cbranch_scc0 .LBB15_2
; GFX10-NEXT:  ; %bb.1: ; %else
; GFX10-NEXT:    s_mul_i32 s7, s0, s1
; GFX10-NEXT:    s_branch .LBB15_3
; GFX10-NEXT:  .LBB15_2:
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    ; implicit-def: $sgpr7
; GFX10-NEXT:  .LBB15_3: ; %Flow
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    s_andn2_b32 vcc_lo, exec_lo, s6
; GFX10-NEXT:    s_cbranch_vccnz .LBB15_5
; GFX10-NEXT:  ; %bb.4: ; %if
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s4, s2
; GFX10-NEXT:    s_mov_b32 s5, s3
; GFX10-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; GFX10-NEXT:    s_branch .LBB15_6
; GFX10-NEXT:  .LBB15_5:
; GFX10-NEXT:    v_mov_b32_e32 v0, s7
; GFX10-NEXT:  .LBB15_6: ; %endif
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: mul32_in_branch:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x34
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB15_2
; GFX11-NEXT:  ; %bb.1: ; %else
; GFX11-NEXT:    s_mul_i32 s7, s0, s1
; GFX11-NEXT:    s_branch .LBB15_3
; GFX11-NEXT:  .LBB15_2:
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:  .LBB15_3: ; %Flow
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB15_5
; GFX11-NEXT:  ; %bb.4: ; %if
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s4, s2
; GFX11-NEXT:    s_mov_b32 s5, s3
; GFX11-NEXT:    buffer_load_b32 v0, off, s[4:7], 0
; GFX11-NEXT:    s_branch .LBB15_6
; GFX11-NEXT:  .LBB15_5:
; GFX11-NEXT:    v_mov_b32_e32 v0, s7
; GFX11-NEXT:  .LBB15_6: ; %endif
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: mul32_in_branch:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b64 s[0:1], s[4:5], 0x34
; GFX12-NEXT:    s_mov_b32 s6, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_cmp_lg_u32 s0, 0
; GFX12-NEXT:    s_cbranch_scc0 .LBB15_2
; GFX12-NEXT:  ; %bb.1: ; %else
; GFX12-NEXT:    s_mul_i32 s7, s0, s1
; GFX12-NEXT:    s_branch .LBB15_3
; GFX12-NEXT:  .LBB15_2:
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    ; implicit-def: $sgpr7
; GFX12-NEXT:  .LBB15_3: ; %Flow
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX12-NEXT:    s_cbranch_vccnz .LBB15_5
; GFX12-NEXT:  ; %bb.4: ; %if
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s4, s2
; GFX12-NEXT:    s_mov_b32 s5, s3
; GFX12-NEXT:    buffer_load_b32 v0, off, s[4:7], null
; GFX12-NEXT:    s_branch .LBB15_6
; GFX12-NEXT:  .LBB15_5:
; GFX12-NEXT:    v_mov_b32_e32 v0, s7
; GFX12-NEXT:  .LBB15_6: ; %endif
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: mul32_in_branch:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU_PUSH_BEFORE 3, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    JUMP @3 POP:1
; EG-NEXT:    ALU_POP_AFTER 4, @18, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU_PUSH_BEFORE 2, @23, KC0[CB0:0-32], KC1[]
; EG-NEXT:    JUMP @8 POP:1
; EG-NEXT:    ALU 0, @26, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @12
; EG-NEXT:    POP @8 POP:1
; EG-NEXT:    ALU 1, @27, KC0[], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV T0.W, literal.x,
; EG-NEXT:     SETNE_INT * T1.W, KC0[2].W, 0.0,
; EG-NEXT:    1(1.401298e-45), 0(0.000000e+00)
; EG-NEXT:     PRED_SETNE_INT * ExecMask,PredicateBit (MASKED), PS, 0.0,
; EG-NEXT:    ALU clause starting at 18:
; EG-NEXT:     MOV T1.W, KC0[2].W,
; EG-NEXT:     MOV * T2.W, KC0[3].X,
; EG-NEXT:     MOV T0.W, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, PV.W, PS,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 23:
; EG-NEXT:     MOV T1.W, KC0[2].Y,
; EG-NEXT:     SETE_INT * T0.W, T0.W, 0.0,
; EG-NEXT:     PRED_SETE_INT * ExecMask,PredicateBit (MASKED), PS, 0.0,
; EG-NEXT:    ALU clause starting at 26:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 27:
; EG-NEXT:     LSHR * T1.X, T1.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %0 = icmp eq i32 %a, 0
  br i1 %0, label %if, label %else

if:
  %1 = load i32, ptr addrspace(1) %in
  br label %endif

else:
  %2 = mul i32 %a, %b
  br label %endif

endif:
  %3 = phi i32 [%1, %if], [%2, %else]
  store i32 %3, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @mul64_in_branch(ptr addrspace(1) %out, ptr addrspace(1) %in, i64 %a, i64 %b, i64 %c) {
; SI-LABEL: mul64_in_branch:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u64_e64 s[10:11], s[4:5], 0
; SI-NEXT:    s_and_b64 vcc, exec, s[10:11]
; SI-NEXT:    s_cbranch_vccz .LBB16_4
; SI-NEXT:  ; %bb.1: ; %else
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mul_hi_u32 v0, s4, v0
; SI-NEXT:    s_mul_i32 s7, s4, s7
; SI-NEXT:    s_mul_i32 s5, s5, s6
; SI-NEXT:    s_mul_i32 s4, s4, s6
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s5, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    s_andn2_b64 vcc, exec, s[8:9]
; SI-NEXT:    s_cbranch_vccnz .LBB16_3
; SI-NEXT:  .LBB16_2: ; %if
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s2
; SI-NEXT:    s_mov_b32 s5, s3
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:  .LBB16_3: ; %endif
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
; SI-NEXT:  .LBB16_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB16_2
;
; VI-LABEL: mul64_in_branch:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u64 s[4:5], 0
; VI-NEXT:    s_cbranch_scc0 .LBB16_4
; VI-NEXT:  ; %bb.1: ; %else
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[10:11], s4, v0, 0
; VI-NEXT:    s_mul_i32 s4, s4, s7
; VI-NEXT:    v_add_u32_e32 v1, vcc, s4, v1
; VI-NEXT:    s_mul_i32 s4, s5, s6
; VI-NEXT:    v_add_u32_e32 v1, vcc, s4, v1
; VI-NEXT:    s_andn2_b64 vcc, exec, s[8:9]
; VI-NEXT:    s_cbranch_vccnz .LBB16_3
; VI-NEXT:  .LBB16_2: ; %if
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:  .LBB16_3: ; %endif
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
; VI-NEXT:  .LBB16_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_branch .LBB16_2
;
; GFX9-LABEL: mul64_in_branch:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u64 s[12:13], 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB16_3
; GFX9-NEXT:  ; %bb.1: ; %else
; GFX9-NEXT:    s_mul_i32 s2, s12, s15
; GFX9-NEXT:    s_mul_hi_u32 s3, s12, s14
; GFX9-NEXT:    s_add_i32 s2, s3, s2
; GFX9-NEXT:    s_mul_i32 s3, s13, s14
; GFX9-NEXT:    s_add_i32 s3, s2, s3
; GFX9-NEXT:    s_mul_i32 s2, s12, s14
; GFX9-NEXT:    s_andn2_b64 vcc, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_vccnz .LBB16_4
; GFX9-NEXT:  .LBB16_2: ; %if
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_mov_b32 s0, s10
; GFX9-NEXT:    s_mov_b32 s1, s11
; GFX9-NEXT:    buffer_load_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_branch .LBB16_5
; GFX9-NEXT:  .LBB16_3:
; GFX9-NEXT:    ; implicit-def: $sgpr2_sgpr3
; GFX9-NEXT:    s_branch .LBB16_2
; GFX9-NEXT:  .LBB16_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:  .LBB16_5: ; %endif
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: mul64_in_branch:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cmp_lg_u64 s[12:13], 0
; GFX10-NEXT:    s_cbranch_scc0 .LBB16_3
; GFX10-NEXT:  ; %bb.1: ; %else
; GFX10-NEXT:    s_mul_i32 s0, s12, s15
; GFX10-NEXT:    s_mul_hi_u32 s1, s12, s14
; GFX10-NEXT:    s_mul_i32 s2, s13, s14
; GFX10-NEXT:    s_add_i32 s0, s1, s0
; GFX10-NEXT:    s_add_i32 s1, s0, s2
; GFX10-NEXT:    s_mul_i32 s0, s12, s14
; GFX10-NEXT:    s_cbranch_execnz .LBB16_4
; GFX10-NEXT:  .LBB16_2: ; %if
; GFX10-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-NEXT:    s_mov_b32 s2, -1
; GFX10-NEXT:    s_mov_b32 s0, s10
; GFX10-NEXT:    s_mov_b32 s1, s11
; GFX10-NEXT:    buffer_load_dwordx2 v[0:1], off, s[0:3], 0
; GFX10-NEXT:    s_branch .LBB16_5
; GFX10-NEXT:  .LBB16_3:
; GFX10-NEXT:    ; implicit-def: $sgpr0_sgpr1
; GFX10-NEXT:    s_branch .LBB16_2
; GFX10-NEXT:  .LBB16_4:
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:  .LBB16_5: ; %endif
; GFX10-NEXT:    s_mov_b32 s11, 0x31016000
; GFX10-NEXT:    s_mov_b32 s10, -1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: mul64_in_branch:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB16_3
; GFX11-NEXT:  ; %bb.1: ; %else
; GFX11-NEXT:    s_mul_i32 s7, s4, s7
; GFX11-NEXT:    s_mul_hi_u32 s8, s4, s6
; GFX11-NEXT:    s_mul_i32 s5, s5, s6
; GFX11-NEXT:    s_add_i32 s7, s8, s7
; GFX11-NEXT:    s_mul_i32 s4, s4, s6
; GFX11-NEXT:    s_add_i32 s5, s7, s5
; GFX11-NEXT:    s_cbranch_execnz .LBB16_4
; GFX11-NEXT:  .LBB16_2: ; %if
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s4, s2
; GFX11-NEXT:    s_mov_b32 s5, s3
; GFX11-NEXT:    buffer_load_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_branch .LBB16_5
; GFX11-NEXT:  .LBB16_3:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB16_2
; GFX11-NEXT:  .LBB16_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:  .LBB16_5: ; %endif
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: mul64_in_branch:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_cmp_lg_u64 s[4:5], 0
; GFX12-NEXT:    s_cbranch_scc0 .LBB16_3
; GFX12-NEXT:  ; %bb.1: ; %else
; GFX12-NEXT:    s_mul_u64 s[4:5], s[4:5], s[6:7]
; GFX12-NEXT:    s_cbranch_execnz .LBB16_4
; GFX12-NEXT:  .LBB16_2: ; %if
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s4, s2
; GFX12-NEXT:    s_mov_b32 s5, s3
; GFX12-NEXT:    buffer_load_b64 v[0:1], off, s[4:7], null
; GFX12-NEXT:    s_branch .LBB16_5
; GFX12-NEXT:  .LBB16_3:
; GFX12-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX12-NEXT:    s_branch .LBB16_2
; GFX12-NEXT:  .LBB16_4:
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:  .LBB16_5: ; %endif
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: mul64_in_branch:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU_PUSH_BEFORE 4, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    JUMP @3 POP:1
; EG-NEXT:    ALU_POP_AFTER 11, @19, KC0[CB0:0-32], KC1[]
; EG-NEXT:    ALU_PUSH_BEFORE 2, @31, KC0[CB0:0-32], KC1[]
; EG-NEXT:    JUMP @8 POP:1
; EG-NEXT:    ALU 0, @34, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @12
; EG-NEXT:    POP @8 POP:1
; EG-NEXT:    ALU 1, @35, KC0[], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     OR_INT T0.W, KC0[2].W, KC0[3].X,
; EG-NEXT:     MOV * T1.W, literal.x,
; EG-NEXT:    1(1.401298e-45), 0(0.000000e+00)
; EG-NEXT:     SETNE_INT * T0.W, PV.W, 0.0,
; EG-NEXT:     PRED_SETNE_INT * ExecMask,PredicateBit (MASKED), PV.W, 0.0,
; EG-NEXT:    ALU clause starting at 19:
; EG-NEXT:     MOV T0.W, KC0[2].W,
; EG-NEXT:     MOV * T1.W, KC0[3].Z,
; EG-NEXT:     MOV T2.W, KC0[3].Y,
; EG-NEXT:     MULLO_INT * T0.X, PV.W, PS,
; EG-NEXT:     MOV T1.W, KC0[3].X,
; EG-NEXT:     MULHI * T0.Y, T0.W, PV.W,
; EG-NEXT:     ADD_INT T3.W, PS, T0.X,
; EG-NEXT:     MULLO_INT * T0.X, PV.W, T2.W,
; EG-NEXT:     ADD_INT T0.Y, PV.W, PS,
; EG-NEXT:     MOV T1.W, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.W, T2.W,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 31:
; EG-NEXT:     MOV T0.W, KC0[2].Y,
; EG-NEXT:     SETE_INT * T1.W, T1.W, 0.0,
; EG-NEXT:     PRED_SETE_INT * ExecMask,PredicateBit (MASKED), PS, 0.0,
; EG-NEXT:    ALU clause starting at 34:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 35:
; EG-NEXT:     LSHR * T1.X, T0.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %0 = icmp eq i64 %a, 0
  br i1 %0, label %if, label %else

if:
  %1 = load i64, ptr addrspace(1) %in
  br label %endif

else:
  %2 = mul i64 %a, %b
  br label %endif

endif:
  %3 = phi i64 [%1, %if], [%2, %else]
  store i64 %3, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_mul_i128(ptr addrspace(1) %out, [8 x i32], i128 %a, [8 x i32], i128 %b) nounwind #0 {
; SI-LABEL: s_mul_i128:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x13
; SI-NEXT:    s_load_dwordx4 s[12:15], s[4:5], 0x1f
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s10
; SI-NEXT:    v_mul_hi_u32 v0, s12, v0
; SI-NEXT:    v_mov_b32_e32 v1, s8
; SI-NEXT:    v_mul_hi_u32 v1, s14, v1
; SI-NEXT:    s_mul_i32 s4, s12, s11
; SI-NEXT:    s_mul_i32 s5, s13, s10
; SI-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, s5, v0
; SI-NEXT:    s_mul_i32 s5, s14, s9
; SI-NEXT:    s_mul_i32 s4, s12, s10
; SI-NEXT:    v_add_i32_e32 v1, vcc, s5, v1
; SI-NEXT:    s_mul_i32 s5, s15, s8
; SI-NEXT:    v_add_i32_e32 v1, vcc, s5, v1
; SI-NEXT:    s_mul_i32 s5, s14, s8
; SI-NEXT:    v_mov_b32_e32 v2, s4
; SI-NEXT:    v_add_i32_e32 v2, vcc, s5, v2
; SI-NEXT:    v_addc_u32_e32 v0, vcc, v1, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s12
; SI-NEXT:    v_mul_hi_u32 v5, s8, v1
; SI-NEXT:    v_mul_hi_u32 v1, s9, v1
; SI-NEXT:    v_mov_b32_e32 v3, s13
; SI-NEXT:    v_mul_hi_u32 v4, s8, v3
; SI-NEXT:    s_mul_i32 s5, s9, s12
; SI-NEXT:    v_add_i32_e32 v5, vcc, s5, v5
; SI-NEXT:    s_mul_i32 s4, s8, s13
; SI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v1, vcc
; SI-NEXT:    v_add_i32_e32 v1, vcc, s4, v5
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, v6, v4
; SI-NEXT:    v_mul_hi_u32 v3, s9, v3
; SI-NEXT:    v_addc_u32_e64 v5, s[4:5], 0, 0, vcc
; SI-NEXT:    s_mul_i32 s4, s9, s13
; SI-NEXT:    v_add_i32_e32 v4, vcc, s4, v4
; SI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; SI-NEXT:    s_mul_i32 s4, s8, s12
; SI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_mul_i128:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x4c
; VI-NEXT:    s_load_dwordx4 s[12:15], s[4:5], 0x7c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v5, 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s10
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], s12, v0, 0
; VI-NEXT:    s_mul_i32 s4, s12, s11
; VI-NEXT:    v_mov_b32_e32 v6, s12
; VI-NEXT:    v_add_u32_e32 v3, vcc, s4, v3
; VI-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], s8, v6, 0
; VI-NEXT:    s_mul_i32 s6, s13, s10
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_mov_b32_e32 v4, v1
; VI-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], s9, v6, v[4:5]
; VI-NEXT:    v_mov_b32_e32 v8, s8
; VI-NEXT:    v_mad_u64_u32 v[1:2], s[4:5], s14, v8, v[2:3]
; VI-NEXT:    v_mov_b32_e32 v3, v7
; VI-NEXT:    v_mov_b32_e32 v7, v5
; VI-NEXT:    v_mov_b32_e32 v8, s13
; VI-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], s8, v8, v[6:7]
; VI-NEXT:    s_mul_i32 s6, s15, s8
; VI-NEXT:    v_add_u32_e32 v6, vcc, s6, v2
; VI-NEXT:    v_mov_b32_e32 v2, v5
; VI-NEXT:    v_add_u32_e32 v2, vcc, v3, v2
; VI-NEXT:    v_addc_u32_e64 v3, s[4:5], 0, 0, vcc
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], s9, v8, v[2:3]
; VI-NEXT:    s_mul_i32 s6, s14, s9
; VI-NEXT:    v_add_u32_e32 v5, vcc, s6, v6
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v5, vcc
; VI-NEXT:    v_mov_b32_e32 v1, v4
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_mul_i128:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x4c
; GFX9-NEXT:    s_load_dwordx4 s[12:15], s[4:5], 0x7c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s4, s12, s11
; GFX9-NEXT:    s_mul_hi_u32 s5, s12, s10
; GFX9-NEXT:    s_mul_i32 s6, s14, s9
; GFX9-NEXT:    s_mul_hi_u32 s7, s14, s8
; GFX9-NEXT:    s_add_i32 s4, s5, s4
; GFX9-NEXT:    s_mul_i32 s5, s13, s10
; GFX9-NEXT:    s_add_i32 s6, s7, s6
; GFX9-NEXT:    s_mul_i32 s7, s15, s8
; GFX9-NEXT:    s_add_i32 s4, s4, s5
; GFX9-NEXT:    s_mul_i32 s5, s12, s10
; GFX9-NEXT:    s_add_i32 s6, s6, s7
; GFX9-NEXT:    s_mul_i32 s7, s14, s8
; GFX9-NEXT:    s_add_u32 s7, s7, s5
; GFX9-NEXT:    s_addc_u32 s6, s6, s4
; GFX9-NEXT:    s_mul_i32 s14, s9, s12
; GFX9-NEXT:    s_mul_hi_u32 s15, s8, s12
; GFX9-NEXT:    s_mul_hi_u32 s11, s9, s12
; GFX9-NEXT:    s_add_u32 s14, s14, s15
; GFX9-NEXT:    s_mul_i32 s5, s8, s13
; GFX9-NEXT:    s_addc_u32 s11, s11, 0
; GFX9-NEXT:    s_mul_hi_u32 s10, s8, s13
; GFX9-NEXT:    s_add_u32 s5, s5, s14
; GFX9-NEXT:    s_addc_u32 s10, s10, 0
; GFX9-NEXT:    s_add_u32 s10, s11, s10
; GFX9-NEXT:    s_addc_u32 s11, 0, 0
; GFX9-NEXT:    s_mul_hi_u32 s14, s9, s13
; GFX9-NEXT:    s_mul_i32 s9, s9, s13
; GFX9-NEXT:    s_add_u32 s9, s9, s10
; GFX9-NEXT:    s_addc_u32 s10, s14, s11
; GFX9-NEXT:    s_mov_b32 s4, 0
; GFX9-NEXT:    s_add_u32 s9, s9, s7
; GFX9-NEXT:    s_addc_u32 s10, s10, s6
; GFX9-NEXT:    s_mul_i32 s6, s8, s12
; GFX9-NEXT:    s_mov_b32 s7, s4
; GFX9-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-NEXT:    v_mov_b32_e32 v3, s10
; GFX9-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_mul_i128:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4c
; GFX10-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x7c
; GFX10-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x24
; GFX10-NEXT:    s_mov_b32 s6, 0
; GFX10-NEXT:    s_mov_b32 s5, s6
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mul_i32 s3, s8, s3
; GFX10-NEXT:    s_mul_hi_u32 s4, s8, s2
; GFX10-NEXT:    s_mul_i32 s14, s10, s1
; GFX10-NEXT:    s_mul_hi_u32 s15, s10, s0
; GFX10-NEXT:    s_mul_i32 s7, s9, s2
; GFX10-NEXT:    s_mul_i32 s11, s11, s0
; GFX10-NEXT:    s_add_i32 s3, s4, s3
; GFX10-NEXT:    s_add_i32 s4, s15, s14
; GFX10-NEXT:    s_mul_i32 s2, s8, s2
; GFX10-NEXT:    s_mul_i32 s10, s10, s0
; GFX10-NEXT:    s_add_i32 s3, s3, s7
; GFX10-NEXT:    s_add_i32 s4, s4, s11
; GFX10-NEXT:    s_mul_i32 s19, s1, s8
; GFX10-NEXT:    s_mul_hi_u32 s20, s0, s8
; GFX10-NEXT:    s_add_u32 s2, s10, s2
; GFX10-NEXT:    s_mul_hi_u32 s18, s1, s8
; GFX10-NEXT:    s_addc_u32 s3, s4, s3
; GFX10-NEXT:    s_mul_i32 s17, s0, s9
; GFX10-NEXT:    s_add_u32 s4, s19, s20
; GFX10-NEXT:    s_mul_hi_u32 s16, s0, s9
; GFX10-NEXT:    s_mul_hi_u32 s21, s1, s9
; GFX10-NEXT:    s_mul_i32 s1, s1, s9
; GFX10-NEXT:    s_addc_u32 s9, s18, 0
; GFX10-NEXT:    s_add_u32 s7, s17, s4
; GFX10-NEXT:    s_addc_u32 s10, s16, 0
; GFX10-NEXT:    s_mul_i32 s4, s0, s8
; GFX10-NEXT:    s_add_u32 s0, s9, s10
; GFX10-NEXT:    s_addc_u32 s8, 0, 0
; GFX10-NEXT:    s_add_u32 s0, s1, s0
; GFX10-NEXT:    s_addc_u32 s1, s21, s8
; GFX10-NEXT:    s_add_u32 s2, s0, s2
; GFX10-NEXT:    s_addc_u32 s3, s1, s3
; GFX10-NEXT:    s_or_b64 s[0:1], s[4:5], s[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    s_mov_b32 s15, 0x31016000
; GFX10-NEXT:    s_mov_b32 s14, -1
; GFX10-NEXT:    buffer_store_dwordx4 v[0:3], off, s[12:15], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_mul_i128:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x4c
; GFX11-NEXT:    s_load_b128 s[8:11], s[4:5], 0x7c
; GFX11-NEXT:    s_load_b64 s[4:5], s[4:5], 0x24
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_mov_b32 s13, s6
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mul_i32 s3, s8, s3
; GFX11-NEXT:    s_mul_hi_u32 s7, s8, s2
; GFX11-NEXT:    s_mul_i32 s14, s10, s1
; GFX11-NEXT:    s_mul_hi_u32 s15, s10, s0
; GFX11-NEXT:    s_mul_i32 s12, s9, s2
; GFX11-NEXT:    s_mul_i32 s11, s11, s0
; GFX11-NEXT:    s_add_i32 s3, s7, s3
; GFX11-NEXT:    s_add_i32 s7, s15, s14
; GFX11-NEXT:    s_mul_i32 s2, s8, s2
; GFX11-NEXT:    s_mul_i32 s10, s10, s0
; GFX11-NEXT:    s_add_i32 s3, s3, s12
; GFX11-NEXT:    s_add_i32 s7, s7, s11
; GFX11-NEXT:    s_mul_i32 s19, s1, s8
; GFX11-NEXT:    s_mul_hi_u32 s20, s0, s8
; GFX11-NEXT:    s_add_u32 s2, s10, s2
; GFX11-NEXT:    s_mul_hi_u32 s18, s1, s8
; GFX11-NEXT:    s_addc_u32 s3, s7, s3
; GFX11-NEXT:    s_mul_i32 s17, s0, s9
; GFX11-NEXT:    s_add_u32 s7, s19, s20
; GFX11-NEXT:    s_mul_hi_u32 s16, s0, s9
; GFX11-NEXT:    s_mul_hi_u32 s21, s1, s9
; GFX11-NEXT:    s_mul_i32 s1, s1, s9
; GFX11-NEXT:    s_addc_u32 s9, s18, 0
; GFX11-NEXT:    s_add_u32 s7, s17, s7
; GFX11-NEXT:    s_addc_u32 s10, s16, 0
; GFX11-NEXT:    s_mul_i32 s12, s0, s8
; GFX11-NEXT:    s_add_u32 s0, s9, s10
; GFX11-NEXT:    s_addc_u32 s8, 0, 0
; GFX11-NEXT:    s_add_u32 s0, s1, s0
; GFX11-NEXT:    s_addc_u32 s1, s21, s8
; GFX11-NEXT:    s_add_u32 s2, s0, s2
; GFX11-NEXT:    s_addc_u32 s3, s1, s3
; GFX11-NEXT:    s_or_b64 s[0:1], s[12:13], s[6:7]
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    buffer_store_b128 v[0:3], off, s[4:7], 0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: s_mul_i128:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[8:11], s[4:5], 0x7c
; GFX12-NEXT:    s_load_b128 s[12:15], s[4:5], 0x4c
; GFX12-NEXT:    s_mov_b32 s3, 0
; GFX12-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX12-NEXT:    s_mov_b32 s7, s3
; GFX12-NEXT:    s_mov_b32 s5, s3
; GFX12-NEXT:    s_mov_b32 s17, s3
; GFX12-NEXT:    s_mov_b32 s19, s3
; GFX12-NEXT:    s_mov_b32 s24, s3
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s2, s8
; GFX12-NEXT:    s_mov_b32 s6, s12
; GFX12-NEXT:    s_mov_b32 s4, s13
; GFX12-NEXT:    s_mul_u64 s[22:23], s[6:7], s[2:3]
; GFX12-NEXT:    s_mul_u64 s[20:21], s[4:5], s[2:3]
; GFX12-NEXT:    s_mov_b32 s2, s23
; GFX12-NEXT:    s_mov_b32 s16, s9
; GFX12-NEXT:    s_mul_u64 s[10:11], s[10:11], s[12:13]
; GFX12-NEXT:    s_add_nc_u64 s[12:13], s[20:21], s[2:3]
; GFX12-NEXT:    s_mul_u64 s[6:7], s[6:7], s[16:17]
; GFX12-NEXT:    s_mov_b32 s2, s13
; GFX12-NEXT:    s_mov_b32 s13, s3
; GFX12-NEXT:    s_mul_u64 s[8:9], s[8:9], s[14:15]
; GFX12-NEXT:    s_add_nc_u64 s[6:7], s[6:7], s[12:13]
; GFX12-NEXT:    s_mul_u64 s[4:5], s[4:5], s[16:17]
; GFX12-NEXT:    s_mov_b32 s18, s7
; GFX12-NEXT:    s_mov_b32 s23, s3
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[2:3], s[18:19]
; GFX12-NEXT:    s_add_nc_u64 s[8:9], s[10:11], s[8:9]
; GFX12-NEXT:    s_mov_b32 s25, s6
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[4:5], s[2:3]
; GFX12-NEXT:    s_or_b64 s[6:7], s[22:23], s[24:25]
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[2:3], s[8:9]
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_mov_b32 s3, 0x31016000
; GFX12-NEXT:    s_mov_b32 s2, -1
; GFX12-NEXT:    buffer_store_b128 v[0:3], off, s[0:3], null
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: s_mul_i128:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 41, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     MULLO_INT * T0.X, KC0[5].X, KC0[8].X,
; EG-NEXT:     MULHI * T0.Y, KC0[5].X, KC0[8].X,
; EG-NEXT:     MULLO_INT * T0.Z, KC0[8].Y, KC0[4].W,
; EG-NEXT:     MULLO_INT * T0.W, KC0[8].X, KC0[5].Y,
; EG-NEXT:     MULHI * T1.X, KC0[5].X, KC0[7].W,
; EG-NEXT:     MULHI * T1.Y, KC0[4].W, KC0[8].X,
; EG-NEXT:     MULHI * T1.Z, KC0[8].Y, KC0[4].W,
; EG-NEXT:     MULLO_INT * T1.W, KC0[8].Y, KC0[5].X,
; EG-NEXT:     MULHI * T2.X, KC0[7].W, KC0[5].Y,
; EG-NEXT:     MULLO_INT * T2.Y, KC0[5].X, KC0[7].W,
; EG-NEXT:     MULHI * T2.Z, KC0[4].W, KC0[7].W,
; EG-NEXT:     ADD_INT T2.W, T2.Y, PS,
; EG-NEXT:     MULLO_INT * T3.X, KC0[4].W, KC0[8].X,
; EG-NEXT:     ADDC_UINT T2.Z, T2.Y, T2.Z,
; EG-NEXT:     ADDC_UINT T3.W, PS, PV.W,
; EG-NEXT:     MULLO_INT * T2.Y, KC0[7].W, KC0[5].Z,
; EG-NEXT:     ADD_INT T2.X, T2.X, PS,
; EG-NEXT:     ADD_INT T2.Y, T1.Z, T1.W,
; EG-NEXT:     ADD_INT T1.Z, T1.Y, PV.W,
; EG-NEXT:     ADD_INT T1.W, T1.X, PV.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MULLO_INT * T1.X, KC0[8].Z, KC0[4].W,
; EG-NEXT:     ADD_INT T4.X, PV.W, PV.Z,
; EG-NEXT:     ADDC_UINT T1.Y, PV.W, PV.Z,
; EG-NEXT:     ADD_INT T1.Z, PV.Y, PS,
; EG-NEXT:     ADD_INT T0.W, PV.X, T0.W,
; EG-NEXT:     MULLO_INT * T1.X, KC0[7].W, KC0[5].Y,
; EG-NEXT:     ADD_INT T2.Y, PV.Z, PV.W,
; EG-NEXT:     ADDC_UINT T1.Z, T0.Z, PS,
; EG-NEXT:     ADD_INT T0.W, T0.Y, PV.Y,
; EG-NEXT:     ADDC_UINT * T1.W, T0.X, PV.X,
; EG-NEXT:     ADD_INT T0.Y, T0.X, T4.X,
; EG-NEXT:     ADD_INT T0.Z, T0.Z, T1.X, BS:VEC_021/SCL_122
; EG-NEXT:     ADD_INT T0.W, PV.W, PS,
; EG-NEXT:     ADD_INT * T1.W, PV.Y, PV.Z,
; EG-NEXT:     ADD_INT T0.W, PV.W, PS,
; EG-NEXT:     ADDC_UINT * T1.W, PV.Y, PV.Z,
; EG-NEXT:     ADD_INT * T0.W, PV.W, PS,
; EG-NEXT:     ADD_INT * T0.Z, T0.Y, T0.Z,
; EG-NEXT:     ADD_INT * T0.Y, T3.X, T2.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     MULLO_INT * T0.X, KC0[4].W, KC0[7].W,
entry:
  %mul = mul i128 %a, %b
  store i128 %mul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_mul_i128(ptr addrspace(1) %out, ptr addrspace(1) %aptr, ptr addrspace(1) %bptr) #0 {
; SI-LABEL: v_mul_i128:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0xb
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v8, 4, v0
; SI-NEXT:    v_mov_b32_e32 v9, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[0:1]
; SI-NEXT:    s_mov_b64 s[0:1], s[2:3]
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    buffer_load_dwordx4 v[0:3], v[8:9], s[4:7], 0 addr64
; SI-NEXT:    buffer_load_dwordx4 v[4:7], v[8:9], s[0:3], 0 addr64
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mul_lo_u32 v3, v4, v3
; SI-NEXT:    v_mul_hi_u32 v10, v4, v2
; SI-NEXT:    v_mul_lo_u32 v12, v6, v1
; SI-NEXT:    v_mul_hi_u32 v13, v6, v0
; SI-NEXT:    v_mul_lo_u32 v17, v1, v4
; SI-NEXT:    v_mul_hi_u32 v18, v0, v4
; SI-NEXT:    v_mul_lo_u32 v11, v5, v2
; SI-NEXT:    v_mul_lo_u32 v7, v7, v0
; SI-NEXT:    v_mul_hi_u32 v16, v1, v4
; SI-NEXT:    v_mul_lo_u32 v15, v0, v5
; SI-NEXT:    v_mul_hi_u32 v14, v0, v5
; SI-NEXT:    v_mul_hi_u32 v19, v1, v5
; SI-NEXT:    v_mul_lo_u32 v5, v1, v5
; SI-NEXT:    v_add_i32_e32 v1, vcc, v10, v3
; SI-NEXT:    v_add_i32_e32 v3, vcc, v13, v12
; SI-NEXT:    v_mul_lo_u32 v2, v4, v2
; SI-NEXT:    v_mul_lo_u32 v6, v6, v0
; SI-NEXT:    v_mul_lo_u32 v0, v0, v4
; SI-NEXT:    v_add_i32_e32 v4, vcc, v17, v18
; SI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v16, vcc
; SI-NEXT:    v_add_i32_e32 v11, vcc, v1, v11
; SI-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; SI-NEXT:    v_add_i32_e32 v1, vcc, v15, v4
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v14, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, v6, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, v10, v4
; SI-NEXT:    v_addc_u32_e64 v6, s[4:5], 0, 0, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, v19, v6, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, v4, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, v5, v3, vcc
; SI-NEXT:    buffer_store_dwordx4 v[0:3], v[8:9], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_mul_i128:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x2c
; VI-NEXT:    v_lshlrev_b32_e32 v2, 4, v0
; VI-NEXT:    v_mov_b32_e32 v10, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_add_u32_e32 v12, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v3, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    flat_load_dwordx4 v[4:7], v[12:13]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mul_lo_u32 v3, v4, v3
; VI-NEXT:    v_mad_u64_u32 v[14:15], s[0:1], v4, v2, 0
; VI-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v0, v4, 0
; VI-NEXT:    v_mul_lo_u32 v2, v5, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, v15, v3
; VI-NEXT:    v_add_u32_e32 v15, vcc, v3, v2
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], v1, v4, v[9:10]
; VI-NEXT:    v_mov_b32_e32 v4, v3
; VI-NEXT:    v_mov_b32_e32 v3, v10
; VI-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], v0, v5, v[2:3]
; VI-NEXT:    v_mad_u64_u32 v[9:10], s[0:1], v6, v0, v[14:15]
; VI-NEXT:    v_add_u32_e32 v3, vcc, v4, v3
; VI-NEXT:    v_addc_u32_e64 v4, s[0:1], 0, 0, vcc
; VI-NEXT:    v_mul_lo_u32 v0, v7, v0
; VI-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v1, v5, v[3:4]
; VI-NEXT:    v_mul_lo_u32 v1, v6, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, v0, v10
; VI-NEXT:    v_add_u32_e32 v0, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v10, vcc, v3, v9
; VI-NEXT:    v_addc_u32_e32 v11, vcc, v4, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v9, v2
; VI-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_mul_i128:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x2c
; GFX9-NEXT:    v_lshlrev_b32_e32 v12, 4, v0
; GFX9-NEXT:    v_mov_b32_e32 v11, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v12, s[0:1]
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v12, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v10, v5, v2
; GFX9-NEXT:    v_mul_lo_u32 v13, v4, v3
; GFX9-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v4, v2, 0
; GFX9-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], v0, v4, 0
; GFX9-NEXT:    v_add3_u32 v9, v9, v13, v10
; GFX9-NEXT:    v_mul_lo_u32 v13, v6, v1
; GFX9-NEXT:    v_mov_b32_e32 v10, v3
; GFX9-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v1, v4, v[10:11]
; GFX9-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v6, v0, v[8:9]
; GFX9-NEXT:    v_mov_b32_e32 v10, v4
; GFX9-NEXT:    v_mov_b32_e32 v4, v11
; GFX9-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v0, v5, v[3:4]
; GFX9-NEXT:    v_mul_lo_u32 v0, v7, v0
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, v10, v4
; GFX9-NEXT:    v_addc_co_u32_e64 v11, s[0:1], 0, 0, vcc
; GFX9-NEXT:    v_mad_u64_u32 v[4:5], s[0:1], v1, v5, v[10:11]
; GFX9-NEXT:    v_add3_u32 v0, v0, v9, v13
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, v4, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v0, vcc
; GFX9-NEXT:    global_store_dwordx4 v12, v[2:5], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_mul_i128:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x2c
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 4, v0
; GFX10-NEXT:    v_mov_b32_e32 v10, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v13, s[0:1]
; GFX10-NEXT:    global_load_dwordx4 v[4:7], v13, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mad_u64_u32 v[8:9], s0, v0, v4, 0
; GFX10-NEXT:    v_mul_lo_u32 v15, v5, v2
; GFX10-NEXT:    v_mul_lo_u32 v7, v7, v0
; GFX10-NEXT:    v_mad_u64_u32 v[11:12], s0, v1, v4, v[9:10]
; GFX10-NEXT:    v_mov_b32_e32 v14, v12
; GFX10-NEXT:    v_mov_b32_e32 v12, v10
; GFX10-NEXT:    v_mad_u64_u32 v[9:10], s0, v0, v5, v[11:12]
; GFX10-NEXT:    v_mul_lo_u32 v11, v4, v3
; GFX10-NEXT:    v_mad_u64_u32 v[2:3], s0, v4, v2, 0
; GFX10-NEXT:    v_mul_lo_u32 v12, v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v4, v10
; GFX10-NEXT:    v_add3_u32 v3, v3, v11, v15
; GFX10-NEXT:    v_add_co_u32 v10, s0, v14, v4
; GFX10-NEXT:    v_add_co_ci_u32_e64 v11, s0, 0, 0, s0
; GFX10-NEXT:    v_mad_u64_u32 v[2:3], s0, v6, v0, v[2:3]
; GFX10-NEXT:    v_mad_u64_u32 v[0:1], s0, v1, v5, v[10:11]
; GFX10-NEXT:    v_add3_u32 v3, v7, v3, v12
; GFX10-NEXT:    v_add_co_u32 v10, vcc_lo, v0, v2
; GFX10-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, v1, v3, vcc_lo
; GFX10-NEXT:    global_store_dwordx4 v13, v[8:11], s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_mul_i128:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x2c
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_lshlrev_b32 v15, 4, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_load_b128 v[0:3], v15, s[0:1]
; GFX11-NEXT:    global_load_b128 v[4:7], v15, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mad_u64_u32 v[8:9], null, v0, v4, 0
; GFX11-NEXT:    v_mul_lo_u32 v14, v5, v2
; GFX11-NEXT:    v_mul_lo_u32 v3, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mad_u64_u32 v[11:12], null, v1, v4, v[9:10]
; GFX11-NEXT:    v_dual_mov_b32 v13, v12 :: v_dual_mov_b32 v12, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_mad_u64_u32 v[9:10], null, v0, v5, v[11:12]
; GFX11-NEXT:    v_mad_u64_u32 v[11:12], null, v4, v2, 0
; GFX11-NEXT:    v_mul_lo_u32 v4, v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v2, v10
; GFX11-NEXT:    v_mul_lo_u32 v10, v7, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_add3_u32 v12, v12, v3, v14
; GFX11-NEXT:    v_add_co_u32 v2, s0, v13, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, 0, s0
; GFX11-NEXT:    v_mad_u64_u32 v[13:14], null, v6, v0, v[11:12]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mad_u64_u32 v[6:7], null, v1, v5, v[2:3]
; GFX11-NEXT:    v_add3_u32 v0, v10, v14, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v6, v13
; GFX11-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, v7, v0, vcc_lo
; GFX11-NEXT:    global_store_b128 v15, v[8:11], s[2:3]
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: v_mul_i128:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x2c
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_lshlrev_b32 v13, 4, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    global_load_b128 v[0:3], v13, s[0:1]
; GFX12-NEXT:    global_load_b128 v[4:7], v13, s[2:3]
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mad_co_u64_u32 v[8:9], null, v0, v4, 0
; GFX12-NEXT:    v_mul_lo_u32 v15, v5, v2
; GFX12-NEXT:    v_mul_lo_u32 v7, v7, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mad_co_u64_u32 v[11:12], null, v1, v4, v[9:10]
; GFX12-NEXT:    v_mov_b32_e32 v14, v12
; GFX12-NEXT:    v_mov_b32_e32 v12, v10
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_mad_co_u64_u32 v[9:10], null, v0, v5, v[11:12]
; GFX12-NEXT:    v_mul_lo_u32 v11, v4, v3
; GFX12-NEXT:    v_mad_co_u64_u32 v[2:3], null, v4, v2, 0
; GFX12-NEXT:    v_mul_lo_u32 v12, v6, v1
; GFX12-NEXT:    v_mov_b32_e32 v4, v10
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_add3_u32 v3, v3, v11, v15
; GFX12-NEXT:    v_add_co_u32 v10, s0, v14, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, 0, s0
; GFX12-NEXT:    v_mad_co_u64_u32 v[2:3], null, v6, v0, v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_mad_co_u64_u32 v[0:1], null, v1, v5, v[10:11]
; GFX12-NEXT:    v_add3_u32 v3, v7, v3, v12
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_add_co_u32 v10, vcc_lo, v0, v2
; GFX12-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, v1, v3, vcc_lo
; GFX12-NEXT:    global_store_b128 v13, v[8:11], s[2:3]
; GFX12-NEXT:    s_endpgm
;
; EG-LABEL: v_mul_i128:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 3, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 41, @14, KC0[], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T2.XYZW, T1.X, 0, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T0.X, KC0[2].Z, PV.W,
; EG-NEXT:     ADD_INT * T1.X, KC0[2].W, PV.W,
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MULLO_INT * T1.Y, T0.Y, T2.Y,
; EG-NEXT:     MULHI * T1.Z, T0.Y, T2.Y,
; EG-NEXT:     MULLO_INT * T1.W, T2.Z, T0.X,
; EG-NEXT:     MULLO_INT * T3.X, T2.Y, T0.Z,
; EG-NEXT:     MULHI * T3.Y, T0.Y, T2.X,
; EG-NEXT:     MULHI * T3.Z, T0.X, T2.Y,
; EG-NEXT:     MULHI * T3.W, T2.Z, T0.X,
; EG-NEXT:     MULLO_INT * T2.Z, T2.Z, T0.Y,
; EG-NEXT:     MULHI * T4.X, T2.X, T0.Z,
; EG-NEXT:     MULLO_INT * T0.Y, T0.Y, T2.X,
; EG-NEXT:     MULHI * T4.Y, T0.X, T2.X,
; EG-NEXT:     ADD_INT T4.W, T0.Y, PS,
; EG-NEXT:     MULLO_INT * T2.Y, T0.X, T2.Y,
; EG-NEXT:     ADDC_UINT T4.Z, T0.Y, T4.Y,
; EG-NEXT:     ADDC_UINT T5.W, PS, PV.W,
; EG-NEXT:     MULLO_INT * T0.Y, T2.X, T0.W,
; EG-NEXT:     ADD_INT T4.X, T4.X, PS,
; EG-NEXT:     ADD_INT T0.Y, T3.W, T2.Z,
; EG-NEXT:     ADD_INT T2.Z, T3.Z, PV.W,
; EG-NEXT:     ADD_INT T0.W, T3.Y, PV.Z,
; EG-NEXT:     MULLO_INT * T2.W, T2.W, T0.X,
; EG-NEXT:     ADD_INT T5.X, PV.W, PV.Z,
; EG-NEXT:     ADDC_UINT T3.Y, PV.W, PV.Z,
; EG-NEXT:     ADD_INT T2.Z, PV.Y, PS,
; EG-NEXT:     ADD_INT T0.W, PV.X, T3.X,
; EG-NEXT:     MULLO_INT * T0.Y, T2.X, T0.Z,
; EG-NEXT:     ADD_INT T4.Y, PV.Z, PV.W,
; EG-NEXT:     ADDC_UINT T0.Z, T1.W, PS,
; EG-NEXT:     ADD_INT T0.W, T1.Z, PV.Y,
; EG-NEXT:     ADDC_UINT * T2.W, T1.Y, PV.X,
; EG-NEXT:     ADD_INT T1.Y, T1.Y, T5.X,
; EG-NEXT:     ADD_INT T1.Z, T1.W, T0.Y,
; EG-NEXT:     ADD_INT T0.W, PV.W, PS,
; EG-NEXT:     ADD_INT * T1.W, PV.Y, PV.Z,
; EG-NEXT:     ADD_INT T0.W, PV.W, PS,
; EG-NEXT:     ADDC_UINT * T1.W, PV.Y, PV.Z,
; EG-NEXT:     ADD_INT * T0.W, PV.W, PS,
; EG-NEXT:     ADD_INT * T0.Z, T1.Y, T1.Z,
; EG-NEXT:     ADD_INT * T0.Y, T2.Y, T4.W,
; EG-NEXT:     LSHR T1.X, T1.X, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T2.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.a = getelementptr inbounds i128, ptr addrspace(1) %aptr, i32 %tid
  %gep.b = getelementptr inbounds i128, ptr addrspace(1) %bptr, i32 %tid
  %gep.out = getelementptr inbounds i128, ptr addrspace(1) %bptr, i32 %tid
  %a = load i128, ptr addrspace(1) %gep.a
  %b = load i128, ptr addrspace(1) %gep.b
  %mul = mul i128 %a, %b
  store i128 %mul, ptr addrspace(1) %gep.out
  ret void
}

define i32 @mul_pow2_plus_1(i32 %val) {
; SI-LABEL: mul_pow2_plus_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mul_lo_u32 v0, v0, 9
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_pow2_plus_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_lo_u32 v0, v0, 9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: mul_pow2_plus_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshl_add_u32 v0, v0, 3, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: mul_pow2_plus_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshl_add_u32 v0, v0, 3, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_pow2_plus_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshl_add_u32 v0, v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: mul_pow2_plus_1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_lshl_add_u32 v0, v0, 3, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; EG-LABEL: mul_pow2_plus_1:
; EG:       ; %bb.0:
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
  %mul = mul i32 %val, 9
  ret i32 %mul
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone}
