; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=nvptx64-nvidia-cuda -passes=infer-address-spaces %s | FileCheck %s

%struct.S = type { [5 x i32] }

$g1 = comdat any

@g1 = linkonce_odr addrspace(3) global %struct.S zeroinitializer, comdat, align 4

define void @foo() local_unnamed_addr #0 {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X0:%.*]] = tail call i32 @llvm.nvvm.read.ptx.sreg.tid.x() #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    [[IDXPROM_I:%.*]] = zext i32 [[X0]] to i64
; CHECK-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr [[STRUCT_S:%.*]], ptr addrspacecast (ptr addrspace(3) @g1 to ptr), i64 0, i32 0, i64 [[IDXPROM_I]]
; CHECK-NEXT:    tail call void @f1(ptr [[ARRAYIDX_I]], i32 undef) #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    [[X1:%.*]] = load i32, ptr addrspace(3) @g1, align 4
; CHECK-NEXT:    [[L_SROA_0_0_INSERT_EXT_I:%.*]] = zext i32 [[X1]] to i64
; CHECK-NEXT:    tail call void @f2(ptr null, i64 [[L_SROA_0_0_INSERT_EXT_I]]) #[[ATTR0]]
; CHECK-NEXT:    ret void
;
entry:
  %x0 = tail call i32 @llvm.nvvm.read.ptx.sreg.tid.x() #2
  %idxprom.i = zext i32 %x0 to i64
  %arrayidx.i = getelementptr %struct.S, ptr addrspacecast (ptr addrspace(3) @g1 to ptr), i64 0, i32 0, i64 %idxprom.i
  tail call void @f1(ptr %arrayidx.i, i32 undef) #0
  %x1 = load i32, ptr addrspacecast (ptr addrspace(3) @g1 to ptr), align 4
  %L.sroa.0.0.insert.ext.i = zext i32 %x1 to i64
  tail call void @f2(ptr null, i64 %L.sroa.0.0.insert.ext.i) #0
  ret void
}

declare void @f1(ptr, i32) local_unnamed_addr #0
declare void @f2(ptr, i64) local_unnamed_addr #0
declare i32 @llvm.nvvm.read.ptx.sreg.tid.x() #1

; Make sure we can clone GEP which uses complex constant expressions as indices.
; https://bugs.llvm.org/show_bug.cgi?id=51099
@g2 = internal addrspace(3) global [128 x i8] undef, align 1

define float @complex_ce(ptr nocapture readnone %a, ptr nocapture readnone %b, ptr nocapture readnone %c) local_unnamed_addr #0 {
; CHECK-LABEL: @complex_ce(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr addrspace(3) getelementptr (i8, ptr addrspace(3) @g2, i64 sub (i64 ptrtoint (ptr addrspace(3) getelementptr inbounds ([128 x i8], ptr addrspace(3) @g2, i64 0, i64 123) to i64), i64 ptrtoint (ptr addrspace(3) getelementptr inbounds ([128 x i8], ptr addrspace(3) @g2, i64 2, i64 0) to i64))), align 4
; CHECK-NEXT:    ret float [[TMP0]]
;
entry:
  %0 = load float, ptr bitcast (
       ptr getelementptr (
         i8, ptr addrspacecast (ptr addrspace(3) @g2 to ptr),
         i64 sub (
           i64 ptrtoint (
             ptr getelementptr inbounds (
               [128 x i8],
               ptr addrspacecast (ptr addrspace(3) @g2 to ptr),
               i64 0,
               i64 123)
             to i64),
           i64 ptrtoint (
             ptr getelementptr inbounds (
               [128 x i8],
               ptr addrspacecast (ptr addrspace(3) @g2 to ptr),
               i64 2,
               i64 0)
             to i64)))
        to ptr), align 4
  ret float %0
}



attributes #0 = { convergent nounwind }
attributes #1 = { nounwind readnone }
attributes #2 = { nounwind }
