; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck %s

@lds = external local_unnamed_addr addrspace(3) global [4 x float], align 4

; expect readfirstlane to pick the 32bit register
define amdgpu_gs i32 @vgpr16_copyto_sgpr() {
; CHECK-LABEL: vgpr16_copyto_sgpr:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    v_mov_b32_e32 v0, lds@abs32@lo
; CHECK-NEXT:    ds_load_2addr_b32 v[0:1], v0 offset1:1
; CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; CHECK-NEXT:    v_cvt_f16_f32_e32 v0.l, v0
; CHECK-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; CHECK-NEXT:    v_readfirstlane_b32 s0, v0
; CHECK-NEXT:    s_and_b32 s0, 0xffff, s0
; CHECK-NEXT:    s_mul_i32 s0, s0, 5
; CHECK-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; CHECK-NEXT:    s_cmp_lg_u32 s0, 2
; CHECK-NEXT:    s_cbranch_scc1 .LBB0_2
; CHECK-NEXT:  ; %bb.1: ; %a1
; CHECK-NEXT:    s_mov_b32 s0, 1
; CHECK-NEXT:    s_branch .LBB0_3
; CHECK-NEXT:  .LBB0_2: ; %a2
; CHECK-NEXT:    s_mov_b32 s0, 2
; CHECK-NEXT:    s_branch .LBB0_3
; CHECK-NEXT:  .LBB0_3:
entry:
  %ptr = load <4 x float>, ptr addrspace(3) @lds, align 4
  %f = extractelement <4 x float> %ptr, i32 0
  %half = fptrunc float %f to half
  %i16 = bitcast half %half to i16
  %i32 = zext i16 %i16 to i32
  %add = add i32 %i32, 1
  %mul = mul i32 %add, 5
  %icmp = icmp eq i32 %mul, 7
  br i1 %icmp, label %a1, label %a2

a1:
  ret i32 1

a2:
  ret i32 2
}
