; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc < %s -mtriple=wasm32 -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128 | FileCheck %s --check-prefix=SIMD128

target datalayout = "e-m:e-p:32:32-p10:8:8-p20:8:8-i64:64-i128:128-n32:64-S128-ni:1:10:20"
target triple = "wasm32"

define <4 x i32> @sext_high_v4i8(<8 x i8> %in) {
; SIMD128-LABEL: sext_high_v4i8:
; SIMD128:         .functype sext_high_v4i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i16x8.extend_low_i8x16_s $push1=, $pop0
; SIMD128-NEXT:    i32x4.extend_low_i16x8_s $push2=, $pop1
; SIMD128-NEXT:    return $pop2
 %shuffle = shufflevector <8 x i8> %in, <8 x i8> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
 %res = sext <4 x i8> %shuffle to <4 x i32>
 ret <4 x i32> %res
}

define <4 x i32> @zext_high_v4i8(<8 x i8> %in) {
; SIMD128-LABEL: zext_high_v4i8:
; SIMD128:         .functype zext_high_v4i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    i16x8.extend_low_i8x16_u $push1=, $pop0
; SIMD128-NEXT:    i32x4.extend_low_i16x8_u $push2=, $pop1
; SIMD128-NEXT:    return $pop2
 %shuffle = shufflevector <8 x i8> %in, <8 x i8> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
 %res = zext <4 x i8> %shuffle to <4 x i32>
 ret <4 x i32> %res
}

define <8 x i16> @sext_high_v8i8(<16 x i8> %in) {
; SIMD128-LABEL: sext_high_v8i8:
; SIMD128:         .functype sext_high_v8i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extend_high_i8x16_s $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <16 x i8> %in, <16 x i8> poison, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 %res = sext <8 x i8> %shuffle to <8 x i16>
 ret <8 x i16> %res
}

define <8 x i16> @zext_high_v8i8(<16 x i8> %in) {
; SIMD128-LABEL: zext_high_v8i8:
; SIMD128:         .functype zext_high_v8i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extend_high_i8x16_u $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <16 x i8> %in, <16 x i8> poison, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 %res = zext <8 x i8> %shuffle to <8 x i16>
 ret <8 x i16> %res
}

define <2 x i32> @sext_high_v2i16(<4 x i16> %in) {
; SIMD128-LABEL: sext_high_v2i16:
; SIMD128:         .functype sext_high_v2i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i32x4.extend_low_i16x8_s $push1=, $pop0
; SIMD128-NEXT:    return $pop1
 %shuffle = shufflevector <4 x i16> %in, <4 x i16> poison, <2 x i32> <i32 2, i32 3>
 %res = sext <2 x i16> %shuffle to <2 x i32>
 ret <2 x i32> %res
}

define <2 x i32> @zext_high_v2i16(<4 x i16> %in) {
; SIMD128-LABEL: zext_high_v2i16:
; SIMD128:         .functype zext_high_v2i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 4, 5, 6, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    i32x4.extend_low_i16x8_u $push1=, $pop0
; SIMD128-NEXT:    return $pop1
 %shuffle = shufflevector <4 x i16> %in, <4 x i16> poison, <2 x i32> <i32 2, i32 3>
 %res = zext <2 x i16> %shuffle to <2 x i32>
 ret <2 x i32> %res
}

define <4 x i32> @sext_high_v4i16(<8 x i16> %in) {
; SIMD128-LABEL: sext_high_v4i16:
; SIMD128:         .functype sext_high_v4i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extend_high_i16x8_s $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <8 x i16> %in, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
 %res = sext <4 x i16> %shuffle to <4 x i32>
 ret <4 x i32> %res
}

define <4 x i32> @zext_high_v4i16(<8 x i16> %in) {
; SIMD128-LABEL: zext_high_v4i16:
; SIMD128:         .functype zext_high_v4i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extend_high_i16x8_u $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <8 x i16> %in, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
 %res = zext <4 x i16> %shuffle to <4 x i32>
 ret <4 x i32> %res
}

define <2 x i64> @sext_high_v2i32(<4 x i32> %in) {
; SIMD128-LABEL: sext_high_v2i32:
; SIMD128:         .functype sext_high_v2i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extend_high_i32x4_s $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <4 x i32> %in, <4 x i32> poison, <2 x i32> <i32 2, i32 3>
 %res = sext <2 x i32> %shuffle to <2 x i64>
 ret <2 x i64> %res
}

define <2 x i64> @zext_high_v2i32(<4 x i32> %in) {
; SIMD128-LABEL: zext_high_v2i32:
; SIMD128:         .functype zext_high_v2i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extend_high_i32x4_u $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <4 x i32> %in, <4 x i32> poison, <2 x i32> <i32 2, i32 3>
 %res = zext <2 x i32> %shuffle to <2 x i64>
 ret <2 x i64> %res
}

define <4 x i32> @sext_low_v4i8(<8 x i8> %in) {
; SIMD128-LABEL: sext_low_v4i8:
; SIMD128:         .functype sext_low_v4i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extend_low_i8x16_s $push0=, $0
; SIMD128-NEXT:    i32x4.extend_low_i16x8_s $push1=, $pop0
; SIMD128-NEXT:    return $pop1
 %shuffle = shufflevector <8 x i8> %in, <8 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
 %res = sext <4 x i8> %shuffle to <4 x i32>
 ret <4 x i32> %res
}

define <4 x i32> @zext_low_v4i8(<8 x i8> %in) {
; SIMD128-LABEL: zext_low_v4i8:
; SIMD128:         .functype zext_low_v4i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extend_low_i8x16_u $push0=, $0
; SIMD128-NEXT:    i32x4.extend_low_i16x8_u $push1=, $pop0
; SIMD128-NEXT:    return $pop1
 %shuffle = shufflevector <8 x i8> %in, <8 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
 %res = zext <4 x i8> %shuffle to <4 x i32>
 ret <4 x i32> %res
}

define <8 x i16> @sext_low_v8i8(<16 x i8> %in) {
; SIMD128-LABEL: sext_low_v8i8:
; SIMD128:         .functype sext_low_v8i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extend_low_i8x16_s $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <16 x i8> %in, <16 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 %res = sext <8 x i8> %shuffle to <8 x i16>
 ret <8 x i16> %res
}

define <8 x i16> @zext_low_v8i8(<16 x i8> %in) {
; SIMD128-LABEL: zext_low_v8i8:
; SIMD128:         .functype zext_low_v8i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extend_low_i8x16_u $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <16 x i8> %in, <16 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 %res = zext <8 x i8> %shuffle to <8 x i16>
 ret <8 x i16> %res
}

define <4 x i32> @sext_low_v4i16(<8 x i16> %in) {
; SIMD128-LABEL: sext_low_v4i16:
; SIMD128:         .functype sext_low_v4i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extend_low_i16x8_s $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <8 x i16> %in, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
 %res = sext <4 x i16> %shuffle to <4 x i32>
 ret <4 x i32> %res
}

define <4 x i32> @zext_low_v4i16(<8 x i16> %in) {
; SIMD128-LABEL: zext_low_v4i16:
; SIMD128:         .functype zext_low_v4i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extend_low_i16x8_u $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <8 x i16> %in, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
 %res = zext <4 x i16> %shuffle to <4 x i32>
 ret <4 x i32> %res
}

define <2 x i64> @sext_low_v2i32(<4 x i32> %in) {
; SIMD128-LABEL: sext_low_v2i32:
; SIMD128:         .functype sext_low_v2i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extend_low_i32x4_s $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <4 x i32> %in, <4 x i32> poison, <2 x i32> <i32 0, i32 1>
 %res = sext <2 x i32> %shuffle to <2 x i64>
 ret <2 x i64> %res
}

define <2 x i64> @zext_low_v2i32(<4 x i32> %in) {
; SIMD128-LABEL: zext_low_v2i32:
; SIMD128:         .functype zext_low_v2i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extend_low_i32x4_u $push0=, $0
; SIMD128-NEXT:    return $pop0
 %shuffle = shufflevector <4 x i32> %in, <4 x i32> poison, <2 x i32> <i32 0, i32 1>
 %res = zext <2 x i32> %shuffle to <2 x i64>
 ret <2 x i64> %res
}

define <2 x i64> @multi_use_ext_v2i32(<4 x i32> %in) {
; SIMD128-LABEL: multi_use_ext_v2i32:
; SIMD128:         .functype multi_use_ext_v2i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extend_high_i32x4_u $push1=, $0
; SIMD128-NEXT:    i64x2.extend_high_i32x4_s $push0=, $0
; SIMD128-NEXT:    i64x2.add $push2=, $pop1, $pop0
; SIMD128-NEXT:    return $pop2
 %shuffle = shufflevector <4 x i32> %in, <4 x i32> poison, <2 x i32> <i32 2, i32 3>
 %zext = zext <2 x i32> %shuffle to <2 x i64>
 %sext = sext <2 x i32> %shuffle to <2 x i64>
 %res = add <2 x i64> %zext, %sext
 ret <2 x i64> %res
}
