; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=ipsccp %s | FileCheck %s

declare void @use(i1)

define i1 @test1(i64 %x) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND:%.*]] = icmp ugt i64 [[X:%.*]], 65535
; CHECK-NEXT:    call void @llvm.assume(i1 [[COND]])
; CHECK-NEXT:    [[MASK:%.*]] = and i64 [[X]], -65521
; CHECK-NEXT:    ret i1 false
;
entry:
  %cond = icmp ugt i64 %x, 65535
  call void @llvm.assume(i1 %cond)
  %mask = and i64 %x, -65521
  %cmp = icmp eq i64 %mask, 0
  ret i1 %cmp
}

define void @test.and(i64 %x, i64 %y) {
; CHECK-LABEL: @test.and(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp uge i64 [[X:%.*]], 138
; CHECK-NEXT:    [[C1:%.*]] = icmp ule i64 [[X]], 161
; CHECK-NEXT:    call void @llvm.assume(i1 [[C0]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[C1]])
; CHECK-NEXT:    [[C2:%.*]] = icmp uge i64 [[Y:%.*]], 186
; CHECK-NEXT:    [[C3:%.*]] = icmp ule i64 [[Y]], 188
; CHECK-NEXT:    call void @llvm.assume(i1 [[C2]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[C3]])
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[X]], [[Y]]
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[R1:%.*]] = icmp ult i64 [[AND]], 137
; CHECK-NEXT:    call void @use(i1 [[R1]])
; CHECK-NEXT:    ret void
;
entry:
  %c0 = icmp uge i64 %x, 138 ; 0b10001010
  %c1 = icmp ule i64 %x, 161 ; 0b10100000
  call void @llvm.assume(i1 %c0)
  call void @llvm.assume(i1 %c1)
  %c2 = icmp uge i64 %y, 186 ; 0b10111010
  %c3 = icmp ule i64 %y, 188 ; 0b10111110
  call void @llvm.assume(i1 %c2)
  call void @llvm.assume(i1 %c3)
  %and = and i64 %x, %y
  %r0 = icmp ult i64 %and, 136 ; 0b10001000
  call void @use(i1 %r0) ; false
  %r1 = icmp ult i64 %and, 137
  call void @use(i1 %r1) ; unknown
  ret void
}

define void @test.or(i64 %x, i64 %y) {
; CHECK-LABEL: @test.or(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp ule i64 [[X:%.*]], 117
; CHECK-NEXT:    [[C1:%.*]] = icmp uge i64 [[X]], 95
; CHECK-NEXT:    call void @llvm.assume(i1 [[C0]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[C1]])
; CHECK-NEXT:    [[C2:%.*]] = icmp ule i64 [[Y:%.*]], 69
; CHECK-NEXT:    [[C3:%.*]] = icmp uge i64 [[Y]], 67
; CHECK-NEXT:    call void @llvm.assume(i1 [[C2]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[C3]])
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[X]], [[Y]]
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[R1:%.*]] = icmp ugt i64 [[OR]], 118
; CHECK-NEXT:    call void @use(i1 [[R1]])
; CHECK-NEXT:    ret void
;
entry:
  %c0 = icmp ule i64 %x, 117 ; 0b01110101
  %c1 = icmp uge i64 %x, 95  ; 0b01011111
  call void @llvm.assume(i1 %c0)
  call void @llvm.assume(i1 %c1)
  %c2 = icmp ule i64 %y, 69  ; 0b01000101
  %c3 = icmp uge i64 %y, 67  ; 0b01000011
  call void @llvm.assume(i1 %c2)
  call void @llvm.assume(i1 %c3)
  %or = or i64 %x, %y
  %r0 = icmp ugt i64 %or, 119 ; 0b01110111
  call void @use(i1 %r0) ; false
  %r1 = icmp ugt i64 %or, 118
  call void @use(i1 %r1) ; unknown
  ret void
}
